Gaussian[] gaussians;
GaussianMixture mixture;

// @pjs preload must be used to preload the image 
/* @pjs preload="left_hand_karmin.png"; */
/* @pjs preload="left_hand_gold.png"; */
/* @pjs preload="right_hand_karmin.png"; */
/* @pjs preload="right_hand_gold.png"; */
/* @pjs preload="LeapSymbol.png"; */
/* @pjs preload="FlowerSymbol.png"; */
/* @pjs preload="BasketSymbol.png"; */

PImage leftHandKarminIcon  = loadImage("left_hand_karmin.png");
PImage leftHandGoldIcon    = loadImage("left_hand_gold.png");
PImage rightHandKarminIcon = loadImage("right_hand_karmin.png");
PImage rightHandGoldIcon   = loadImage("right_hand_gold.png");
PImage leapSymbolIcon      = loadImage("LeapSymbol.png");
PImage flowerSymbolIcon    = loadImage("FlowerSymbol.png");
PImage basketSymbolIcon    = loadImage("BasketSymbol.png");

float xoffset;
float zoffset;

int over = 0;
boolean press = false;
boolean locked = false;

float lStart;
float lEnd;

float lxYPos;
float lzYPos;

float boxSize = 10;
float propAdapt = .25;
float visuAdapt = 0.5;

boolean hoveringDisp;
boolean hoveringDisc;
boolean hoveringDrif;
boolean showDisp;
boolean showDisc;
boolean showDrif;

void setup() {
  size(600, 400);
  frameRate( 30 );
  
  PFont font;
  font = loadFont("FFScala.ttf"); 
  textFont(font, 14);
  
  xoffset = 0.0f;
  zoffset = 0.0f;
  
  lStart = this.width / 4;
  lEnd   = 3 * this.width / 4;
  
  lxYPos = 370;
  lzYPos = 385;
  
  showDisp = false;
  showDisc = false;
  showDrif = false;
}

void draw() {
  if (leftHandKarminIcon.width != 70) {
    leftHandKarminIcon.resize(70, 0);
  }
  if (leftHandGoldIcon.width != 70) {
    leftHandGoldIcon.resize(70, 0);
  }
  if (rightHandKarminIcon.width != 70) {
    rightHandKarminIcon.resize(70, 0);
  }
  if (rightHandGoldIcon.width != 70) {
    rightHandGoldIcon.resize(70, 0);
  }
  if (leapSymbolIcon.width != 160) {
    leapSymbolIcon.resize(160, 0);
  }
  if (flowerSymbolIcon.width != 80) {
    flowerSymbolIcon.resize(80, 0);
  }
  if (basketSymbolIcon.width !=80) {
    basketSymbolIcon.resize(80, 0);
  }
  
  updateOffsetCheck();
  
  // anthra
  background(50, 65, 75);
  strokeWeight(1);
  
  image(flowerSymbolIcon, this.width / 2 - flowerSymbolIcon.width / 2, this.height / 2 - flowerSymbolIcon.height / 2);
  image(basketSymbolIcon, 4 * this.width / 5 - basketSymbolIcon.width / 2, this.height / 4 - basketSymbolIcon.height / 2);
  image(leapSymbolIcon  , this.width / 2 - leapSymbolIcon.width / 2, 6 * this.height / 7 - leapSymbolIcon.height / 2);
  
  image(leftHandGoldIcon, this.width / 2 - 3 * leftHandGoldIcon.width / 2 + xoffset * (1 + zoffset / (this.width / 2)), this.height / 2 - leftHandGoldIcon.height / 2);
  image(rightHandGoldIcon, this.width / 2 + rightHandGoldIcon.width / 2 + xoffset * (1 + zoffset / (this.width / 2)), this.height / 2 - rightHandGoldIcon.height / 2);
  
  image(leftHandKarminIcon, this.width / 2 - 3 * leftHandGoldIcon.width / 2, this.height / 2 - leftHandGoldIcon.height / 2);
  image(rightHandKarminIcon, this.width / 2 + rightHandGoldIcon.width / 2, this.height / 2 - rightHandGoldIcon.height / 2);
  
  fill(165, 30, 55);
  stroke(180, 160, 105);
  
  float xoffsetPosition = xoffset + this.width / 2;
  float zoffsetPosition = zoffset + this.width / 2;
  
  rect(xoffsetPosition, lxYPos, boxSize, boxSize);
  rect(zoffsetPosition, lzYPos, boxSize, boxSize);
  
  if(over != 0 || press) {
    if (over == 1)
    {
       line(xoffsetPosition, lxYPos, xoffsetPosition + boxSize, lxYPos + boxSize);
       line(xoffsetPosition, lxYPos + boxSize, xoffsetPosition + boxSize, lxYPos);
    }
    else if (over == 2)
    {
       line(zoffsetPosition, lzYPos, zoffsetPosition + boxSize, lzYPos + boxSize);
       line(zoffsetPosition, lzYPos + boxSize, zoffsetPosition + boxSize, lzYPos);
    }
  }
  textAlign(LEFT);
  fill(180, 160, 105);
  text("x - Offset:", 50, lxYPos + (textDescent() + textAscent()) * 0.0 + boxSize);
  text("visual capture:", 50, lzYPos + (textDescent() + textAscent()) * 0.0 + boxSize);
  
  // draw buttons
  // discrepancy
  hoveringDisc = overRect(width * .85, height * .9, 70, 30);
  if (hoveringDisc)
  {
    // karmin
    stroke(165, 30, 55);
  }
  else
  {
    // gold
    stroke(180, 160, 105);
  }
  strokeWeight(2);
  fill(50, 65, 75);
 
  rect(width * .85, height * .9, 80, 30);
  if (hoveringDisc)
  {
    // karmin
    fill(165, 30, 55);
  }
  else
  {
    // gold
    fill(180, 160, 105);
  }
  textAlign(CENTER);
  String btext = "Discrepancy";
  text(btext, width * .85 + 80 / 2, height * .9 + 30 / 2 + (textDescent() + textAscent()) * 0.25);
  
  // disparity
  hoveringDisp = overRect(width * .85, height * .8, 70, 30);
  if (hoveringDisp)
  {
    // karmin
    stroke(165, 30, 55);
  }
  else
  {
    // gold
    stroke(180, 160, 105);
  }
  strokeWeight(2);
  fill(50, 65, 75);
 
  rect(width * .85, height * .8, 80, 30);
  if (hoveringDisp)
  {
    // karmin
    fill(165, 30, 55);
  }
  else
  {
    // gold
    fill(180, 160, 105);
  }
  textAlign(CENTER);
  String btext = "Disparity";
  text(btext, width * .85 + 80 / 2, height * .8 + 30 / 2 + (textDescent() + textAscent()) * 0.25);
  
  // drift
  hoveringDrif = overRect(width * .85, height * .7, 70, 30);
  if (hoveringDrif)
  {
    // karmin
    stroke(165, 30, 55);
  }
  else
  {
    // gold
    stroke(180, 160, 105);
  }
  strokeWeight(2);
  fill(50, 65, 75);
 
  rect(width * .85, height * .7, 80, 30);
  if (hoveringDrif)
  {
    // karmin
    fill(165, 30, 55);
  }
  else
  {
    // gold
    fill(180, 160, 105);
  }
  textAlign(CENTER);
  String btext = "Drift";
  text(btext, width * .85 + 80 / 2, height * .7 + 30 / 2 + (textDescent() + textAscent()) * 0.25);
  
  if (showDisp)
  {
    float dx, dy, maxX;
    strokeWeight(4);
    // karmin
    stroke(165, 30, 55);
    line(this.width / 2, this.height / 2,  this.width / 2, 6 * this.height / 7);
    line(this.width / 2, this.height / 2,  4 * this.width / 5 , this.height / 4);
    // reference points
    fill(55, 55, 180);
    ellipse(this.width / 2, this.height / 2, 10, 10);
    dx = ((this.width / 2) - (this.width / 2)) * .25;
    dy = ((6 * this.height / 7) - (this.height / 2)) * .25;
    ellipse(this.width / 2 + dx, this.height / 2 + dy, 10, 10);
    dx = ((4 * this.width / 5) - (this.width / 2)) * .25;
    dy = ((this.height / 4) - (this.height / 2)) * .25;
    ellipse(this.width / 2 + dx, this.height / 2 + dy, 10, 10);
    maxX = this.width / 2 + dx + 40;
    // arcs
    stroke(55, 55, 180);
    noFill();
    arc(this.width / 2 + dx, this.height / 2, 30, 2*dy, 0, 90 / 180 * PI);
    dx = ((this.width / 2) - (this.width / 2)) * .25;
    dy = ((6 * this.height / 7) - (this.height / 2)) * .25;
    arc(this.width / 2 + dx, this.height / 2, 30, 2*dy, 0, PI/2);
    line(this.width / 2, this.height / 2, maxX, this.height / 2);
    
    // gold
    stroke(180, 160, 105);
    line(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)), this.height / 2,  this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) * propAdapt, 6 * this.height / 7);
    line(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)), this.height / 2,  4 * this.width / 5 + xoffset * (1 + zoffset / (this.width / 2)) * visuAdapt, this.height / 4);
    
    // reference points
    fill(55, 180, 55);
    ellipse(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)), this.height / 2, 10, 10);
    dx = ((this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) * propAdapt) - (this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)))) * .25;
    dy = ((6 * this.height / 7) - (this.height / 2)) * .25;
    ellipse(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) + dx, this.height / 2 + dy, 10, 10);
    dx = ((4 * this.width / 5 + xoffset * (1 + zoffset / (this.width / 2)) * visuAdapt) - (this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)))) * .25;
    dy = ((this.height / 4) - (this.height / 2)) * .25;
    ellipse(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) + dx, this.height / 2 + dy, 10, 10);
    maxX = this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) + dx + 40;
    // arcs
    stroke(55, 180, 55);
    noFill();
    arc(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) + dx, this.height / 2, 30, 2*dy, 0, 90 / 180 * PI);
    dx = ((this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) * propAdapt) - (this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)))) * .25;
    dy = ((6 * this.height / 7) - (this.height / 2)) * .25;
    float extra = 0.0;
    if (dx < 0.0) {
      extra = extra - 2*dx;
    }
    arc(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) + dx, this.height / 2, 30 + extra, 2*dy, 0, PI/2);
    line(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)), this.height / 2, maxX, this.height / 2);
  }
  
  if (showDisc)
  {
    strokeWeight(4);
    // karmin
    stroke(165, 30, 55);
    line(this.width / 2, this.height / 2,  this.width / 2, 6 * this.height / 7);
    line(this.width / 2, this.height / 2,  4 * this.width / 5 , this.height / 4);
    // gold
    stroke(180, 160, 105);
    line(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)), this.height / 2,  this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) * propAdapt, 6 * this.height / 7);
    line(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)), this.height / 2,  4 * this.width / 5 + xoffset * (1 + zoffset / (this.width / 2)) * visuAdapt, this.height / 4);
    
    // lines between estimates
    line(4 * this.width / 5 , this.height / 4,  4 * this.width / 5 + xoffset * (1 + zoffset / (this.width / 2)) * visuAdapt, this.height / 4);
    
    line(this.width / 2, 6 * this.height / 7,  this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) * propAdapt, 6 * this.height / 7);
    fill(55, 180, 55);
    ellipse(4 * this.width / 5 , this.height / 4, 10, 10);
    ellipse(4 * this.width / 5 + xoffset * (1 + zoffset / (this.width / 2)) * visuAdapt, this.height / 4, 10, 10);
    
    ellipse(this.width / 2, 6 * this.height / 7, 10, 10);
    ellipse(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)) * propAdapt, 6 * this.height / 7, 10, 10);
  }
  
  if (showDrif)
  {
    strokeWeight(4);
    // gold
    stroke(180, 160, 105);
    line(this.width / 2, this.height / 2,  this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)), this.height / 2);
    //line(this.width / 2 + xoffset, this.height / 2 + zoffset,  this.width / 2, 6 * this.height / 7);
    //line(this.width / 2 + xoffset, this.height / 2 + zoffset,  4 * this.width / 5, this.height / 4);
    fill(55, 180, 55);
    ellipse(this.width / 2, this.height / 2, 10, 10);
    ellipse(this.width / 2 + xoffset * (1 + zoffset / (this.width / 2)), this.height / 2, 10, 10);
  }
}

void updateOffsetCheck() {
  isover();
  ispressed();
 
  if(press) {
    //println(mouseX + " " + lStart + " " + lEnd + " " + xoffset + " " + zoffset);
    float mouseVal = lock(mouseX, lStart, lEnd);
    if (over == 1)
    {
      xoffset = mouseVal - this.width / 2;
    }
    else if (over == 2)
    {
      zoffset = mouseVal - this.width / 2;
    }
  }
}

void isover() {
  if(overRect(this.width / 2 + xoffset, lxYPos - boxSize / 2, boxSize, boxSize)) {
    over = 1;
  } else if (overRect(this.width / 2 + zoffset, lzYPos - boxSize / 2, boxSize, boxSize)) {
    over = 2;
  } else {
    if (!locked) over = 0;
  }
}

void ispressed() {
  if((over != 0 && mousePressed) || locked) {
    press = true;
    locked = true;
  } else {
    press = false;
  }
}

void release() {
  locked = false;
}


void mouseReleased() {
  if (hoveringDisc)
  {
     showDisc = !showDisc;
     showDisp = false;
     showDrif = false;
  }
  if (hoveringDisp)
  {
     showDisp = !showDisp;
     showDrif = false;
     showDisc = false;
  }
  if (hoveringDrif)
  {
     showDrif = !showDrif;
     showDisp = false;
     showDisc = false;
  } 
  release();
}

boolean overRect(int x, int y, int width, int height) {
  if (mouseX >= x && mouseX <= x+width && mouseY >= y && mouseY <= y+height) {
    return true;
  } else {
    return false;
  }
}

int lock(int val, int minv, int maxv) { 
  return  min(max(val, minv), maxv);
}

