/*
 * Decompiled with CFR 0.152.
 */
package efault;

public class CommandLine {
    private static String[] optionNames = new String[]{"-genomeFastaFile", "-ncRNAcrdFile", "-siddProfile", "-siddSites", "-terminators", "-rFamScan", "-gffOutFile", "-version", "-help", "-promoter", "-rFamAll", "-overwrite", "-rFamSeeds", "-appendRfamHits", "-proteinTableFile", "-pcMatches", "-classifyNCRNAs", "-transcriptPrediction", "-plotPDFncRNARegions", "-numCPUs", "-interactions", "-appendInteractions", "-hunters", "-targets", "-DOTfromInteractions", "-importIntaRNA", "-GMLfromInteractions", "-plotJPGncRNARegions", "-doStuff", "-countNoRNAc", "-projectname", "-compare2Annotation", "-interactionProfiles", "-interactionMatrix", "-importTransTerm", "-debug", "-rnazAnalysis"};
    private static String[] optionInfos = new String[]{"path of a fasta file containing the sequence of the target genome", "path of a txt file containing locus information on predicted ncRNA regions", "if set, the sidd profile of the genome is computed", "if set, sidd sites are predicted for the target genome", "if set, terminator signals are predicted for the target genome", "path of a txt file containing ids of RNA motifs (Rfam) that will be searched in ncRNA regions", "path of the gff file that will created and contains the results", "if set, the version of the program is printed", "if set, this help is printed", "n.a.", "if set, for all rfam motifs contained in the provided seed file will be scanned", "if set, previously generated result files will be overwritten", "path of a file containing Rfam seeds", "if set, new Rfam hits will be appended to a previously generated file", "path of a ptt file containing gene annotations for the target genome", "path of a txt file containing regular expressions of sigma factor binding sites", "if set, predicted ncRNA regions are classified", "if set, ncRNA transcripts are predicted", "path of a txt file containing ncRNA region ids for which result plots are generated in pdf format", "the number of parallel processes that will be started by the program", "if set, RNA-RNA interactions are predicted", "if set, new interactions will be appended to a previously generated file", "path of a txt file containing ids of ncRNA regions that will be considered during the interaction prediction", "path of a txt file containing ids of proteins that will be considered during the interaction prediction", "create a DOT file (interactions.dot) in the current genome folder containing a graph representation\n\tof a previously predicted RNA-RNA interaction network", "path of an intaRNA output file that will imported for the current genome", "create a GML file (interactions.gml) in the current genome folder containing a graph representation\n\tof a previously predicted RNA-RNA interaction network", "path of a txt file containing ncRNA region ids for which result plots are generated in jpg format", "NA", "start the interactive countNoRNAc R shell", "set the name of the folder in which the results are stored (no whitespace)\n\tif omitted, the name is set automatically", "path of a GFF file containing annotations for the current genome\n\tto which the ncRNA loci and predicted ncRNA transcripts will be compared", "if set files will be generated in the genome folder containing calculated interaction profiles\n\tfor each element of previously predicted interactions\n\t(iProfileN.tsv, iProfileG.tsv, iProfileP.tsv, iProfilePnet.tsv)", "if set thet file iMatrix.tsv will be generated in the genome folder containing\n\tthe transcript interaction matrix of a previously predicted interaction network", "path of a TransTermHP output file that will imported for the current genome", "NA", "performe an RNAz analysis on all predicted ncRNA transcripts"};
    private int[] booleanIndices = new int[]{2, 3, 4, 7, 8, 10, 11, 13, 16, 17, 20, 21, 28, 29, 32, 33, 24, 26, 35, 36};
    private int[] infoPrintOrder;
    private String[] optionValues;

    public CommandLine(String[] commandLine) {
        int[] nArray = new int[31];
        nArray[0] = 30;
        nArray[2] = 1;
        nArray[3] = 14;
        nArray[4] = 6;
        nArray[5] = 2;
        nArray[6] = 3;
        nArray[7] = 4;
        nArray[8] = 34;
        nArray[9] = 5;
        nArray[10] = 10;
        nArray[11] = 12;
        nArray[12] = 13;
        nArray[13] = 31;
        nArray[14] = 15;
        nArray[15] = 18;
        nArray[16] = 27;
        nArray[17] = 20;
        nArray[18] = 22;
        nArray[19] = 23;
        nArray[20] = 21;
        nArray[21] = 25;
        nArray[22] = 24;
        nArray[23] = 26;
        nArray[24] = 32;
        nArray[25] = 33;
        nArray[26] = 11;
        nArray[27] = 19;
        nArray[28] = 8;
        nArray[29] = 7;
        nArray[30] = 29;
        this.infoPrintOrder = nArray;
        this.optionValues = new String[optionNames.length];
        this.parseCommandLine(commandLine);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseCommandLine(String[] commandLine) {
        int i = 0;
        while (i < commandLine.length) {
            String value;
            String name = commandLine[i];
            if (!this.isOptionBoolean(name)) {
                if (i + 1 >= commandLine.length) throw new Error("No value given for parameter " + name);
                value = commandLine[i + 1];
            } else {
                value = "true";
                --i;
            }
            this.setOptionValue(name, value);
            i += 2;
        }
    }

    private boolean isOptionBoolean(String optionName) {
        String fullName = this.getFullOptionName(optionName);
        int i = 0;
        while (i < this.booleanIndices.length) {
            if (optionNames[this.booleanIndices[i]].equalsIgnoreCase(fullName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getName(int i) {
        return optionNames[i];
    }

    public String getValue(int i) {
        return this.optionValues[i];
    }

    public String getValueByName(String optionName) {
        int i = 0;
        while (i < optionNames.length) {
            if (optionNames[i].equalsIgnoreCase(optionName)) {
                return this.optionValues[i];
            }
            ++i;
        }
        return null;
    }

    public int getNumberOfNames() {
        return optionNames.length;
    }

    public boolean doesOptionNameExist(String optionName) {
        int i = 0;
        while (i < optionNames.length) {
            if (optionNames[i].equalsIgnoreCase(optionName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSet(String optionName) {
        return this.getValueByName(optionName) != null;
    }

    public boolean isSet(int optionIndex) {
        return this.optionValues[optionIndex] != null;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < optionNames.length) {
            res.append(optionNames[i]);
            res.append(" ");
            res.append(this.optionValues[i]);
            res.append("\r");
            ++i;
        }
        return res.toString();
    }

    public String toHelpString() {
        StringBuffer sb = new StringBuffer();
        int[] nArray = this.infoPrintOrder;
        int n = this.infoPrintOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            sb.append("  " + optionNames[i] + "\n\t" + optionInfos[i] + "\n");
            ++n2;
        }
        return sb.toString();
    }

    private void setOptionValue(String optionName, String optionValue) {
        int matches = 0;
        int i = 0;
        while (i < optionNames.length) {
            if (optionNames[i].regionMatches(true, 0, optionName, 0, optionName.length())) {
                ++matches;
                this.optionValues[i] = optionValue;
            }
            ++i;
        }
        if (matches == 1) {
            return;
        }
        if (matches > 1) {
            System.err.println("Command line error!");
            System.err.println("Type 'java -jar nocoRNAc.jar -help' for a list of parameters.");
            throw new Error("ambiguous argument: " + optionName);
        }
        System.err.println("Command line error!");
        System.err.println("Type 'java -jar nocoRNAc.jar -help' for a list of parameters.");
        throw new Error("unknown argument: " + optionName);
    }

    private String getFullOptionName(String optionName) {
        int matches = 0;
        String res = null;
        int i = 0;
        while (i < optionNames.length) {
            if (optionNames[i].regionMatches(true, 0, optionName, 0, optionName.length())) {
                ++matches;
                res = optionNames[i];
            }
            ++i;
        }
        if (matches == 1) {
            return res;
        }
        if (matches > 1) {
            System.err.println("Command line error!");
            System.err.println("Type 'java -jar nocoRNAc.jar -help' for a list of parameters.");
            throw new Error("ambiguous argument: " + optionName);
        }
        System.err.println("Command line error!");
        System.err.println("Type 'java -jar nocoRNAc.jar -help' for a list of parameters.");
        throw new Error("unknown argument: " + optionName);
    }
}

