/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import efault.Config;
import efault.Main;
import genomic.ArrayProbe;
import genomic.Gene;
import genomic.MASequenceFeature;
import genomic.NCRNATranscript;
import interact.TranskriptInteraction;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import promoter.PCMatch;
import rfam.RfamHit;
import rfam.RfamTest;
import seq.Sequence;
import sidd.SIDDSite;
import term.Terminator;

public class NCRNA
extends MASequenceFeature {
    public static final char NOT_CLASSIFIED = '.';
    public static final char NONE = 'X';
    public static final char OWN_TERMINATOR = 'T';
    public static final char SHARED_TERMINATOR = 't';
    public static final char GENE = 'G';
    public static final char ANTISENSE = 'A';
    public static final char ANTISENSE_SHARED_TERMINATOR = 'a';
    public static final char OWN_SIDDSITE = 'S';
    public static final char SHARED_SIDDSITE = 's';
    public static final char ANTISENSE_SHARED_SIDDSITE = 'a';
    public static final char OWN_PCMATCH = 'P';
    public static final char SHARED_PCMATCH = 'p';
    public static final char ANTISENSE_SHARED_PCMATCH = 'a';
    private static boolean allowNonTerminatorTranscripts = Config.getBoolean("allowNonTerminatorTranscripts");
    private static boolean mergeOverlappingTranscripts = Config.getBoolean("mergeOverlappingTranscripts");
    private static boolean noTerminatorSelection = Config.getBoolean("noTerminatorSelection");
    private static boolean forceStrandSpecification = Config.getBoolean("forceStrandSpecification");
    private static boolean transcriptPredictionIgnoreStrand = Config.getBoolean("transcriptPredictionIgnoreStrand");
    private static boolean noSenseGeneOverlappingTranscripts = Config.getBoolean("noSenseGeneOverlappingTranscripts");
    private static final int siddUpstreamRegionSize = Config.getInt("siddUpstreamRegionSize");
    private static final double siddRelativeStart = Config.getDouble("siddRelativeStart");
    private static final int minLength = Config.getInt("minTranscriptLength");
    private static final int maxLength = Config.getInt("maxTranscriptLength");
    private List<Terminator> terminators;
    private List<SIDDSite> siddSites;
    private List<Gene> genes;
    private List<PCMatch> pcMatches;
    private List<RfamHit> rfamHits;
    private List<NCRNATranscript> tUnits;
    private List<ArrayProbe> igProbes;
    private List<RfamTest> annotations;
    private double score = 0.0;
    private String source = "input";
    private char terminationClass = (char)46;
    private char siddClass = (char)46;
    private char pcClass = (char)46;

    public NCRNA() {
        this.terminators = new LinkedList<Terminator>();
        this.siddSites = new LinkedList<SIDDSite>();
        this.pcMatches = new LinkedList<PCMatch>();
        this.genes = new LinkedList<Gene>();
        this.rfamHits = new LinkedList<RfamHit>();
        this.tUnits = new LinkedList<NCRNATranscript>();
        this.igProbes = new LinkedList<ArrayProbe>();
        this.annotations = new LinkedList<RfamTest>();
    }

    public NCRNA(String ID, int start, int end, char strand, double score) {
        super(ID, start, end, strand);
        this.terminators = new LinkedList<Terminator>();
        this.siddSites = new LinkedList<SIDDSite>();
        this.pcMatches = new LinkedList<PCMatch>();
        this.genes = new LinkedList<Gene>();
        this.rfamHits = new LinkedList<RfamHit>();
        this.tUnits = new LinkedList<NCRNATranscript>();
        this.igProbes = new LinkedList<ArrayProbe>();
        this.annotations = new LinkedList<RfamTest>();
        this.score = score;
    }

    public void classifyTermination() {
        boolean gene = false;
        boolean ownTerm = false;
        boolean sharedTerm = false;
        boolean antisenseTerm = false;
        this.terminationClass = (char)88;
        Iterator<Terminator> termIt = this.terminators.iterator();
        if (this.numGenes() > 0) {
            gene = true;
        }
        block0: while (termIt.hasNext()) {
            Terminator currTerm = termIt.next();
            if (currTerm.getGeneContext() == '.') {
                this.terminationClass = (char)46;
                return;
            }
            if (!this.inProperNCRNAContext(currTerm)) continue;
            sharedTerm = true;
            if (currTerm.getGeneContext() != 'G') {
                ownTerm = true;
            }
            for (Gene currGene : this.genes) {
                if (currTerm.getStrand() == currGene.getStrand()) continue;
                antisenseTerm = true;
                continue block0;
            }
        }
        if (antisenseTerm) {
            if (sharedTerm) {
                this.terminationClass = (char)97;
            }
            if (ownTerm) {
                this.terminationClass = (char)65;
            }
        } else {
            if (gene) {
                this.terminationClass = (char)88;
            }
            if (sharedTerm) {
                this.terminationClass = (char)116;
            }
            if (ownTerm) {
                this.terminationClass = (char)84;
            }
        }
    }

    public void classifySIDDSites() {
        boolean gene = false;
        boolean ownSIDD = false;
        boolean sharedSIDD = false;
        boolean antisenseSIDD = false;
        this.siddClass = (char)88;
        Iterator<SIDDSite> siddIt = this.siddSites.iterator();
        if (this.numGenes() > 0) {
            gene = true;
            while (siddIt.hasNext()) {
                SIDDSite currSidd = siddIt.next();
                for (Gene currGene : this.genes) {
                    if (!this.inProperAntisenseContext(currSidd, currGene)) continue;
                    antisenseSIDD = true;
                }
                if (antisenseSIDD) break;
            }
        }
        for (SIDDSite currSidd : this.siddSites) {
            if (currSidd.getGeneContext() == '.') {
                this.siddClass = (char)46;
                return;
            }
            sharedSIDD = true;
            if (currSidd.getGeneContext() == 'P') continue;
            ownSIDD = true;
        }
        if (antisenseSIDD) {
            if (sharedSIDD) {
                this.siddClass = (char)97;
            }
            if (ownSIDD) {
                this.siddClass = (char)65;
            }
        } else {
            if (gene) {
                this.siddClass = (char)88;
            }
            if (sharedSIDD) {
                this.siddClass = (char)115;
            }
            if (ownSIDD) {
                this.siddClass = (char)83;
            }
        }
    }

    public void classifyPCMatches() {
        boolean gene = false;
        boolean ownPCM = false;
        boolean sharedPCM = false;
        boolean antisensePCM = false;
        this.pcClass = (char)88;
        Iterator<PCMatch> pcMatchIt = this.pcMatches.iterator();
        if (this.numGenes() > 0) {
            gene = true;
        }
        block0: while (pcMatchIt.hasNext()) {
            PCMatch currPCM = pcMatchIt.next();
            if (currPCM.getGeneContext() == '.') {
                this.pcClass = (char)46;
                return;
            }
            if (!this.inProperNCRNAContext(currPCM)) continue;
            sharedPCM = true;
            if (currPCM.getGeneContext() != 'G') {
                ownPCM = true;
            }
            for (Gene currGene : this.genes) {
                if (currPCM.getStrand() == currGene.getStrand()) continue;
                antisensePCM = true;
                continue block0;
            }
        }
        if (antisensePCM) {
            if (sharedPCM) {
                this.pcClass = (char)97;
            }
            if (ownPCM) {
                this.pcClass = (char)65;
            }
        } else {
            if (gene) {
                this.pcClass = (char)88;
            }
            if (sharedPCM) {
                this.pcClass = (char)112;
            }
            if (ownPCM) {
                this.pcClass = (char)80;
            }
        }
    }

    public void predictNCRNATranscripts() {
        NCRNATranscript tmpTU;
        LinkedList<Terminator> suboptimalTerms;
        ListIterator<Terminator> termIt;
        int tmpPos;
        SIDDSite currSidd;
        this.clearPredictedNCRNATranscripts();
        Collections.sort(this.terminators);
        int tuCounter = 1;
        Terminator currTerm = null;
        Terminator bestTerm = null;
        Iterator<SIDDSite> siddIt = this.siddSites.iterator();
        while (siddIt.hasNext() && (this.getStrand() != '-' || transcriptPredictionIgnoreStrand)) {
            currSidd = siddIt.next();
            if (currSidd.getStrand() == '-' || currSidd.getStart() > this.getEnd()) continue;
            tmpPos = (int)Math.max((double)currSidd.getStart() + (double)currSidd.getLength() * siddRelativeStart, (double)(this.getStart() - siddUpstreamRegionSize));
            termIt = this.terminators.listIterator();
            while (termIt.hasNext()) {
                currTerm = termIt.next();
                if (currTerm.getStrand() != '+') {
                    currTerm = null;
                    continue;
                }
                if (currTerm.getStart() < this.getStart()) {
                    currTerm = null;
                    continue;
                }
                if (currTerm.getEnd() - tmpPos + 1 < minLength) {
                    currTerm = null;
                    continue;
                }
                if (currTerm.getEnd() - tmpPos + 1 <= maxLength) break;
                currTerm = null;
                break;
            }
            if (currTerm == null) {
                if (currSidd.getGeneContext() != 'X' || !allowNonTerminatorTranscripts || this.getEnd() - tmpPos + 1 < minLength || this.getEnd() - tmpPos + 1 > maxLength) continue;
                this.tUnits.add(new NCRNATranscript("ncRNA_" + this.getID() + "_" + tuCounter++, tmpPos, this.getEnd(), '+', currSidd, null, this));
                continue;
            }
            suboptimalTerms = new LinkedList<Terminator>();
            termIt.previous();
            bestTerm = currTerm;
            while (termIt.hasNext()) {
                currTerm = termIt.next();
                if (currTerm.getStrand() != '+') continue;
                if (currTerm.getEnd() - tmpPos + 1 > maxLength) break;
                if (noTerminatorSelection) {
                    this.tUnits.add(new NCRNATranscript("ncRNA_" + this.getID() + "_" + tuCounter++, tmpPos, currTerm.getEnd(), '+', currSidd, currTerm, this));
                }
                suboptimalTerms.add(currTerm);
                if (currTerm.isHighConfidence() && !noTerminatorSelection) {
                    bestTerm = currTerm;
                    break;
                }
                if (currTerm.getConfidence() <= bestTerm.getConfidence()) continue;
                bestTerm = currTerm;
            }
            tmpTU = new NCRNATranscript("ncRNA_" + this.getID() + "_" + tuCounter++, tmpPos, ((Terminator)suboptimalTerms.get(suboptimalTerms.size() - 1)).getEnd(), '+', currSidd, (Terminator)suboptimalTerms.get(suboptimalTerms.size() - 1), this);
            tmpTU.setSuboptimalTerminators(suboptimalTerms);
            if (noTerminatorSelection) continue;
            this.tUnits.add(tmpTU);
        }
        siddIt = this.siddSites.iterator();
        while (siddIt.hasNext() && (this.getStrand() != '+' || transcriptPredictionIgnoreStrand)) {
            currSidd = siddIt.next();
            if (currSidd.getStrand() == '+' || currSidd.getEnd() < this.getStart()) continue;
            tmpPos = (int)Math.min((double)currSidd.getEnd() - (double)currSidd.getLength() * siddRelativeStart, (double)(this.getEnd() + siddUpstreamRegionSize));
            termIt = this.terminators.listIterator(this.terminators.size());
            while (termIt.hasPrevious()) {
                currTerm = termIt.previous();
                if (currTerm.getStrand() != '-') {
                    currTerm = null;
                    continue;
                }
                if (currTerm.getEnd() > this.getEnd()) {
                    currTerm = null;
                    continue;
                }
                if (tmpPos - currTerm.getStart() + 1 < minLength) {
                    currTerm = null;
                    continue;
                }
                if (tmpPos - currTerm.getStart() + 1 <= maxLength) break;
                currTerm = null;
                break;
            }
            if (currTerm == null) {
                if (currSidd.getGeneContext() != 'X' || !allowNonTerminatorTranscripts || tmpPos - this.getStart() + 1 < minLength || tmpPos - this.getStart() + 1 > maxLength) continue;
                this.tUnits.add(new NCRNATranscript("ncRNA_" + this.getID() + "_" + tuCounter++, this.getStart(), tmpPos, '-', currSidd, null, this));
                continue;
            }
            suboptimalTerms = new LinkedList();
            termIt.next();
            bestTerm = currTerm;
            while (termIt.hasPrevious()) {
                currTerm = termIt.previous();
                if (currTerm.getStrand() != '-') continue;
                if (tmpPos - currTerm.getStart() + 1 > maxLength) break;
                if (noTerminatorSelection) {
                    this.tUnits.add(new NCRNATranscript("ncRNA_" + this.getID() + "_" + tuCounter++, tmpPos, currTerm.getStart(), '-', currSidd, currTerm, this));
                }
                suboptimalTerms.add(currTerm);
                if (currTerm.isHighConfidence() && !noTerminatorSelection) {
                    bestTerm = currTerm;
                    break;
                }
                if (currTerm.getConfidence() <= bestTerm.getConfidence()) continue;
                bestTerm = currTerm;
            }
            tmpTU = new NCRNATranscript("ncRNA_" + this.getID() + "_" + tuCounter++, ((Terminator)suboptimalTerms.get(suboptimalTerms.size() - 1)).getStart(), tmpPos, '-', currSidd, (Terminator)suboptimalTerms.get(suboptimalTerms.size() - 1), this);
            tmpTU.setSuboptimalTerminators(suboptimalTerms);
            if (noTerminatorSelection) continue;
            this.tUnits.add(tmpTU);
        }
        if (noSenseGeneOverlappingTranscripts) {
            this.removeSenseGeneOverlappingTranscripts();
        }
        if (forceStrandSpecification) {
            this.specifyStrandByTUselection();
        }
        if (mergeOverlappingTranscripts) {
            this.joinOverlappingTUnits();
        }
    }

    private void removeSenseGeneOverlappingTranscripts() {
        LinkedList<NCRNATranscript> res = new LinkedList<NCRNATranscript>();
        for (NCRNATranscript t : this.tUnits) {
            boolean keep = true;
            for (Gene g : this.genes) {
                if (t.numOverlappingBases(g) <= 0 || g.getStrand() != t.getStrand()) continue;
                keep = false;
                break;
            }
            if (!keep) continue;
            res.add(t);
        }
        this.tUnits = res;
    }

    private void joinOverlappingTUnits() {
        char[] strands;
        LinkedList<NCRNATranscript> joined = new LinkedList<NCRNATranscript>();
        int counter = 1;
        Collections.sort(this.tUnits);
        char[] cArray = strands = new char[]{'+', '-'};
        int n = strands.length;
        int n2 = 0;
        while (n2 < n) {
            char strand = cArray[n2];
            int tmpStart = -1;
            int tmpEnd = -1;
            Terminator tmpTerm = null;
            SIDDSite tmpSidd = null;
            for (NCRNATranscript tu : this.tUnits) {
                if (tu.getStrand() != strand) continue;
                if (tmpStart == -1) {
                    tmpStart = tu.getStart();
                    tmpEnd = tu.getEnd();
                    tmpTerm = tu.getTerminator();
                    tmpSidd = tu.getSiddSite();
                    continue;
                }
                if (tu.getStart() <= tmpEnd) {
                    if (tu.getEnd() <= tmpEnd) continue;
                    tmpEnd = tu.getEnd();
                    if (strand == '+') {
                        tmpTerm = tu.getTerminator();
                        continue;
                    }
                    tmpSidd = tu.getSiddSite();
                    continue;
                }
                joined.add(new NCRNATranscript("ncRNA_" + this.getID() + "_" + counter++, tmpStart, tmpEnd, strand, tmpSidd, tmpTerm, this));
                tmpStart = tu.getStart();
                tmpEnd = tu.getEnd();
                tmpTerm = tu.getTerminator();
                tmpSidd = tu.getSiddSite();
            }
            if (tmpStart != -1) {
                joined.add(new NCRNATranscript("ncRNA_" + this.getID() + "_" + counter++, tmpStart, tmpEnd, strand, tmpSidd, tmpTerm, this));
            }
            ++n2;
        }
        this.tUnits = joined;
    }

    private void specifyStrandByTUselection() {
        Comparator<NCRNATranscript> termSiddComp = new Comparator<NCRNATranscript>(){

            @Override
            public int compare(NCRNATranscript o1, NCRNATranscript o2) {
                int res = 0;
                if (o1.getTerminator() != null && o2.getTerminator() != null) {
                    if (o1.getTerminator().getConfidence() > o2.getTerminator().getConfidence()) {
                        res = 1;
                    }
                    if (o1.getTerminator().getConfidence() < o2.getTerminator().getConfidence()) {
                        res = -1;
                    }
                }
                if (res == 0) {
                    if (o1.getSiddSite().getMinIncEnergy() < o2.getSiddSite().getMinIncEnergy()) {
                        res = 1;
                    }
                    if (o1.getSiddSite().getMinIncEnergy() > o2.getSiddSite().getMinIncEnergy()) {
                        res = -1;
                    }
                }
                return res;
            }
        };
        LinkedList<NCRNATranscript> fowTUs = new LinkedList<NCRNATranscript>();
        LinkedList<NCRNATranscript> revTUs = new LinkedList<NCRNATranscript>();
        LinkedList<NCRNATranscript> survivers = new LinkedList<NCRNATranscript>();
        for (NCRNATranscript tu : this.tUnits) {
            if (tu.getStrand() == '+') {
                fowTUs.add(tu);
                continue;
            }
            revTUs.add(tu);
        }
        Collections.sort(fowTUs, Collections.reverseOrder(termSiddComp));
        Collections.sort(revTUs, Collections.reverseOrder(termSiddComp));
        LinkedList<NCRNATranscript> toBeDeleted = new LinkedList<NCRNATranscript>();
        for (NCRNATranscript tu : fowTUs) {
            boolean tmpSurvive = true;
            toBeDeleted.clear();
            for (NCRNATranscript tu2 : revTUs) {
                if (tu.shortenEachOther(tu2)) continue;
                if (termSiddComp.compare(tu, tu2) < 0) {
                    tmpSurvive = false;
                    break;
                }
                toBeDeleted.add(tu2);
            }
            if (tmpSurvive) {
                survivers.add(tu);
            }
            revTUs.removeAll(toBeDeleted);
        }
        survivers.addAll(revTUs);
        Collections.sort(survivers);
        this.tUnits = survivers;
    }

    public char getTerminationClass() {
        return this.terminationClass;
    }

    public void addTerminator(Terminator term) {
        this.terminators.add(term);
    }

    private boolean inProperNCRNAContext(Terminator term) {
        if (term.getStrand() == '+' && term.getStart() > this.getStart()) {
            return true;
        }
        return term.getStrand() == '-' && term.getEnd() < this.getEnd();
    }

    private boolean inProperNCRNAContext(PCMatch pcMatch) {
        if (pcMatch.getStrand() == '-' && pcMatch.getStart() > this.getStart()) {
            return true;
        }
        return pcMatch.getStrand() == '+' && pcMatch.getEnd() < this.getEnd();
    }

    private boolean inProperAntisenseContext(SIDDSite sidd, Gene gene) {
        if (gene.getStrand() == '+') {
            return sidd.getEnd() > this.getStart();
        }
        if (gene.getStrand() == '-') {
            return sidd.getStart() < this.getEnd();
        }
        return false;
    }

    public void clearTerminators() {
        this.terminators = new LinkedList<Terminator>();
    }

    public void removeOverlappingTerminators() {
        double overlapPercentage = 0.5;
        LinkedList<Terminator> termsToRemove = new LinkedList<Terminator>();
        ListIterator<Terminator> outerTermsIt = this.terminators.listIterator();
        block0: while (outerTermsIt.hasNext()) {
            Terminator outerCurrTerm = outerTermsIt.next();
            if (termsToRemove.contains(outerCurrTerm)) continue;
            ListIterator<Terminator> innerTermsIt = this.terminators.listIterator();
            while (innerTermsIt.hasNext()) {
                Terminator innerCurrTerm = innerTermsIt.next();
                if (termsToRemove.contains(innerCurrTerm) || outerCurrTerm == innerCurrTerm) continue;
                int tmpOverl = outerCurrTerm.numOverlappingBases(innerCurrTerm);
                if (outerCurrTerm.getStrand() != innerCurrTerm.getStrand() || !(Math.max((double)tmpOverl / (double)outerCurrTerm.getLength(), (double)tmpOverl / (double)innerCurrTerm.getLength()) > overlapPercentage)) continue;
                if (outerCurrTerm.getConfidence() > innerCurrTerm.getConfidence()) {
                    termsToRemove.add(innerCurrTerm);
                    continue;
                }
                termsToRemove.add(outerCurrTerm);
                continue block0;
            }
        }
        Iterator termsToRemIt = termsToRemove.iterator();
        while (termsToRemIt.hasNext()) {
            this.terminators.remove(termsToRemIt.next());
        }
    }

    public List<Terminator> getTerminators() {
        return this.terminators;
    }

    public Terminator getBestTerminator(char strand) {
        Terminator best = null;
        for (Terminator tmp : this.terminators) {
            if (tmp.getStrand() != strand || best != null && tmp.getConfidence() <= best.getConfidence()) continue;
            best = tmp;
        }
        return best;
    }

    public int numTerminators() {
        return this.terminators.size();
    }

    public void addGene(Gene gene) {
        this.genes.add(gene);
    }

    public void clearGenes() {
        this.genes = new LinkedList<Gene>();
    }

    public List<Gene> getGenes() {
        return this.genes;
    }

    public int numGenes() {
        return this.genes.size();
    }

    public char getGeneClass() {
        if (this.numGenes() > 0) {
            return 'G';
        }
        return 'X';
    }

    public void addSIDDSite(SIDDSite sidd) {
        this.siddSites.add(sidd);
    }

    public void clearSIDDSites() {
        this.siddSites = new LinkedList<SIDDSite>();
    }

    public List<SIDDSite> getSIDDSites() {
        return this.siddSites;
    }

    public int numSIDDSites() {
        return this.siddSites.size();
    }

    public char getSiddClass() {
        return this.siddClass;
    }

    public void addRfamHit(RfamHit rfamHit) {
        this.rfamHits.add(rfamHit);
    }

    public void clearRfamHits() {
        this.rfamHits = new LinkedList<RfamHit>();
    }

    public List<RfamHit> getRfamHits() {
        return this.rfamHits;
    }

    public int numRfamHits() {
        return this.rfamHits.size();
    }

    public void addPCMatch(PCMatch pcMatch) {
        this.pcMatches.add(pcMatch);
    }

    public void clearPCMatches() {
        this.pcMatches = new LinkedList<PCMatch>();
    }

    public List<PCMatch> getPCMatches() {
        return this.pcMatches;
    }

    public int numPCMatches() {
        return this.pcMatches.size();
    }

    public char getPcClass() {
        return this.pcClass;
    }

    public void setSource(String s) {
        this.source = s;
    }

    public void addPredictedNCRNATranscript(NCRNATranscript tUnit) {
        this.tUnits.add(tUnit);
    }

    public void clearPredictedNCRNATranscripts() {
        this.tUnits = new LinkedList<NCRNATranscript>();
    }

    public List<NCRNATranscript> getPredictedNCRNATranscripts() {
        return this.tUnits;
    }

    public int numPredictedNCRNATranscripts() {
        return this.tUnits.size();
    }

    public void addIGProbe(ArrayProbe probe) {
        this.igProbes.add(probe);
    }

    public void clearIGProbes() {
        this.igProbes = new LinkedList<ArrayProbe>();
    }

    public List<ArrayProbe> getIGProbes() {
        return this.igProbes;
    }

    public int numIGProbes() {
        return this.igProbes.size();
    }

    public void addAnnotation(RfamTest anno) {
        this.annotations.add(anno);
    }

    public void clearAnnotations() {
        this.annotations = new LinkedList<RfamTest>();
    }

    public List<RfamTest> getAnnotations() {
        return this.annotations;
    }

    public int numAnnotations() {
        return this.annotations.size();
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "\t" + "\u20ac" + this.terminationClass + this.siddClass + this.pcClass;
    }

    @Override
    public boolean isSequenceConsitentWithFeatureType(Sequence seq) {
        return true;
    }

    @Override
    public String toGFFString() {
        String mandatory = String.valueOf(Main.genome.getID()) + "\t" + this.source + "\t" + "ncRNA_region" + "\t" + this.getStart() + "\t" + this.getEnd() + "\t" + "." + "\t" + this.getStrand() + "\t" + ".";
        String attributes = "\tID=" + this.getID() + "; Class_String=" + this.getGeneClass() + this.getTerminationClass() + this.getSiddClass() + this.getPcClass();
        return String.valueOf(mandatory) + attributes;
    }

    public String toCountNoRNAcString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getID()) + "\t" + this.getStart() + "\t" + this.getEnd() + "\t" + this.getStrand() + "\t" + this.getScore());
        sb.append("\t" + this.getGeneClass() + this.getTerminationClass() + this.getSiddClass() + this.getPcClass() + "\t");
        for (Gene gene : this.genes) {
            sb.append(String.valueOf(gene.getID()) + ";");
        }
        if (this.numGenes() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("\t");
        for (Terminator terminator : this.terminators) {
            sb.append(String.valueOf(terminator.getID()) + ";");
        }
        if (this.numTerminators() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("\t");
        for (SIDDSite sIDDSite : this.siddSites) {
            sb.append(String.valueOf(sIDDSite.getID()) + ";");
        }
        if (this.numSIDDSites() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("\t");
        for (PCMatch pCMatch : this.pcMatches) {
            sb.append(String.valueOf(pCMatch.getID()) + ";");
        }
        if (this.numPCMatches() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("\t");
        for (RfamHit rfamHit : this.rfamHits) {
            sb.append(String.valueOf(rfamHit.getSeedID()) + ";");
        }
        if (this.numRfamHits() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("\t");
        for (NCRNATranscript nCRNATranscript : this.tUnits) {
            sb.append(String.valueOf(nCRNATranscript.getID()) + ";");
        }
        if (this.numPredictedNCRNATranscripts() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("\t");
        for (TranskriptInteraction transkriptInteraction : this.getInteractions()) {
            sb.append(String.valueOf(transkriptInteraction.getTarget().getID()) + ";");
        }
        if (this.numInteractions() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("\t");
        return sb.toString();
    }
}

