/*
 * Decompiled with CFR 0.152.
 */
package rfam;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rfam.RfamSeed;
import seq.FASTAEntry;
import seq.RNASequence;

public class RfamSeedParser {
    public static List<RfamSeed> parseRfamSeeds(String filename) throws Exception {
        LinkedList<RfamSeed> seeds = new LinkedList<RfamSeed>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String line = "";
        String[] lineFields = new String[]{""};
        boolean eof = false;
        boolean eoe = false;
        while (true) {
            Iterator tmpSeqsIt;
            if (!lineFields[0].equalsIgnoreCase("#=GF") || !lineFields[1].equalsIgnoreCase("AC")) {
                line = reader.readLine();
                if (line == null) {
                    eof = true;
                } else {
                    lineFields = line.split("[\\s]+", 3);
                    continue;
                }
            }
            if (eof) break;
            eoe = false;
            String tmpAC = lineFields[2];
            while (!lineFields[0].equalsIgnoreCase("#=GF") || !lineFields[1].equalsIgnoreCase("ID")) {
                line = reader.readLine();
                lineFields = line.split("[\\s]+", 3);
            }
            String tmpID = lineFields[2];
            while (!lineFields[0].equalsIgnoreCase("#=GF") || !lineFields[1].equalsIgnoreCase("DE")) {
                line = reader.readLine();
                lineFields = line.split("[\\s]+", 3);
            }
            String tmpDE = lineFields[2];
            while (!lineFields[0].equalsIgnoreCase("#=GF") || !lineFields[1].equalsIgnoreCase("GA")) {
                line = reader.readLine();
                lineFields = line.split("[\\s]+", 3);
            }
            double tmpGA = Double.parseDouble(lineFields[2]);
            while (!lineFields[0].equalsIgnoreCase("#=GF") || !lineFields[1].equalsIgnoreCase("TC")) {
                line = reader.readLine();
                lineFields = line.split("[\\s]+", 3);
            }
            double tmpTC = Double.parseDouble(lineFields[2]);
            while (!lineFields[0].equalsIgnoreCase("#=GF") || !lineFields[1].equalsIgnoreCase("TP")) {
                line = reader.readLine();
                lineFields = line.split("[\\s]+", 3);
            }
            String tmpTP = lineFields[2];
            while (line.trim().length() == 0 || line.trim().charAt(0) == '#') {
                line = reader.readLine();
            }
            LinkedList<String> tmpNames = new LinkedList<String>();
            LinkedList<StringBuffer> tmpSeqs = new LinkedList<StringBuffer>();
            do {
                lineFields = line.trim().split("[\\s]+");
                tmpNames.add(lineFields[0]);
                tmpSeqs.add(new StringBuffer(lineFields[1]));
                line = reader.readLine();
                lineFields = line.trim().split("[\\s]+");
                while (line.trim().length() == 0 || line.trim().charAt(0) == '#' && !lineFields[1].equalsIgnoreCase("SS_cons")) {
                    line = reader.readLine();
                    lineFields = line.trim().split("[\\s]+");
                }
            } while (!lineFields[1].equalsIgnoreCase("SS_cons"));
            StringBuffer tmpSScons = new StringBuffer(lineFields[2]);
            while (line.trim().length() == 0 || line.trim().charAt(0) == '#') {
                line = reader.readLine();
            }
            if (line.trim().charAt(0) == '/' && line.trim().charAt(1) == '/') {
                eoe = true;
            }
            while (!eoe) {
                tmpSeqsIt = tmpSeqs.iterator();
                do {
                    lineFields = line.trim().split("[\\s]+");
                    ((StringBuffer)tmpSeqsIt.next()).append(lineFields[1]);
                    line = reader.readLine();
                    lineFields = line.trim().split("[\\s]+");
                    while (line.trim().length() == 0 || line.trim().charAt(0) == '#' && !lineFields[1].equalsIgnoreCase("SS_cons")) {
                        line = reader.readLine();
                        lineFields = line.trim().split("[\\s]+");
                    }
                } while (!lineFields[1].equalsIgnoreCase("SS_cons"));
                tmpSScons.append(lineFields[2]);
                while (line.trim().length() == 0 || line.trim().charAt(0) == '#') {
                    line = reader.readLine();
                }
                if (line.trim().charAt(0) != '/' || line.trim().charAt(1) != '/') continue;
                eoe = true;
            }
            LinkedList<FASTAEntry<RNASequence>> tmpFastas = new LinkedList<FASTAEntry<RNASequence>>();
            Iterator tmpNamesIt = tmpNames.iterator();
            tmpSeqsIt = tmpSeqs.iterator();
            while (tmpNamesIt.hasNext()) {
                tmpFastas.add(new FASTAEntry<RNASequence>((String)tmpNamesIt.next(), new RNASequence(((StringBuffer)tmpSeqsIt.next()).toString().replace('.', '-'))));
            }
            seeds.add(new RfamSeed(tmpAC, tmpID, tmpDE, tmpTP, tmpGA, tmpTC, tmpFastas, tmpSScons.toString()));
            lineFields[0] = "Where is the beef?";
        }
        return seeds;
    }
}

