/*
 * Decompiled with CFR 0.152.
 */
package sidd;

import genomic.Gene;
import genomic.Genome;
import java.util.LinkedList;
import java.util.List;
import sidd.SIDDAbstractProfile;
import sidd.SIDDDNAProfiler2;

public class SIDDAbstractGeneProfiler {
    private Genome genome;
    private List<Gene> genes;
    private int upstreamRegSize;
    private int codingRegSize;
    private List<String> resStrings;

    public SIDDAbstractGeneProfiler(Genome genome, List<Gene> genes, int upstreamRegSize, int codingRegSize) {
        this.genome = genome;
        this.genes = genes;
        this.upstreamRegSize = upstreamRegSize;
        this.codingRegSize = codingRegSize;
    }

    public void profileUpstreamRegions() throws Exception {
        this.resStrings = new LinkedList<String>();
        SIDDDNAProfiler2 profiler = new SIDDDNAProfiler2(this.genome.getSequence(), 0, 1, true);
        int tmpStart = 0;
        int tmpEnd = 0;
        for (Gene tmpGene : this.genes) {
            System.out.println(tmpGene.getID());
            if (tmpGene.getStrand() == '+') {
                tmpStart = tmpGene.getStart() - this.upstreamRegSize;
                tmpEnd = tmpGene.getStart() + this.codingRegSize - 1;
            } else {
                tmpStart = tmpGene.getEnd() - this.codingRegSize + 1;
                tmpEnd = tmpGene.getEnd() + this.upstreamRegSize;
            }
            if (tmpStart >= tmpEnd) {
                throw new Error("This should never happen!");
            }
            if (tmpStart < 1 || tmpEnd > this.genome.getEnd()) continue;
            profiler.reset(tmpStart, tmpEnd, true);
            profiler.runProfiler();
            for (SIDDAbstractProfile profile : profiler.getAbstractProfiles()) {
                if (!(profile.getProbability() > 0.0)) continue;
                this.resStrings.add(String.valueOf(tmpGene.getID()) + "\t" + profile.toString());
            }
        }
    }

    public List<String> getResStrings() {
        return this.resStrings;
    }

    public void setUpstreamRegSize(int upstreamRegSize) {
        this.upstreamRegSize = upstreamRegSize;
    }

    public void setCodingRegSize(int codingRegSize) {
        this.codingRegSize = codingRegSize;
    }
}

