/*
 * Decompiled with CFR 0.152.
 */
package sidd;

import efault.Main;
import genomic.Genome;
import sidd.SIDDProgressReporter;
import sidd.SIDDSettings;
import sidd.SIDDWindowThread;

public class SIDDGenomeProfiler {
    private Genome genome;
    private boolean linear;
    private int N;
    private int W;
    private int d0;
    private double[] weights;
    private SIDDWindowThread[] threads;
    private double[] px;
    private double[] Gx;

    public SIDDGenomeProfiler(Genome genome) {
        this(genome, SIDDSettings.DEFAULT_BIG_WINDOW_SIZE, SIDDSettings.DEFAULT_SMALL_WINDOW_SIZE, SIDDSettings.DEAFAULT_BIG_WINDOW_SHIFT, false);
    }

    public SIDDGenomeProfiler(Genome genome, int N, int W, int d0, boolean linear) {
        if ((double)N / (double)d0 != Math.rint((double)N / (double)d0)) {
            throw new IllegalArgumentException("N must be dividable by d0");
        }
        if (linear) {
            throw new IllegalArgumentException("non-circular genomes currently not supported");
        }
        this.px = new double[genome.getLength()];
        this.Gx = new double[genome.getLength()];
        this.genome = genome;
        this.N = N;
        this.W = W;
        this.d0 = d0;
        this.weights = new double[N / d0];
        this.linear = linear;
        this.threads = new SIDDWindowThread[Main.numCPUs];
    }

    public void runProfiler() throws Exception {
        this.calculateWeights();
        int start = -(this.N - 1) + this.d0;
        int numWindows = (int)Math.ceil((double)this.genome.getLength() / (double)this.d0) + this.weights.length - 1;
        int winsPerThread = (int)Math.ceil((double)numWindows / (double)this.threads.length);
        int i = 0;
        while (i < this.threads.length) {
            this.threads[i] = new SIDDWindowThread(this, start + i * this.d0 * winsPerThread, winsPerThread);
            ++i;
        }
        SIDDWindowThread[] sIDDWindowThreadArray = this.threads;
        int n = this.threads.length;
        int n2 = 0;
        while (n2 < n) {
            SIDDWindowThread t = sIDDWindowThreadArray[n2];
            t.start();
            ++n2;
        }
        SIDDProgressReporter reporter = new SIDDProgressReporter(this.threads, numWindows);
        reporter.start();
        SIDDWindowThread[] sIDDWindowThreadArray2 = this.threads;
        int n3 = this.threads.length;
        n = 0;
        while (n < n3) {
            SIDDWindowThread t = sIDDWindowThreadArray2[n];
            t.join();
            ++n;
        }
        reporter.interrupt();
        reporter.join();
    }

    private void calculateWeights() {
        int lastI = this.weights.length - 1;
        this.weights[0] = 1.0;
        this.weights[lastI] = 1.0;
        int i = 1;
        while (i <= this.weights.length / 2 - 1) {
            this.weights[i] = this.weights[i - 1] * 2.0;
            this.weights[lastI - i] = this.weights[i - 1] * 2.0;
            ++i;
        }
        if (this.weights.length % 2 == 1) {
            this.weights[this.weights.length / 2] = this.weights.length / 2 - 1;
        }
        double sum = 0.0;
        int i2 = 0;
        while (i2 < this.weights.length) {
            sum += this.weights[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.weights.length) {
            int n = i2++;
            this.weights[n] = this.weights[n] / sum;
        }
    }

    public int getD0() {
        return this.d0;
    }

    public Genome getGenome() {
        return this.genome;
    }

    public double[] getGx() {
        return this.Gx;
    }

    public boolean isLinear() {
        return this.linear;
    }

    public int getN() {
        return this.N;
    }

    public double[] getPx() {
        return this.px;
    }

    public int getW() {
        return this.W;
    }

    public double[] getWeights() {
        return this.weights;
    }
}

