/*
 * Decompiled with CFR 0.152.
 */
package sidd;

import genomic.AbstractSequenceFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import sidd.SIDDAbstractProfile;
import sidd.SIDDSite;

public class SIDDProfileAnalyzer {
    public static List<SIDDSite> extractSIDDSites(double[] siddProfile, double cutoff) {
        LinkedList<SIDDSite> res = new LinkedList<SIDDSite>();
        double tmpMinG = cutoff;
        boolean inSIDDSite = false;
        int tmpStart = -1;
        int siddSiteCounter = 1;
        int profileLength = siddProfile.length;
        int i = 0;
        while (i < profileLength) {
            double tmpG = siddProfile[i];
            if (!inSIDDSite) {
                if (!(tmpG >= cutoff)) {
                    tmpStart = i + 1;
                    tmpMinG = tmpG;
                    inSIDDSite = true;
                }
            } else if (tmpG < cutoff) {
                tmpMinG = Math.min(tmpMinG, tmpG);
            } else {
                res.add(new SIDDSite("SIDD" + siddSiteCounter++, tmpStart, i, '.', tmpMinG));
                inSIDDSite = false;
            }
            ++i;
        }
        if (inSIDDSite) {
            res.add(new SIDDSite("SIDD" + siddSiteCounter++, tmpStart, profileLength, '.', tmpMinG));
        }
        return res;
    }

    public static List<SIDDAbstractProfile> generateAbstractSIDDProfiles(double[] siddProfile, double cutoff) throws Exception {
        int[] tmpReg;
        ArrayList<Object> tmpRegs;
        LinkedList<SIDDAbstractProfile> res = new LinkedList<SIDDAbstractProfile>();
        Object[] siddSites = SIDDProfileAnalyzer.extractSIDDSites(siddProfile, cutoff).toArray(new SIDDSite[0]);
        Arrays.sort(siddSites);
        int i = 0;
        while (i < siddSites.length) {
            tmpRegs = new ArrayList<int[]>(1);
            tmpReg = new int[]{((AbstractSequenceFeature)siddSites[i]).getStart(), ((AbstractSequenceFeature)siddSites[i]).getEnd()};
            tmpRegs.add(tmpReg);
            res.add(new SIDDAbstractProfile(tmpRegs));
            ++i;
        }
        i = 0;
        while (i < siddSites.length - 1) {
            int j = i + 1;
            while (j < siddSites.length) {
                tmpRegs = new ArrayList(2);
                tmpReg = new int[]{((AbstractSequenceFeature)siddSites[i]).getStart(), ((AbstractSequenceFeature)siddSites[i]).getEnd()};
                tmpRegs.add(tmpReg);
                tmpReg = new int[]{((AbstractSequenceFeature)siddSites[j]).getStart(), ((AbstractSequenceFeature)siddSites[j]).getEnd()};
                tmpRegs.add(tmpReg);
                res.add(new SIDDAbstractProfile(tmpRegs));
                ++j;
            }
            ++i;
        }
        int h = 0;
        while (h < siddSites.length - 2) {
            int i2 = h + 1;
            while (i2 < siddSites.length - 1) {
                int j = i2 + 1;
                while (j < siddSites.length) {
                    tmpRegs = new ArrayList(3);
                    tmpReg = new int[]{((AbstractSequenceFeature)siddSites[h]).getStart(), ((AbstractSequenceFeature)siddSites[h]).getEnd()};
                    tmpRegs.add(tmpReg);
                    tmpReg = new int[]{((AbstractSequenceFeature)siddSites[i2]).getStart(), ((AbstractSequenceFeature)siddSites[i2]).getEnd()};
                    tmpRegs.add(tmpReg);
                    tmpReg = new int[]{((AbstractSequenceFeature)siddSites[j]).getStart(), ((AbstractSequenceFeature)siddSites[j]).getEnd()};
                    tmpRegs.add(tmpReg);
                    res.add(new SIDDAbstractProfile(tmpRegs));
                    ++j;
                }
                ++i2;
            }
            ++h;
        }
        return res;
    }
}

