/**
 * Helper for writing data to files (Header)
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of RNNPBlib.
 * 
 * RNNPBlib is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * RNNPBlib is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with RNNPBlib. If not, see http://www.gnu.org/licenses/.
 */

#pragma once

#include "RNNPB_Vector.h"
#include <stdio.h>
#include <string.h>
#include <sstream>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <vector>
#include <map>
#include <cstdlib>

using namespace std;

struct cmp_str
{
   bool operator()(string a, string b)
   {
      return strcmp(a.c_str(), b.c_str()) < 0;
   }
};

class RNNPB_MatlabWriter
{
	stringstream run_nr;
	stringstream exp_name;

	map<string, ofstream*, cmp_str> Filemap;

	void createOfstream(stringstream& value_name);

	bool newOfstream(stringstream& value_name);

public:
	unsigned int get_run_nr();

	string get_exp_name();

	template <typename T> void write(stringstream& value_name, T val);

	template <typename T> void write(string value_name, T val);

	void write(stringstream& value_name, RNNPB_Vector* val);

	RNNPB_MatlabWriter();

	~RNNPB_MatlabWriter();
};

//Template implementations MUST be located in header file!
template <typename T> void RNNPB_MatlabWriter::write(stringstream& value_name, T val)
{		
	if(newOfstream(value_name))
		createOfstream(value_name);

	//char val_c[50]="";
	//sprintf(val_c, "%f ", val);

	*(Filemap[value_name.str()]) << val;

	*(Filemap[value_name.str()]) << endl;
}
