/**
 * Interface class for simulations on SimulationManager as well as PipeClient-side (Header)
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of SimulationManager.
 * 
 * SimulationManager is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * SimulationManager is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with SimulationManager. If not, see http://www.gnu.org/licenses/.
 */

#pragma once

#include <vector>
#include <pthread.h>

#include "SimulationData.h"

using namespace std;

/*
	Abstrake Klasse für eine Simulation.
*/
class Simulation
{
protected:
	unsigned int steps;

	bool paused;
	bool closed;

	virtual void setAction(const StreamableDataContainer* set_data) = 0;

	/*
	 * Returns a NEW streamable data container.
	 * */
	virtual StreamableDataContainer* getSensors() = 0;

	virtual void step(unsigned int nr_of_steps = 1) = 0;

	unsigned int getSteps()
	{
		return steps;
	}

public:

	Simulation(unsigned int argc, char** argv)
	{
		paused=false;
		closed=false;
		steps=0;
	}
};
