/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import efault.Config;
import genomic.NCRNA;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class NCRNATableParser {
    private static final char COMMENT_CHAR = Config.getChar("commentChar");

    public static List<NCRNA> parseNCRNATable(String filename) throws Exception {
        LinkedList<NCRNA> ncRNAs = new LinkedList<NCRNA>();
        String source = null;
        int count = 1;
        int lineNo = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            String line = br.readLine();
            while (line != null) {
                ++lineNo;
                line = line.split(Character.toString(COMMENT_CHAR), -1)[0];
                if ((line = line.trim()).length() != 0) {
                    String name;
                    char strand;
                    double score;
                    int end;
                    int start;
                    String[] lineFields = line.split("[\\t]+");
                    if (lineFields.length > 4) {
                        source = lineFields[1];
                        start = Integer.parseInt(lineFields[3]);
                        end = Integer.parseInt(lineFields[4]);
                        score = lineFields[5].equalsIgnoreCase(".") ? 0.0 : Double.parseDouble(lineFields[5]);
                        strand = lineFields[6].charAt(0);
                        name = "locus" + count;
                        if (lineFields.length > 8) {
                            boolean stop = false;
                            int j = 8;
                            while (j < lineFields.length && !stop) {
                                String[] attCells = lineFields[j].split("[\\s=;]+");
                                int i = 0;
                                while (i < attCells.length - 1) {
                                    if (attCells[i].equalsIgnoreCase("id")) {
                                        String[] nameCells = attCells[i + 1].split("\"");
                                        name = nameCells.length > 1 ? nameCells[1].trim() : nameCells[0].trim();
                                        stop = true;
                                        break;
                                    }
                                    ++i;
                                }
                                ++j;
                            }
                        }
                    } else {
                        name = lineFields[0];
                        start = Integer.parseInt(lineFields[1]);
                        end = Integer.parseInt(lineFields[2]);
                        score = 0.0;
                        strand = '.';
                        if (lineFields.length > 3) {
                            strand = lineFields[3].charAt(0);
                        }
                    }
                    NCRNA tmpNC = new NCRNA(name, start, end, strand, score);
                    if (source != null) {
                        tmpNC.setSource(source);
                    }
                    ncRNAs.add(tmpNC);
                    ++count;
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            System.err.println("ncRNA locus file cannot be read:\n" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            System.err.println("ncRNA locus file cannot be read:\n" + filename + "\nLine " + lineNo + " not in proper format:\n" + e.getMessage());
            throw e;
        }
        return ncRNAs;
    }
}

