/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import genomic.Gene;
import genomic.Genome;
import genomic.PromotorRegion;
import java.util.LinkedList;
import java.util.List;
import seq.DNAStabTools;

public class PromotorRegionPredicter {
    private static final int E1_WINDOW_WIDTH = 100;
    private static final int E2_WINDOW_WIDTH = 100;
    private static final int MAX_SEGMENT_WIDTH = 50;
    private static final String ID_PREFIX = "PROMREG";
    private static final double MIN_CUTOFF_D = 1.0;
    private Genome genome;
    private double cutoffE;
    private double cutoffD;
    private LinkedList<PromotorRegion> promRegs;

    public PromotorRegionPredicter(Genome genome, List<Gene> genes, int upstreamRegSize) {
        this.genome = genome;
        this.calculateCutoffs(genes, upstreamRegSize);
    }

    public PromotorRegionPredicter(Genome genome, double cutoffE, double cutoffD) {
        this.genome = genome;
        this.setCutoffE(cutoffE);
        this.setCutoffD(cutoffD);
    }

    public void predictPromotorRegions() {
        if (this.genome.getMeanGibbsEnergy() == 0.0) {
            this.genome.calculateGibbsEnergies();
        }
        this.promRegs = new LinkedList();
        int iEnd = this.genome.getEnd() - 199;
        int lastSignalIndex = 0;
        int tmpStart = 0;
        int promCount = 0;
        int n = 1;
        while (n <= iEnd) {
            int e1n = 0;
            int i = 0;
            while (i < 100) {
                e1n = (int)((double)e1n + this.genome.getGibbsEnergyAt(n + i));
                ++i;
            }
            e1n /= 100;
            int e2n = 0;
            i = 100;
            while (i < 200) {
                e2n = (int)((double)e2n + this.genome.getGibbsEnergyAt(n + i));
                ++i;
            }
            e2n /= 100;
            if ((double)e1n > this.cutoffE && (double)(e1n - e2n) > this.cutoffD) {
                if (lastSignalIndex == 0) {
                    tmpStart = n;
                    lastSignalIndex = n;
                } else if (n - lastSignalIndex > 50) {
                    if (tmpStart == lastSignalIndex) {
                        lastSignalIndex = n;
                        tmpStart = n;
                    } else {
                        this.promRegs.add(new PromotorRegion(ID_PREFIX + ++promCount, tmpStart, lastSignalIndex, '.'));
                        lastSignalIndex = n;
                        tmpStart = n;
                    }
                } else {
                    lastSignalIndex = n;
                }
            }
            ++n;
        }
        if (tmpStart != lastSignalIndex) {
            this.promRegs.add(new PromotorRegion(ID_PREFIX + ++promCount, tmpStart, lastSignalIndex, '.'));
        }
    }

    public void calculateCutoffs(List<Gene> genes, int upstreamRegSize) {
        double Esd;
        if (this.genome.getMeanGibbsEnergy() == 0.0) {
            this.genome.calculateGibbsEnergies();
        }
        double Gcut = this.genome.getMeanGibbsEnergy() + 3.0 * this.genome.getSdGibbsEnergy() / 15.0;
        double Emean = DNAStabTools.calcUpstreamGibbsMean(this.genome, genes, upstreamRegSize);
        double Ecut = Emean + 3.0 * (Esd = DNAStabTools.calcUpstreamGibbsSd(this.genome, genes, upstreamRegSize, Emean)) / 15.0;
        double Dcut = Ecut - Gcut;
        if (Dcut <= 0.0) {
            System.err.println("Cutoff values cannot be claculated properly as DNA stability of upstream regions is equal to genome average or lower. Setting default D-cutoff: 1.0");
            Dcut = 1.0;
        } else if (Dcut < 1.0) {
            System.err.println("Calculated D-Cutoff to small: " + Dcut + " Setting default D-Cutoff: " + 1.0);
            Dcut = 1.0;
        }
        this.setCutoffE(Ecut);
        this.setCutoffD(Dcut);
    }

    public Genome getGenome() {
        return this.genome;
    }

    public double getCutoffE() {
        return this.cutoffE;
    }

    public void setCutoffE(double cutoffE) {
        if (cutoffE >= 0.0) {
            throw new IllegalArgumentException("cutoffE >= 0! Has to be negative!");
        }
        this.cutoffE = cutoffE;
    }

    public double getCutoffD() {
        return this.cutoffD;
    }

    public void setCutoffD(double cutoffD) {
        if (cutoffD < 0.0) {
            throw new IllegalArgumentException("cutoffD < 0! Has to be positive!");
        }
        this.cutoffD = cutoffD;
    }

    public LinkedList<PromotorRegion> getPromRegs() {
        return this.promRegs;
    }
}

