/*
 * Decompiled with CFR 0.152.
 */
package sidd;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SIDDAbstractProfile {
    private List<int[]> openRegions;
    private double freeEnergy;
    private double probability;

    public SIDDAbstractProfile(List<int[]> openRegions) throws Exception {
        this.openRegions = openRegions;
        this.validateOpenRegions();
        this.sortOpenRegions();
        this.freeEnergy = 0.0;
        this.probability = 0.0;
    }

    private void validateOpenRegions(List<int[]> openRegions) {
        for (int[] o : openRegions) {
            if (o.length != 2) {
                throw new RuntimeException("Arrays containing start and end positions of open regions must have length 2!");
            }
            if (o[0] <= o[1]) continue;
            throw new RuntimeException("End must be greater than start! Circular DNA currently not supported!");
        }
    }

    private void validateOpenRegions() throws Exception {
        this.validateOpenRegions(this.openRegions);
    }

    private void sortOpenRegions(List<int[]> openRegions) {
        Comparator<int[]> comp = new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                return o1[0] - o2[0];
            }
        };
        Collections.sort(openRegions, comp);
    }

    private void sortOpenRegions() {
        this.sortOpenRegions(this.openRegions);
    }

    public boolean doesThisProfileMatchAnother(List<int[]> anotherProfilesOpenRegions) {
        this.validateOpenRegions(anotherProfilesOpenRegions);
        if (this.openRegions.size() > anotherProfilesOpenRegions.size()) {
            return false;
        }
        this.sortOpenRegions(anotherProfilesOpenRegions);
        int i = 0;
        while (i < anotherProfilesOpenRegions.size()) {
            int[] anotherReg = anotherProfilesOpenRegions.get(i);
            int j = 0;
            while (j < this.openRegions.size()) {
                int[] thisReg = this.openRegions.get(j);
                if (Math.min(thisReg[1], anotherReg[1]) - Math.max(thisReg[0], anotherReg[0]) < 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public List<int[]> getOpenRegions() {
        return this.openRegions;
    }

    public int getNumOfOpenRegions() {
        return this.openRegions.size();
    }

    public double getFreeEnergy() {
        return this.freeEnergy;
    }

    public void setFreeEnergy(double freeEnergy) {
        this.freeEnergy = freeEnergy;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        for (int[] reg : this.openRegions) {
            res.append(String.valueOf(reg[0]) + "-" + reg[1] + ",");
        }
        res.append(String.valueOf(this.freeEnergy) + "," + this.probability);
        return res.toString();
    }
}

