/*
 * Decompiled with CFR 0.152.
 */
package term;

import efault.Config;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;
import term.Terminator;

public class TermTableParser {
    private static final char COMMENT_CHAR = Config.getChar("commentChar");

    public static List<Terminator> parseTermTable(String filename) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        LinkedList<Terminator> terms = new LinkedList<Terminator>();
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).length() == 0) {
                line = br.readLine();
                continue;
            }
            if (line.charAt(0) == COMMENT_CHAR) {
                line = br.readLine();
                continue;
            }
            String[] lineFields = line.split("[\\s]+");
            String name = lineFields[0];
            int start = Integer.parseInt(lineFields[1]);
            int end = Integer.parseInt(lineFields[2]);
            char strand = lineFields[3].charAt(0);
            int confidence = Integer.parseInt(lineFields[4]);
            terms.add(new Terminator(name, start, end, strand, confidence));
            line = br.readLine();
        }
        br.close();
        return terms;
    }
}

