@ GAUSS-Prozeduren zur Generierung von exponential-, weibull- und
  burrverteilten Zufallsvariablen sowie ebensoverteilter Dauern

  Globalvariable: outsim   - Name des Output-Datensatzes
                  seed     - Initialisierung des Zufallszahlengenerators
@


PROC simulate(msimstr,mp,mq,malpha,mbeta,momega,mtheta,mn);
 /* Uebergabeparameter
    msimstr:  "EXPON", "WEIB", "BURR", "GGAMMA"
    mp:       Verzoegerung von PSI
    mq:       Verzeogerung von x_i
    malpha:   Parametervektor verz. x_i
    mbeta:    Parametervektor verz. PSI
    momega:   Konstante
    mtheta:   EXPON --> egal
              WEIB  --> Weibullparameter gamma
              BURR  --> kappa|sigma_2
              G. GAMMA --> gammaGG|alphaGG
    mn:       Anzahl zu simulierender Beobachtungen
   19.6.2000: GGACD included s.v.
 */

 LOCAL psibuf,xbuf,xneu,psineu,z,psiakt,xakt,korr,outnames,
       out,x, i, alphaGG, gammaGG;

IF (UPPER(msimstr)$=="BURR") or (UPPER(msimstr)$=="WEIB") or (UPPER(msimstr)$=="EXPON");

 IF (rows(malpha)/=mq);
  "Falsche Dimension von alpha!"; END;
 ENDIF;

 IF (rows(mbeta)/=mp);
  "Falsche Dimension von beta!"; END;
 ENDIF;

 psibuf = ones(mp,1); xbuf = ones(mq,1);
 xneu = {}; psineu = {};

 z = 1; DO WHILE (z<=mn);

  psiakt = momega + (malpha')*xbuf + (mbeta')*psibuf;

  IF (UPPER(msimstr)$=="EXPON");

   xakt = expo_rnd(1/psiakt,1);

  ELSEIF (UPPER(msimstr)$=="WEIB");

   xakt = weib_rnd((gamma(1+(1/mtheta))/psiakt),mtheta,1);

  ELSEIF (UPPER(msimstr)$=="BURR");

   korr = exp(loggamma(1+(1/mtheta[1]))+loggamma((1/mtheta[2])
                -(1/mtheta[1]))-loggamma((1/mtheta[2])+1))/
             (mtheta[2]^(1+(1/mtheta[1])));

   xakt = burr_rnd(mtheta[2],(psiakt/korr)^(-mtheta[1]),mtheta[1],1);

  ENDIF;

  xneu   = xneu|xakt;
  psineu = psineu|psiakt;
  IF (mq==1);
   xbuf = xakt;
  ELSE;
   xbuf   = xakt|xbuf[1:(mq-1)];
  ENDIF;

  IF (mp==1);
   psibuf = psiakt;
  ELSE;
   psibuf = psiakt|psibuf[1:(mp-1)];
  ENDIF;

  z = z + 1;

 ENDO;

ELSEIF (UPPER(msimstr)$=="GGAMMA");

  IF (rows(malpha)/=1);
  "Unzulaessige Dimension von alpha!"; END;
 ENDIF;

 IF (rows(mbeta)/=1);
  "Unzulaessige Dimension von beta!"; END;
 ENDIF;

  IF (mq/=1);
  "Unzulaessige Dimension von alpha!"; END;
 ENDIF;

 IF (mp/=1);
  "Unzulaessige Dimension von beta!"; END;
 ENDIF;

 gammaGG=mtheta[1];
 alphaGG=mtheta[2];

 xneu      = ONES(mn,1);
 psineu    = ONES(mn,1);
 psineu[1,1]= momega + malpha + mbeta;
 xneu[1,1]=GG_random((1/psineu[1,1])*GAMMA(alphaGG + 1/gammaGG)/ GAMMA(alphaGG), gammaGG, alphaGG);

 i=2;
  DO WHILE i LE (mn);
   psineu[i,1] = momega + malpha*xneu[i-1,1] + mbeta*psineu[i-1,1];
   xneu[i,1]    = GG_random((1/psineu[i,1])*GAMMA(alphaGG + 1/gammaGG)/ GAMMA(alphaGG), gammaGG, alphaGG);
   i=i+1;
  ENDO;

 ENDIF;

 let outnames = xsnake psi;
 create out   = ^outsim with ^outnames,0,8;
 x            = writer(out,xneu~psineu);
 out          = close(out);

 RETP(xneu~psineu);


ENDP;


PROC simulate2(msimstr,mp,mq,malpha,mbeta,momega,mtheta,mn);
 /* wie simulate, nur wird kein GAUSS file geschrieben.

    Uebergabeparameter
    msimstr:  "EXPON", "WEIB", "BURR", "GGAMMA"
    mp:       Verzoegerung von PSI
    mq:       Verzeogerung von x_i
    malpha:   Parametervektor verz. x_i
    mbeta:    Parametervektor verz. PSI
    momega:   Konstante
    mtheta:   EXPON --> egal
              WEIB  --> Weibullparameter gamma
              BURR  --> kappa|sigma_2
              G. GAMMA --> gammaGG|alphaGG
    mn:       Anzahl zu simulierender Beobachtungen
   19.6.2000: GGACD included s.v.
   19.7.2000: kein Gauss file wird geschrieben
 */

 LOCAL psibuf,xbuf,xneu,psineu,z,psiakt,xakt,korr,outnames,
       out,x, i, alphaGG, gammaGG;

IF (UPPER(msimstr)$=="BURR") or (UPPER(msimstr)$=="WEIB") or (UPPER(msimstr)$=="EXPON");

 IF (rows(malpha)/=mq);
  "Falsche Dimension von alpha!"; END;
 ENDIF;

 IF (rows(mbeta)/=mp);
  "Falsche Dimension von beta!"; END;
 ENDIF;

 psibuf = ones(mp,1); xbuf = ones(mq,1);
 xneu = {}; psineu = {};

 z = 1; DO WHILE (z<=mn);

  psiakt = momega + (malpha')*xbuf + (mbeta')*psibuf;

  IF (UPPER(msimstr)$=="EXPON");

   xakt = expo_rnd(1/psiakt,1);

  ELSEIF (UPPER(msimstr)$=="WEIB");

   xakt = weib_rnd((gamma(1+(1/mtheta))/psiakt),mtheta,1);

  ELSEIF (UPPER(msimstr)$=="BURR");

   korr = exp(loggamma(1+(1/mtheta[1]))+loggamma((1/mtheta[2])
                -(1/mtheta[1]))-loggamma((1/mtheta[2])+1))/
             (mtheta[2]^(1+(1/mtheta[1])));

   xakt = burr_rnd(mtheta[2],(psiakt/korr)^(-mtheta[1]),mtheta[1],1);

  ENDIF;

  xneu   = xneu|xakt;
  psineu = psineu|psiakt;
  IF (mq==1);
   xbuf = xakt;
  ELSE;
   xbuf   = xakt|xbuf[1:(mq-1)];
  ENDIF;

  IF (mp==1);
   psibuf = psiakt;
  ELSE;
   psibuf = psiakt|psibuf[1:(mp-1)];
  ENDIF;

  z = z + 1;

 ENDO;

ELSEIF (UPPER(msimstr)$=="GGAMMA");

  IF (rows(malpha)/=1);
  "Unzulaessige Dimension von alpha!"; END;
 ENDIF;

 IF (rows(mbeta)/=1);
  "Unzulaessige Dimension von beta!"; END;
 ENDIF;

  IF (mq/=1);
  "Unzulaessige Dimension von alpha!"; END;
 ENDIF;

 IF (mp/=1);
  "Unzulaessige Dimension von beta!"; END;
 ENDIF;

 gammaGG=mtheta[1];
 alphaGG=mtheta[2];

 xneu      = ONES(mn,1);
 psineu    = ONES(mn,1);
 psineu[1,1]= momega + malpha + mbeta;
 xneu[1,1]=GG_random((1/psineu[1,1])*GAMMA(alphaGG + 1/gammaGG)/ GAMMA(alphaGG), gammaGG, alphaGG);

 i=2;
  DO WHILE i LE (mn);
   psineu[i,1] = momega + malpha*xneu[i-1,1] + mbeta*psineu[i-1,1];
   xneu[i,1]    = GG_random((1/psineu[i,1])*GAMMA(alphaGG + 1/gammaGG)/ GAMMA(alphaGG), gammaGG, alphaGG);
   i=i+1;
  ENDO;

 ENDIF;
/*
 let outnames = xsnake psi;
 create out   = ^outsim with ^outnames,0,8;
 x            = writer(out,xneu~psineu);
 out          = close(out);

*/

RETP(xneu~psineu);

ENDP;



/* Zufallszahl der Generalized Gamma Verteilung */
PROC GG_random(lambdaGG, gammaGG, alphaGG);
LOCAL F, t1, t;
F=RNDUS(1,1,seed);
t1=GAMMAII(alphaGG, F);
t=(t1^(1/gammaGG))/lambdaGG;
RETP(t);
ENDP;


PROC expo_rnd(mlambda,mk);

 /* mlambda kann ein N x 1 Vektor sein, mk ist ein Skalar, der die Zahl der
    Zuege fuer jedes Element von lambda festlegt --> Rueckgabe ist eine
    N x k Matrix */
 local t1;

 t1 = -(1/mlambda).*ln(1-rndus(rows(mlambda),mk,seed));
 RETP(t1);

ENDP;



PROC weib_rnd(mlambda,mgamm,mk);

 /* mlambda kann ein N x 1 Vektor sein, mk ist ein Skalar, der die Zahl der
    Zuege fuer jedes Element von mlambda festlegt --> Rueckgabe ist eine
    N x k Matrix; mgamm ist Weibull-Parameter */

 local t1;

 t1 = (-ln(1-rndus(rows(mlambda),mk,seed)));
 t1 = t1^(1/mgamm);
 t1 =  (1/mlambda).*t1;

 RETP(t1);

ENDP;



PROC burr_rnd(msigma_2,mmu,mkappa,mk);

 /* mmu kann ein N x 1 Vektor sein, mk ist ein Skalar, der die Zahl der
    Zuege fuer jedes Element von mlambda festlegt --> Rueckgabe ist eine
    N x k Matrix; msigma_2, mkappa sind Verteilungsparameter */

 local t1;

 t1 = -1 + (1-rndus(rows(mmu),mk,seed))^(-msigma_2);

 RETP ((t1./(msigma_2*mmu))^(1/mkappa));

ENDP;



proc loggamma(x);
   local z;
     x=x+6;
     z=1/(x.*x);
     z=(((-0.000595238095238*z+0.000793650793651)
          .*z-0.002777777777778).*z+0.083333333333333)./x;
     z=(x-0.5).*ln(x)-x+0.918938533204673+z
           -ln(x-1)-ln(x-2)-ln(x-3)-ln(x-4)-ln(x-5)-ln(x-6);
   retp(z);
endp;

PROC simulate_aacd(msimstr,sub_aacd_str,mp,mq,malpha,mbeta,momega,mtheta,b_aacd,c,lambda,upsilon,mn);

 /* Parameters
    msimstr:  "EXPON", "WEIB", "BURR"
    sub_aacd_str: "AACD" "PAACD" "APAACD"
    mp:       lag of PSI (here only 1 is allowed)
    mq:       lag of x_i (here only 1 is allowed)
    malpha:   Parametervektor verz. x_i (use only one)
    mbeta:    Parametervektor verz. PSI (")
    momega:   Constant
    mtheta:   EXPON --> does not matter
              WEIB  --> Weibull gamma
              BURR  --> kappa|sigma_2
    mn:       Number of obs to simulate
 */

 LOCAL psibuf,xbuf,xneu,psineu,z,psiakt,xakt,korr,outnames,
       out,x, aacdpsibuf, aacdpsiakt;

 IF (rows(malpha)/=1);
  "Wrong Dimension of alpha!"; END;
 ENDIF;

 IF (rows(mbeta)/=1);
  "Wrong Dimension of beta!"; END;
 ENDIF;

 psibuf = ones(mp,1);
 xbuf   = ones(mq,1);
 xneu   = {};
 psineu = {};

IF (UPPER(msimstr)$=="BURR");
 korr = exp(loggamma(1+(1/mtheta[1]))+loggamma((1/mtheta[2])
                -(1/mtheta[1]))-loggamma((1/mtheta[2])+1))/
             (mtheta[2]^(1+(1/mtheta[1])));
ELSE;
 korr = 1;
ENDIF;


 IF (UPPER(sub_aacd_str)$=="AACD");
  aacdpsibuf=(psibuf^lambda-1)/lambda;
/* aacdpsibuf=(psibuf^lambda);*/
 ELSEIF (UPPER(sub_aacd_str)$=="PAACD") or (UPPER(sub_aacd_str)$=="APAACD") ;
  aacdpsibuf=(psibuf^lambda);
 ENDIF;

 z = 1; DO WHILE (z<=mn);

@@@ WARNING: NEXT INSTRUCTION VALID ONLY FOR AACD(1,1) @@@

IF (UPPER(sub_aacd_str)$=="AACD") ;
  aacdpsiAkt = momega+malpha*(psiBuf^lambda) *
          /*((sqrt((xbuf*korr/psiBuf-b_aacd)^2+0.0001^2)-c*(xbuf*korr/psiBuf-b_aacd)))^upsilon*/
            (abs(xbuf*korr/psiBuf-b_aacd)-c*(xbuf*korr/psiBuf-b_aacd))^upsilon
                 + mbeta * aacdpsiBuf;
ELSEIF(UPPER(sub_aacd_str)$=="APAACD");
  aacdpsiAkt = momega+malpha*(psiBuf^lambda) *
               ((sqrt((xbuf*korr/psiBuf-b_aacd)^2+0.0001^2)-c*(xbuf*korr/psiBuf-b_aacd)))^lambda
                 + mbeta * aacdpsiBuf;
ELSEIF (UPPER(sub_aacd_str)$=="PAACD") ;
  aacdpsiAkt = momega+malpha*(xbuf^lambda)+ mbeta*aacdpsiBuf;
ENDIF;

IF (UPPER(sub_aacd_str)$=="AACD");
/*    psiAkt      = exp(1/lambda*ln(aacdpsiAkt));*/
 psiAkt      = exp((1/lambda)*ln(lambda*aacdpsiAkt+1));
ENDIF;

IF (UPPER(sub_aacd_str)$=="PAACD") or (UPPER(sub_aacd_str)$=="APAACD");
  psiAkt      = exp(1/lambda*ln(aacdpsiAkt));
ENDIF;

IF (UPPER(msimstr)$=="EXPON");
 xakt = expo_rnd(1/psiakt,1);
ELSEIF (UPPER(msimstr)$=="WEIB");
 xakt = weib_rnd((gamma(1+(1/mtheta))/psiAkt),mtheta,1);
ELSEIF (UPPER(msimstr)$=="BURR");
 xakt = burr_rnd(mtheta[2],(psiakt/korr)^(-mtheta[1]),mtheta[1],1);
ENDIF;
  xneu   = xneu|xakt;
  psineu = psineu|psiakt;
  xbuf  = xakt;
  psiBuf = psiakt;
  aacdpsibuf = aacdpsiakt;
  z = z + 1;
 ENDO;

/*
 let outnames = xsnake psi;
 create out   = ^outsim with ^outnames,0,8;
 x            = writer(out,xneu~psineu);
 out          = close(out);
*/

 RETP(xneu~psineu);

ENDP;
