/* Produces graphs of empirical rejection probabilities for the Burr ACD
   Graph Burr ACD-DGP
   13.12.99
   j.g.
*/

LIBRARY CML, co, PGRAPH;
#INCLUDE CML.EXT;
#INCLUDE CML.DEC;
#include highfreq.ext;
#include highfreq.dec;
#include tacd.dec;
#include tacd.src;
let artstart = {};
let ind_x    = {};
let mypower  = {};
let _allcases = {};
CMLSET;

#include svddeflt.ext;
#include svd_h.src;
#include dtyfcacd.src;
#INCLUDE testacd.src;

x=0.5| 0.2| 0.1| 0.05| 0.01; /* Theoretical quantiles */

GRAPHSET;
XTICS(0, 0.5, 0.1, 0);
_pdate = "";
_plegctl = {2 3.8 5.8 5.1};
_paxes = 1;
_plwidth = { 4, 4, 4, 4 };
_pframe = 0;

/*_pltype={1,1};*/
_plframe = 0;
_ptitlht=0.25;
_paxht=0.25;
_pnumht=0.2;

XLABEL("level of significance");
YLABEL("prob. of rejection");

/******************************* Exponential ACD Evaluation  ***************/
loadm d0000e1;
loadm h0000e1;
loadm d0000e3;
loadm h0000e3;
loadm d0000e2;
loadm overdis_expo;
{y1a, y2a} =(empirical_rejection_prob_2001(D0000e1,0));
{y1b, y2b} =(empirical_rejection_prob_2001(h0000e1,0));
{y1c, y2c} =(empirical_rejection_prob_2001(D0000e3,0));
{y1d, y2d} =(empirical_rejection_prob_2001(h0000e3,0));
{y1e, y2e} =(empirical_rejection_prob_2001(d0000e2,0));
{y1f, y2f} =(empirical_rejection_prob_2001(overdis_expo,0));
_plegstr = "D-test, opt. kernel\0H-test, opt. kernel\0D-test, Gamma kernel
\0H-test, Gamma kernel\0D-test log residuals, opt. kernel\0Overdispersion test";
yTICS(0, 1, 0.1, 0);
TITLE("\201Size, estimated model: \l\201 Exponential ACD");
_plegctl = {2 3.3 4.8 3};
graphprt("-CF=e_en.eps -C=1");
XY(x,y1a~y1b~y1c~y1d~y1e~y1f);
_ptek = "";
TITLE("\201Size, estimated model: \l\201 Exponential ACD (bootstrap)");
yTICS(0, 0.5, 0.1, 0);
_plegctl = {2 3.3 1.2 4};
graphprt("-CF=e_e.eps -C=1");
XY(x,y2a~y2b~y2c~y2d~y2e~y1f);
