/* Exxon  price power acd burr
*/

library cml, co, pgraph;
#include cml.ext;
#include co.ext
#include pgraph.ext;
CMLset;
coset;
graphset;
#include highfreq.dec;
#include highfreq.ext;
#include svdDeflt.ext;
#INCLUDE gammafm.src;
#INCLUDE svd_h.src;
#include tacd.dec;
#include tacd.src;
globalpsi = {};

#include dtyfcacd.src;


@============@
@ The following GLOBALS must be identical for all models tested to ensure comparability @

let number_of_bins = 20;                 /*number of bins for histogram plot of z changed from binwidth: j.g. 9.11.99 */
let lagorder = 50;                       /*Lags for autocorrelation plot:                      */
let conf_interval = 0.9;                 /*90 % confidence interval for histogram plot         */

@ end common section @
@============@

/*******************   TO BE ADAPTED FOR EACH DATA SET    *******************/

loadm datamatrix = baqp18;
OUTPUT file      = bpaacdb;
output reset; output on; screen on;
" ";
"Estimation first two third, bpaluation first two third";

/****************************************************************************/

 ALLCASES = rows(datamatrix);

 P     =1;                                 /* lag length for lagged psi in ACD model (used as GLOBAL) */
 Q     =1;                                 /* lag length for lagged XI in  ACD model (used as GLOBAL) */

@
  This selects the last third of the data for forecasting purposes
  and also tests on the data
@

 XI    = datamatrix[1:round(allcases*(2/3))-1,9];
 FXI   = xi;

/* Globals needed for Forecasting j.g. November 4, 1999 */

                                           /* This uses the last third of durations for bpaluation (XI is used as a GLOBAL)*/
 FCASES =rows(FXI);                        /* CASES is used as a GLOBAL in diebold_z                  */
 FMXI   =generate_lagged_xi(FXI,q,fcases); /* Generates a matrix of lagged durations (used as GLOBAL) */


/* Globals for Estimation  j.g. November 4, 1999 */

 CASES =rows(XI);                         /* CASES used for estimation                                            */
 MXI   =generate_lagged_xi(XI,q,cases);   /* Generates a matrix of lagged durations for estimation(used as GLOBAL) */
 MIND_P=genindx_with_cases(2,p,1,cases);  /* Generates an index vector that is only needed if analytical gradients
                                             are supplied for EACD, WACD and BACD, then used as global
                                          */

 EXO    = zeros(cases,1);                             /* 0 = no exogenous regressors in PSI equation: estimation period */
 FEXO   = 0;                             /* same for forecasting period                                    */
 NOEXOG = 0;                             /* signifies number of exogenour regressors */
 data_input = {};                        /* I dont use this matrix to transfer data, I use Glokols (xi, mxi,)
                                            it may be needed, howETer for other models...*/
 let model_specifics = {};               /* I don't need any, you may.... */


sub_aacd         = "AACD";
model            = "BAACD";

_cml_algorithm   = 3;         /* CML settings */
_cml_linesearch  = 1;
/*_cml_gradstep  = 0.01;*/
_use_cml         = 1;
_cml_covpar      = 2;
_cml_gradmethod  = 0;

/*
_uu_ = { 1e-06 1e250 };
_cml_Bounds = ones(rows(model_parameters),2).*_uu_;
_cml_bounds[1,1] = -50;
_cml_bounds[2,1] = -50;
_cml_bounds[8,1]= -5;
/*_cml_bounds[8,2]= 0.9999;*/
_cml_maxtry = 100000;
*/

loadm model_parameters = bpapacdb_par;
model_parameters=model_parameters|model_parameters[6];

_cml_maxiters = 10000;
_cml_maxtry = 100000;
{bpaacdb_par, bpaacdb_f0 , g, bpaacdb_varcov, bpaacdb_retcode} = CML(XI, 0, &li_aacd, model_parameters);
save bpaacdb_par;
save bpaacdb_f0;
bpaacdb_se = sqrt(diag(bpaacdb_varcov));
save bpaacdb_se;
save bpaacdb_retcode;

"Log-Likelihood";
 bpaacdb_f0*cases;
"BIC";
-2*bpaacdb_f0*cases+ln(cases)*rows(bpaacdb_par);
"Parameter estimates and standard errors";
bpaacdb_par~bpaacdb_se;
