/* Exxon price power acd burr
*/


library cml, co, pgraph;
#include cml.ext;
#include co.ext
#include pgraph.ext;
CMLset;
coset;
graphset;
#include highfreq.dec;
#include highfreq.ext;
#include svdDeflt.ext;
#INCLUDE gammafm.src;
#INCLUDE svd_h.src;
#include tacd.dec;
#include tacd.src;
globalpsi = {};

#include dtyfcacd.src;


@============@
@ The following GLOBALS must be identical for all models tested to ensure comparability @

let number_of_bins = 20;                 /*number of bins for histogram plot of z changed from binwidth: j.g. 9.11.99 */
let lagorder = 50;                       /*Lags for autocorrelation plot:                      */
let conf_interval = 0.9;                 /*90 % confidence interval for histogram plot         */

@ end common section @
@============@

/*******************   TO BE ADAPTED FOR EACH DATA SET    *******************/

loadm datamatrix = xon_t;
OUTPUT file      = easacdb;
output reset; output on; screen on;
" ";
"Estimation first two third, etaluation first two third";

/****************************************************************************/

 ALLCASES = rows(datamatrix);

 P     =1;                                 /* lag length for lagged psi in ACD model (used as GLOBAL) */
 Q     =1;                                 /* lag length for lagged XI in  ACD model (used as GLOBAL) */

@
  This selects the last third of the data for forecasting purposes
  and also tests on the data
@

 XI    = datamatrix[1:round(allcases*(2/3))-1,7];
 FXI   = xi;

/* Globals needed for Forecasting j.g. November 4, 1999 */

                                           /* This uses the last third of durations for etaluation (XI is used as a GLOBAL)*/
 FCASES =rows(FXI);                        /* CASES is used as a GLOBAL in diebold_z                  */
 FMXI   =generate_lagged_xi(FXI,q,fcases); /* Generates a matrix of lagged durations (used as GLOBAL) */


/* Globals for Estimation  j.g. November 4, 1999 */

 CASES =rows(XI);                         /* CASES used for estimation                                            */
 MXI   =generate_lagged_xi(XI,q,cases);   /* Generates a matrix of lagged durations for estimation(used as GLOBAL) */
 MIND_P=genindx_with_cases(2,p,1,cases);  /* Generates an index vector that is only needed if analytical gradients
                                             are supplied for EACD, WACD and BACD, then used as global
                                          */

 EXO    = zeros(cases,1);                             /* 0 = no exogenous regressors in PSI equation: estimation period */
 FEXO   = 0;                             /* same for forecasting period                                    */
 NOEXOG = 0;                             /* signifies number of exogenour regressors */
 data_input = {};                        /* I dont use this matrix to transfer data, I use Glokols (xi, mxi,)
                                            it may be needed, howeter for other models...*/
 let model_specifics = {};               /* I don't need any, you may.... */



sub_aacd         = "ASACD";
model            = "BAACD";

_cml_algorithm   = 3;         /* CML settings */
_cml_linesearch  = 1;
/*_cml_gradstep  = 0.01;*/
_cml_gradmethod  = 3;
_use_cml         = 1;
_cml_covpar      = 2;


loadm model_parameters = etlinacdb_par;
model_parameters = model_parameters|0.1|0.1;
_uu_ = { 1e-06 1e250 };
_cml_Bounds = ones(rows(model_parameters),2).*_uu_;
_cml_maxtry = 100000;
_cml_bounds[2,1] = -100;
/*
_cml_bounds[7,1]=-0.9999;
_cml_bounds[7,2]=0.9999;
*/
_cml_maxiters = 1000;
_cml_maxtry   = 100000;

{etasacdb_par, etasacdb_f0 , g, etasacdb_varcov, etasacdb_retcode} = cmlprt(CML(XI, 0, &li_aacd, model_parameters));
save etasacdb_par;
save etasacdb_f0;
etasacdb_se = sqrt(diag(etasacdb_varcov));
save etasacdb_se;
save etasacdb_varcov;
save etasacdb_retcode;
"Log-Likelihood";
 etasacdb_f0*cases;
"BIC";
-2*etasacdb_f0*cases+ln(cases)*rows(etasacdb_par);
"Parameter estimates and standard errors";
etasacdb_par~etasacdb_se;
