/**********************************************************************/
/* 

   Program: 	DChUti_A.prg (Utility Program)
   Subject:  	Model Control for DChoice0.prg                		
   Date: 	14.9.99
   Author(s):   Michael Scheidler  
   Comments:   */ 
/**********************************************************************/


if  	_model == 10;
   	_modname = "MNL";
elseif 	_model == 21;
   	_modname = "Independent MNP (mit GHK)";

elseif 	_model == 30;
   	_modname = "ABC-MNP";
elseif 	_model == 40;
   	_modname = "GAR-MNP with free sigma";
elseif       _model == 45;
       _modname = "GAR-MNP";
else;
	"ERROR: No valid model chosen!";
	stop;
endif;

nbeta  = rows(indad)+2*four_anz;
label = indcen1;

if (four_anz gt 0);
     count=1;
     do until count  > four_anz;
       add="A"$+ftos(count,"%*.*lf",1,0)$+"_"$+fourcen1;
       label=label|add;
       count=count+1; 
     endo;
     count=1;
     do until count  > four_anz;
       add="P"$+ftos(count,"%*.*lf",1,0)$+"_"$+fourcen1;
       label=label|add;
       count=count+1; 
     endo;
endif; 

/* Independent Models */	
if (_model lt 30);  
  corr1_on=0;
  corr2_on=0;
  if bpara_on == 0;
    bparam = zeros(nbeta,1);
  endif;
  x0 = bparam; 
  if (_model gt 25 );  /* Special I-Models */
    label=label|"INDG_SIG";
    if bspec_on; 
	x0=x0|bspecial;
    else;  	
	x0 = x0|0; 
    endif;   
  endif;
else;  /* Dependent Models */
  if (_model==31 or _model==32); 
    nvmat  = rows(corr1ad)*corr1_on + rows(corr2ad)*corr2_on +1 ;
  elseif (_model == 30 or _model == 35 or _model == 61 );
    nvmat  = 2 * rows(corr1ad)*corr1_on + rows(corr2ad)*corr2_on;
  elseif (_model == 40) or (_model == 41) or  (_model == 50);
    nvmat  = 2 + rows(corr1ad)*corr1_on + rows(corr2ad)*corr2_on;
  elseif (_model == 51 or _model == 45);
    nvmat  = 1 + rows(corr1ad)*corr1_on + rows(corr2ad)*corr2_on;
  elseif (_model == 60);
    nvmat  = 1 + 2 * rows(corr1ad)*corr1_on + rows(corr2ad)*corr2_on;
  endif;

  npara  = nbeta +nvmat;
  nlabel = nbeta;

  if bpara_on == 0;
    bparam = zeros(nbeta,1);
  endif;
  if bcorr_on == 0;
    bcorr = zeros(nvmat,1);
  endif;
  nlabel = nbeta;
  x0=bparam|bcorr;
  if (_model==31 or _model==32); /* ALte P-MNP */
     if (corr1_on == 1);
       label=label|corrcen1;
     endif;
     if (corr2_on == 1);
       label = label|corrcen2;
     endif; 
     label=label|"CONST";
  elseif (_model==30 or _model == 35 or _model == 61); /* P-MNP */
     if (corr1_on == 1);
       corra1=(zeros(rows(corrcen1),1)$+"A_")$+corrcen1;
       corrw1=(zeros(rows(corrcen1),1)$+"W_")$+corrcen1;
       label=label|corra1|corrw1;
     endif;
     if (corr2_on == 1);
       corrd2=(zeros(rows(corrcen2),1)$+"D_")$+corrcen2;
       label = label|corrd2;
     endif;
  elseif (_model == 40 or _model == 41 or _model == 50 ); /* GAR-Modelle */
       label=label|"GAR_RHO"|"GAR_SIG";
     if (corr1_on == 1);
       corrw1=(zeros(rows(corrcen1),1)$+"W_")$+corrcen1;
       label=label|corrw1;
     endif;
     if (corr2_on == 1);
       corrw2=(zeros(rows(corrcen2),1)$+"W_")$+corrcen2;
       label = label|corrw2;
     endif;
  elseif (_model == 51   or _model == 45); /* GAR-Modelle */
       label=label|"GAR_RHO";
     if (corr1_on == 1);
       corrw1=(zeros(rows(corrcen1),1)$+"W_")$+corrcen1;
       label=label|corrw1;
     endif;
     if (corr2_on == 1);
       corrw2=(zeros(rows(corrcen2),1)$+"W_")$+corrcen2;
       label = label|corrw2;
     endif;
  elseif (_model==60); /* P-MNP */
       label=label|"VAR_SIG";
     if (corr1_on == 1);
       corra1=(zeros(rows(corrcen1),1)$+"A_")$+corrcen1;
       corrw1=(zeros(rows(corrcen1),1)$+"W_")$+corrcen1;
       label=label|corra1|corrw1;
     endif;
     if (corr2_on == 1);
       corrd2=(zeros(rows(corrcen2),1)$+"D_")$+corrcen2;
       label = label|corrd2;
     endif;
   else;
    "ERROR: Chosen Model not implemented!";
     stop; 
  endif;
endif;

"";"";
"****************************************************************";
"* Settings chosen:";
"*";

"* Model chosen		: ";; $_modname;
"* Utility parameters	: ";; $indcen1;
"* Fourier variablen	: ";; $fourcen1;
"* Fourier frequencies	: ";; four_anz;
"* Fourier typ 		: ";; fourtyp;

if ( _model gt 29);
"* Korrelations-Differenzen-Variablen :";
  if (corr1_on == 1 );
    $(corrcen1');
  endif;
  if (corr2_on == 1 );
     $(corrcen2');
  endif;
  if (corr1_on == 0 and corr2_on == 0);
    " ERROR: Correlation parameters not available!";
    stop;
  endif;
endif;
"*";
"* Settings o.k. ?"; wait;
"****************************************************************";

