/**********************************************************************/
/* Proc. Name:   Joe_m14.prg
   Subject:      Script for GMM-Estimation of
                 ACD and GARCH Models jointly:
                 We vary the number of moment restrictions
                 See procedure gmm_hf for
                 details of the possible specifications of a joint
                 GMM estimation of ACD GARCH models.
                 !! same as 75 (Paper model) using a different kappa (Ghysels and Jasiak s 6.3667521
   Date:         28.6.2000
   Time:
   Comments:     The necessary procedures are in highfreq.src
                 !! Some hints on optimization !!!
                 sensitivity for first iterations to
                 co_LineSearch (2 not suitable, 1 better)
                 co_lineSearch 1 is sometimes bad for
                 GMM 2 estimation (breaks down with starting values from
                 GMM 1) Choosing 3 (half)
                 is more robust but also a little slower. one might consider
                 switching the algorithm within estimation.
                 NEWTON seems best and robust algorithm for all GMM steps
                 with foreward differencing, the maximum is failed
                 to reach, but converging anyway !
                 => use _co_GradMethod  = 0 !
   Author(s):    Dr. Joachim Grammig
                 grammig@wiwi.uni-frankfurt.de
*/

#include highfreq.dec;
#include highfreq.ext;
data        = "m21";
model       = "ACDGARCH";
let endog_a = xsnakeh3;           /* Name ACD endogenous var.(transaction duration)     */
let endog   = rsc_100;            /* Name endogenous var.(return)*/
let exo_a   = {};                 /* Names independent variables in psi equation:       */
let exog    = {};                 /* exog. variables for return equation*/
CONST       = 0;                  /* Set to one if constant in mean wanted              */
GAACDSUB    = 20;                 /*  GAACDSUB == 10: Psi is exogenous for h: Psi
                                                      is computed beforehand, then
                                                      h (which is a function of psi)
                                      GAACDSUB == 11: 10 with GARCH in Mean
                                      GAACDSUB == 20: h(t-1) determines psi:
                                      GAACDSUB == 20: as 20 with GARCH in Mean          */
/* Note: NextGlobals are for additional orthogonalization restrictions
   if these globals are zero then no additional orthogonality restric-
   tions over those in Hamilton 1994 are imoposed
   The ones found are motivated by Ghysels and Jasiak 1998                              */
/******************** Fixed Moment Conditions *************************/
o_t       = 0;                    /* Lag Length lagged durations in Return equation     */
IF o_t >0;
  let dura = xsnakeh3;            /* Var. Name for Duration                             */
ENDIF;
/* The following are nonsense !! */
A_W_MEAN_ = 0;                    /* Restrict mean of ACD Residual to 0                 */
IID_A_W   = 0;                    /* Lag of Autocorrelat. ACD GMM Residual              */
W_MEAN_0  = 0;                    /* Restrict unconditional mean of                     */
                                  /* GARCH Residual equal 0                             */
IID_W     = 0;                    /* Lag of Autocorrelat. GARCH-GMM Residual            */
/* Ende nonsense */
/******************** Variable Moment Conditions ****************************************/
/*IID_LAG                            Set to at least the number of lag
                                     to be included as orthogonality
                                     restrictions in the ACD estimation
                                     if ACDSUB == 2 ord ACDSUB == 12
                                     Is of no effect if ACDSUB == 1                     */
/*o_y  @                             Lag Length lagged returns in Return equation       */
/*o_u  @                             Lag length for return innovations as ortho.
                                     restrictions in conditional variance               */
/*o_u2 @                             Lag length for squared return
                                     innovations. Use more than in
                                     GARCH specification  already used
                                     e.g.: if m=2 use at least 3 for
                                     additional orthogonality                           */
/*o_xi                               Weak ACD restrictions                              */
/****************************************************************************************/

/* The model selected by GMM-BIC */
output file =  JoE-1e.out reset;
spec        = "JoE-1e";
FEEDBACK    = 2;
ACDSUB      = 12;                 /* 1: Only instruments, 2: only iid 12: both          */
p           = 1;                  /* order lagged psi (as in ML                         */
q           = 1;                  /* order lagged durations (as in ML)                  */
GMM1MAXI    = 1;                  /* Maximal iteration of GMM1                          */
GMM3        = 1;                  /* GMM3 yes(1) or no(0)                               */
NEWEST_LAG  = 24;                 /* Lag in Weighting Matrix                            */
XI_PSI_MEAN_1= 1;                 /* Orthogonality Restriction E(xi/psi-1) = 0          */
o_y         = 30;
o_u         = 30;
o_u2        = 30;
o_xi        = 30;
IID_LAG     = 30;
loadm x0    = ag201276_b_gmm1;
x0          = x0[1:5]|x0[7:rows(x0)];
#include highfreq.rof;
#include gmm_est.rof;
save joe-1e_f0         = f_gmm3;
save joe-1e_b          = b_gmm3;
vc_gmm3                = vc_gmm3/cases;
save joe-rec_vc        = vc_gmm3;
for_us                 = "SERIES";
temp                   = gmm_hf(b_gmm3);
save series_joe_-1e = temp;

let A   = {0 0 0 0 0 0 1 0, 0 0 0 0 0 0 0 1};
Fstat   = A*b_gmm3'*(A*vc_gmm3*A')*A*b_gmm3;
n1      = rows(A);
n2      = cases;
pvalue  = cdffc(Fstat,n1,n2);
pvalue2 = cdfbeta(n2/(n2+n1*Fstat),n2/2,n1/2); /* See GAUSS manual, p. 1058 */

