@  This GAUSS program reads in weekly forecasts from ACH model
	and translates them into monthly, compares with actual data 

format /mb1;@

new;
library pgraph;
graphset; 

 output file = mymonth7.out;
 output on;

format /rd 0,0; 
x = date; v = time;
"---------------------------------------------------------------------";
"date: ";;x[3];;".";;x[2];;".";;x[1];;"time: ";;v[1];;":";;v[2];


/**********************options for the models and settings*****************/
declare string models = "opm" "mod9" "mod2";

/*1) acm models all yes except dm
2) model average mse and save yes */
mse_pro = "yes";
save_results = "yes"; /* only concerning the mse */
auto_hist_pro = "yes";


/* PATH DEFINITIONS */
fide = "/";
lp1="/home/kehrleke/share/gk2005/homepage"$+fide$+"results_fore"$+fide;
lp2="/home/kehrleke/share/gk2005/";
svp_st = lp1;
svp_mse = lp1; 

#include readdatb4.prg; 

/* samples that are going to be evaluated */
sample_index = {1 2 3 4}; /*   1: insample
			       2: first outsample 5/01-5/04
			       3: second outsample 6/04 - 1/06
			       4: outsample total 5/01-1/06 */

/* THIS IS FOR THE  HISTOGRAMS */
number_of_bins = 10; /* only possible 10 or 20 otherwise the y-axis of the hist does not fit */
conf_interval = 0.95;
/* THIS IS FOR THE AUTOCORRELATION PLOTS*/
lagorder = 6;

/* for sample 4: only lages up to 3 are possible */
/* THIS IS FOR THE UNIVORMITY TESTS */
"----------------------------------------------------------";
"ACHTUNG choice is not allowed to be bigger than horizon !!!!!";
choice = seqa(1,1,60);
choice =  {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,24,26,28,30,36,40,50,52,60};
choice = seqa(1,1,60);
"this are the chosen horizons to be written out in the evaluation!!";
choice';
"----------------------------------------------------------";

/* FORMAT SETTING */
rounding = 9,10;
format /rd rounding; 
/************************end of settings **********************************/
"------OPTIONS---------------------------------------------";
"----------------------------------------------------------";
"     MSE EVALUATION       = ";; $mse_pro;
"     DENSITY EVALUATION   = ";; $auto_hist_pro;
"     SAVE RESULTS ?       = ";; $save_results;
"----------------------------------------------------------";
"----------------------------------------------------------";
"----PATH SETTINGS-----------------------------------------";
"     laod path1";;$lp1;
"     laod path2";;$lp2;
"     save path ";;$svp_st;
"  msesave path ";;$svp_mse;
"----------------------------------------------------------";
"------MODELS EVALUATED------------------------------------";
"     MODELS ";;$models;
"----------------------------------------------------------";

load path = ^lp1 options = options_monte.fmt;

hor = options[1];      @ hor is number of weekly horizons analyzed @
      @ 60   number of forecasted horizons     @ 
nmonte =options[2];  @ 100       @       @ nmonte is the number of simulations per observation @
ti =  options[3];@ t1 is the last period analyzed in weekly analysis @
z_monte = options[4]; /* number of simulations for the pit z series **********/
"------FORECAST  OPTIONS-----------------------------------";
"----------------------------------------------------------";
"_______________________horizon = ";; hor;
"_____________nmonte (forecast) = ";; nmonte;
"_________z_monte  (evaluation) = ";; z_monte;
"_observation used for forecast = ";; ti;
"----------------------------------------------------------";
"----------------------------------------------------------";

delprob = 0;
cvec = 0;
hori=0; _pscreen = 0;
noGraphics = 0;A = 0; B= 0; ct = 0; D1 = 0; D2 = 0;

if choice[rows(choice),.] gt hor; stop; endif;
if choice[rows(choice),.] lt hor; stop; endif;

lagtargetweeks = lagtar[.,4]; 

/*this was for the old code*/
nt = 505;
load  path = ^lp2 yz[nt,7] = mvardat.csv;
yz = yz[.,1] ~ yz[.,5] ~yz[.,2:4]~yz[.,6:7];
h0 = 302;
sample_end = rows(yz);

loadm  path = ^lp2 ffr_month[622,2] = ffrmonthlycsv.csv;
yz = ffr_month;

/* this is the sample start for the old and new sample size*/
h0 = 357;

/* this is the sample end for the new sample size*/
/* -3 because we have the effective for march 2006 however the
forecast evaluation for the target goes to january 2006 */
sample_end = rows(yz)-3;

"if h0 = ";;h0; "mse starts with";; yz[h0,1];
"if sample_end = ";;sample_end; "mse ends with";; yz[sample_end,1];

/****************************************************************************
	convert ACH weekly forecasts to a monthly basis 
  ***************************************************************************/
hormonths = 12;       @ hormonths is the max forecast horizon in months @

@ first eliminate all rows except those corresponding to end of month @

indexofweeks2 = seqa(1,1,ti);
indexofweeks = weektomonth(indexofweeks2,1); 
		 @ this gives week 	corresponding to each month @
targetmonths = weektomonth(target,1);

fridatemonths = weektomonth(fridate,1);
lagtargetmonths = weektomonth(lagtargetweeks,1); 

smpli = 1;
do until smpli gt cols(sample_index);

sample = sample_index[smpli];
if sample == 1;
/* this is for insample mse */
selvec_lower   =  yz[.,1]            .==  198504.00;
selvec_higher  =  yz[.,1]            .==  200102.00;
selvec_lower2  =  fridatemonths[.,1] .==  19850426.00;
selvec_higher2 =  fridatemonths[.,1] .==  20010223.00;
boundaries = 61 | 896;
svp = svp_st  $+ "insample"  $+ fide;
elseif sample == 2;
/* this is for outsample 1 2001-2004 mse */
selvec_lower   =  yz[.,1]            .==  200105.00;
selvec_higher  =  yz[.,1]            .==  200405.00;
selvec_lower2  =  fridatemonths[.,1] .==  20010601.00;
selvec_higher2 =  fridatemonths[.,1] .==  20040528.00;
boundaries = 897 | 1057;
svp = svp_st  $+ "outsample1"  $+ fide;
elseif sample == 3;
/* this is for outsample 2 mse 2004-2006 */
selvec_lower   =  yz[.,1]            .==  200406.00;
selvec_higher  =  yz[.,1]            .==  200601.00;
selvec_lower2  =  fridatemonths[.,1] .==  20040625.00;
selvec_higher2 =  fridatemonths[.,1] .==  20060127.00;
boundaries = 1058 | 1144; /* till the end of january 2006 */
svp = svp_st  $+ "outsample2"  $+ fide;
elseif sample == 4;
/* this is for outsample 3 mse 2001-2006 */
selvec_lower   =  yz[.,1]            .==  200105.00;
selvec_higher  =  yz[.,1]            .==  200601.00;
selvec_lower2  =  fridatemonths[.,1] .==  20010601.00;
selvec_higher2 =  fridatemonths[.,1] .==  20060127.00;
boundaries = 897 | 1144; /* till the end of january 2006 */
svp = svp_st  $+ "outsample3"  $+ fide;
else;
"not defined";stop;
endif;

sel_lower = rows(selvec_lower)-sumc(cumsumc(selvec_lower))+1;
sel_higher = rows(selvec_higher)-sumc(cumsumc(selvec_higher))+1;
sel_lower2 = rows(selvec_lower2)-sumc(cumsumc(selvec_lower2))+1;
sel_higher2 = rows(selvec_higher2)-sumc(cumsumc(selvec_higher2))+1;
"lower ";; yz[sel_lower,1];;fridatemonths[sel_lower2,1];
"higher";; yz[sel_higher,1];;fridatemonths[sel_higher2,1];

yz2 = yz[sel_lower:sel_higher,1:2];
#include mymonthch9.src;

index = 1; 
do until index gt rows(models); 
mod_name = models[index]; 

if mse_pro $== "yes";
icon = "i2";
/* this produces the mse */
errs = mse_12_months(mod_name,icon,hormonths,sel_lower2,sel_higher2);
{mse,se} = mseprod(errs,mod_name);
endif;

mod_name;

endif;

if save_results $== "yes";
call save_prc2(mod_name,icon,mse,se,sample);
endif;

/* this produces the histogramms and autocorrelations
i.e. the evaluation of the z series */
if auto_hist_pro $== "yes";
icon = "i1";
name = "num_mat_"  $+ ".fmt"; 
load path = ^lp1   num_mat = ^name;
name4 = "z_mat_" $+ mod_name $+ ".fmt";
load path = ^lp1  z_mat = ^name4;
sel = (num_mat .ge boundaries[1]) .and (num_mat .le boundaries[2]) .and (num_mat .le ti);
call histogr_lb_auto(choice,z_mat,sel,mod_name,lagorder,z_monte); 
endif;

index = index+1;
endo;

smpli = smpli +1;
endo;

 output off;  


