/* Bootstrap DCX */

library gauss pgraph;
graphset;
#include auxils.src;                @some auxiliary procedures@
#include ci_procs.src;              @the core procedures for the project@

/* 1. Select input GAUSS file for one of the three stocks
*********************************************************/

file        = "dcxnyr10";

/* 2. Read in data: Leave always active
***************************************/
data_matrix = data_in_matrix(file); @ Read data into matrix @

/* 3. Compute log midquotes: Leave always active
************************************************/
nymidq = ln((data_matrix[.,3]+data_matrix[.,4])/2);
xmidq  = ln((data_matrix[.,7]+data_matrix[.,8])/2);
exmidq = ln((data_matrix[.,9]+data_matrix[.,10])/2);
ln_ciseries     = exmidq~xmidq~nymidq;
firstday_series = data_matrix[.,11];  @First day indicator series@

/* 4. Specify Model parameters
******************************/
k          = 4;@ lags used in VECM: You may change this@
s          = 1000; @Steps head for psi computation@
@Leave the others unchanged:@
p          = -9;@forget@
h          = 1; @Number  of cointegrating relations to be selected (get it by
                 nunning the procedure and looking at the LR
                 stats@
use_constant= 0; @Use no constant in the auxiliary regressions@
seed       = 150263; /* Initialize the random number generator */

delete_flag=deleteflag(firstday_series,k);
simulation_runs     = 1000;
usefrom             = 0;
numobs              = rows(ln_ciseries);

{info_share_boot,ci_vector_boot,ec_param_boot,psi_of_one_boot,partcorrs_boot} =
bootstrap_ci(ln_ciseries,k,simulation_runs,usefrom,numobs,use_constant,h,delete_flag,s);

save  DCX_info_share_boot=info_share_boot;
save  DCX_ci_vector_boot=ci_vector_boot;
save  DCX_ec_param_boot=ec_param_boot;
save  DCX_psi_of_one_boot=psi_of_one_boot;
save  DCX_partcorrs_boot=partcorrs_boot  ;
