clear
clc
close all
warning('off','MATLAB:table:ModifiedAndSavedVarnames');

% select number of days by which deaths should be shifted
death_shift = 19;
% If Germany, decide whether or not to use Nowcasting data
nowcast = 1;
reset_death = 1;

if (nowcast == 0) && (reset_death == 1)
    error('Makes no sense')
end

% load data
data = readtable('Fallzahlen_RKI.csv'); % https://www.rki.de/DE/Content/InfAZ/N/Neuartiges_Coronavirus/Daten/Fallzahlen_Kum_Tab.html
data = table2timetable(table(datetime(data.Date_reported,'InputFormat','dd.MM.yyyy'),...
    data.New_cases,data.Cases,data.New_deaths,data.Deaths,'VariableNames',{'Date','New_Cases','Sum_cases','New_deaths','Sum_deaths'}));
data.Properties.DimensionNames{1} = 'Date_reported';
tests = readtable('testzahlen.csv'); % Data taken from: https://www.rki.de/DE/Content/InfAZ/N/Neuartiges_Coronavirus/Testzahl.html
R = datenum('3-12-2020');
for i = 2:size(tests,1)
R2 = addtodate(datenum('3-12-2020'), 7*(i-1), 'day');
R = [R;R2];
end
data4 = table2timetable(tests(:,2),'RowTimes',datetime(datestr(R)));
data3 = data;
if nowcast == 1
    data2 = readtable('Nowcasting_Zahlen.csv'); % Data taken from here https://www.rki.de/DE/Content/InfAZ/N/Neuartiges_Coronavirus/Projekte_RKI/Nowcasting.html
    data2.Properties.VariableNames{1} = 'Infection_Date';
    data2.Properties.VariableNames{2} = 'New_Cases_nowcast';
    data2 = table2timetable(table(datetime(data2.Infection_Date,'InputFormat','dd.MM.yyyy'),...
        data2.New_Cases_nowcast,'VariableNames',{'Date','New_Cases_nowcast'}));
    data2.Cum_cases_nowcast = cumsum(data2.New_Cases_nowcast);
    data = synchronize(data,data2);
    data.Cumulative_cases = data.Cum_cases_nowcast;
    data = data(timerange(data2.Date(1),data.Date_reported(end)),:);
else 
    data.Cumulative_cases = data.Sum_cases;
end
if reset_death == 0
    T2 = table2timetable(table(data.Date_reported,data.Sum_deaths,...
        'VariableNames',{'Date','Deaths'}));
    TT = lag(T2,-death_shift);
    data = synchronize(data,TT);
    data.Cumulative_deaths = data.Deaths;
else
    T2 = table2timetable(table(data.Date_reported,data.New_deaths,...
        'VariableNames',{'Date','Deaths'})); 
    TT = lag(T2,-death_shift); 
    TT.Cum_deaths = cumsum(TT.Deaths);
    data = synchronize(data,TT);
    data.Cumulative_deaths = data.Cum_deaths;
end
   
% compute mortatility rate (cond on tested)
mort = data.Cumulative_deaths./data.Cumulative_cases;
data.Var9 = mort;

idx = isnan(data.Var9);
data(idx,:) = [];
% define beginning of plot
date_max = max(data.Date_reported);
date_max2 = max(data2.Date);
TR = timerange('2020-03-01',date_max);
data = data(TR,:);

% data2 = [timetable(datetime('01-Mar-2020'),-1,-1, 'VariableNames',{'New_Cases_nowcast','Cum_cases_nowcast'}); data2];


figure
plot([datetime({'2020-11-03'},'InputFormat','yyyy-MM-dd');datetime({'2020-11-03'},'InputFormat','yyyy-MM-dd')],[-1;17],'-','Color',[168 168 168]/255)
hold on
plot([datetime({'2020-5-11'},'InputFormat','yyyy-MM-dd');datetime({'2020-5-11'},'InputFormat','yyyy-MM-dd')],[-1;5],'-','Color',[168 168 168]/255)
plot([datetime({'2020-8-3'},'InputFormat','yyyy-MM-dd');datetime({'2020-8-3'},'InputFormat','yyyy-MM-dd')],[-1;12],'-','Color',[168 168 168]/255)
plot([datetime({'2020-6-22'},'InputFormat','yyyy-MM-dd');datetime({'2020-6-22'},'InputFormat','yyyy-MM-dd')],[-1;8.5],'-','Color',[168 168 168]/255)
plot(data4.Time,data4.Tests/100000,'Color',[95 158 160]/255,'Linewidth',1.5)
hold off
text(datetime({'2020-10-15'},'InputFormat','yyyy-MM-dd'),19.1,'change in ')
text(datetime({'2020-10-20'},'InputFormat','yyyy-MM-dd'),18.3,'testing')
text(datetime({'2020-10-17'},'InputFormat','yyyy-MM-dd'),17.5,'strategy')
text(datetime({'2020-3-25'},'InputFormat','yyyy-MM-dd'),7.1,'health insurance funds')
text(datetime({'2020-4-11'},'InputFormat','yyyy-MM-dd'),6.3,'cover costs for')
text(datetime({'2020-4-1'},'InputFormat','yyyy-MM-dd'),5.5,'voluntary PCR tests ')
text(datetime({'2020-6-27'},'InputFormat','yyyy-MM-dd'),14.1,'mandatory testing')
text(datetime({'2020-7-9'},'InputFormat','yyyy-MM-dd'),13.3,'for returning')
text(datetime({'2020-7-17'},'InputFormat','yyyy-MM-dd'),12.5,'travelers')
text(datetime({'2020-5-22'},'InputFormat','yyyy-MM-dd'),9.8,'start of earliest')
text(datetime({'2020-5-19'},'InputFormat','yyyy-MM-dd'),9,'school vacations')
hAx=gca;                                        % get axes handle
hAx.XAxis.TickLabelFormat='ddMMM';            % set the format to concise form
hAx.XTickLabel=hAx.XTickLabel;
k = ylim;
ylim([0 20])
hAx.YTickLabel={'0','2','4','6','8','10','12','14','16','18','20'};
set(gca,'FontSize',11,'TickLabelInterpreter','latex')
saveas(gcf,['Tests2'],'epsc')


figure
plot(data3.Date_reported,data3.New_deaths*0+1,'Color','w')
hold on
plot([datetime({'2020-04-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-04-01'},'InputFormat','yyyy-MM-dd')],[-1;25],'--','Color',[168 168 168]/255)
plot([datetime({'2020-05-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-05-01'},'InputFormat','yyyy-MM-dd')],[-1;25],'--','Color',[168 168 168]/255)
plot([datetime({'2020-06-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-06-01'},'InputFormat','yyyy-MM-dd')],[-1;25],'--','Color',[168 168 168]/255)
plot([datetime({'2020-07-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-07-01'},'InputFormat','yyyy-MM-dd')],[-1;25],'--','Color',[168 168 168]/255)
plot([datetime({'2020-08-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-08-01'},'InputFormat','yyyy-MM-dd')],[-1;25],'--','Color',[168 168 168]/255)
plot([datetime({'2020-09-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-09-01'},'InputFormat','yyyy-MM-dd')],[-1;25],'--','Color',[168 168 168]/255)
plot([datetime({'2020-10-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-10-01'},'InputFormat','yyyy-MM-dd')],[-1;25],'--','Color',[168 168 168]/255)
plot([datetime({'2020-11-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-11-01'},'InputFormat','yyyy-MM-dd')],[-1;25],'--','Color',[168 168 168]/255)
plot(data2.Date,data2.New_Cases_nowcast/1000,'Color',[95 158 160]/255,'Linewidth',1.5)
hold off
hAx=gca;                                        % get axes handle
ixmajor=find(day(data3.Date_reported)==1);                        % indices for first of month in time vector
hAx.XTick=data3.Date_reported(ixmajor);                        % set ticks appropriately
hAx.XAxis.TickLabelFormat='ddMMM';            % set the format to concise form
hAx.XTickLabel=hAx.XTickLabel;  
DateStrings = {'2020-03-01';'2020-12-01'};
t = datetime(DateStrings,'InputFormat','yyyy-MM-dd');
xlim([t(1) datetime('2020-12-01')])
k = ylim;
hAx.YAxis.Limits = [0 k(2)];
set(gca,'FontSize',11,'TickLabelInterpreter','latex')
saveas(gcf,['Nowcast2'],'epsc')


figure
plot([datetime({'2020-04-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-04-01'},'InputFormat','yyyy-MM-dd')],[-1;500],'--','Color',[168 168 168]/255)
hold on
plot([datetime({'2020-05-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-05-01'},'InputFormat','yyyy-MM-dd')],[-1;500],'--','Color',[168 168 168]/255)
plot([datetime({'2020-06-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-06-01'},'InputFormat','yyyy-MM-dd')],[-1;500],'--','Color',[168 168 168]/255)
plot([datetime({'2020-07-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-07-01'},'InputFormat','yyyy-MM-dd')],[-1;500],'--','Color',[168 168 168]/255)
plot([datetime({'2020-08-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-08-01'},'InputFormat','yyyy-MM-dd')],[-1;500],'--','Color',[168 168 168]/255)
plot([datetime({'2020-09-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-09-01'},'InputFormat','yyyy-MM-dd')],[-1;500],'--','Color',[168 168 168]/255)
plot([datetime({'2020-10-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-10-01'},'InputFormat','yyyy-MM-dd')],[-1;500],'--','Color',[168 168 168]/255)
plot([datetime({'2020-11-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-11-01'},'InputFormat','yyyy-MM-dd')],[-1;500],'--','Color',[168 168 168]/255)
plot(data3.Date_reported,data3.New_deaths,'Color',[95 158 160]/255,'Linewidth',1.5)
hold off
hAx=gca;                                        % get axes handle
ixmajor=find(day(data3.Date_reported)==1);                        % indices for first of month in time vector
hAx.XTick=data3.Date_reported(ixmajor);                        % set ticks appropriately
hAx.XAxis.TickLabelFormat='ddMMM';            % set the format to concise form
hAx.XTickLabel=hAx.XTickLabel;  
DateStrings = {'2020-03-01';'2020-11-01'};
t = datetime(DateStrings,'InputFormat','yyyy-MM-dd');
xlim([t(1) datetime('2020-12-01')])
k = ylim;
hAx.YAxis.Limits = [0 k(2)];
hAx.YAxis.Exponent = 0;
set(gca,'FontSize',11,'TickLabelInterpreter','latex')
saveas(gcf,['Deaths2'],'epsc')


figure
plot(data3.Date_reported,data3.New_deaths+500,'Color','w')
hold on
plot([datetime({'2020-04-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-04-01'},'InputFormat','yyyy-MM-dd')],[-1;max(data.Var9*100)+2],'--','Color',[168 168 168]/255)
plot([datetime({'2020-05-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-05-01'},'InputFormat','yyyy-MM-dd')],[-1;max(data.Var9*100)+2],'--','Color',[168 168 168]/255)
plot([datetime({'2020-06-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-06-01'},'InputFormat','yyyy-MM-dd')],[-1;max(data.Var9*100)+2],'--','Color',[168 168 168]/255)
plot([datetime({'2020-07-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-07-01'},'InputFormat','yyyy-MM-dd')],[-1;max(data.Var9*100)+2],'--','Color',[168 168 168]/255)
plot([datetime({'2020-08-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-08-01'},'InputFormat','yyyy-MM-dd')],[-1;max(data.Var9*100)+2],'--','Color',[168 168 168]/255)
plot([datetime({'2020-09-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-09-01'},'InputFormat','yyyy-MM-dd')],[-1;max(data.Var9*100)+2],'--','Color',[168 168 168]/255)
plot([datetime({'2020-10-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-10-01'},'InputFormat','yyyy-MM-dd')],[-1;max(data.Var9*100)+2],'--','Color',[168 168 168]/255)
plot([datetime({'2020-11-01'},'InputFormat','yyyy-MM-dd');datetime({'2020-11-01'},'InputFormat','yyyy-MM-dd')],[-1;max(data.Var9*100)+2],'--','Color',[168 168 168]/255)
plot(data.Date_reported,data.Var9*100,'Color',[95 158 160]/255,'Linewidth',2.5)
yticks(0:1:7)    
hold off
hAx=gca;                                        % get axes handle
ixmajor=find(day(data3.Date_reported)==1);                        % indices for first of month in time vector
hAx.XTick=data3.Date_reported(ixmajor);                        % set ticks appropriately
hAx.XAxis.TickLabelFormat='ddMMM';            % set the format to concise form
hAx.XTickLabel=hAx.XTickLabel;
DateStrings = {'2020-03-01';'2020-12-01'};
t = datetime(DateStrings,'InputFormat','yyyy-MM-dd');
xlim([t(1) datetime('2020-12-01')])
hAx.YAxis.Limits = [-0.05 max(data.Var9*100)];
k = ylim;
hAx.YAxis.Limits = [0 k(2)+2];
set(gca,'FontSize',11,'TickLabelInterpreter','latex')
set(gca,'XColor',[0 0 0]);
saveas(gcf,['CFR2_Germany_deaths' num2str(death_shift)],'epsc')

