% (C)2014-15 Pratik Jawanpuria, Maksim Lapin, Matthias Hein and Bernt Schiele
% Machine Learning Group, Saarland University, Germany
% http://www.ml.uni-saarland.de
% Computer Vision and Multimodal Computing, Max-Planck-Institut für Informatik, Germany
% https://www.mpi-inf.mpg.de/departments/computer-vision-and-multimodal-computing/

clear all
clc

addpath mex
load toyDataset/toyDataset.mat % an instance of multi-class SUN397 dataset

Ktrn = Xtrn'*Xtrn; % Kernel matrix 
Ytrn = Ytrn'; % output (class identifier), 397 classes

eta = 1e4; % Hyperparameter (refer to our paper for its exact expression), positive number

myEpsilon = 1e-3; % Duality Gap, positive number - typically close to zero
% Please note that for general p-norm solvers (p not equal to 2), Newton method is employed in each iteration (for solving the one dimensional small problem). The convergence threshold for Newton method is set via the variable diff_threshold (in files eokl_mol_sdca_hinge_pnorm_p_v1.cc line 143 and eokl_mol_sdca_squared_pnorm_p_v1.cc line 138 in src/mex/ folder). By default, this threshold is set to 10^-5 (which worked fine for 1e-3 duality gap). To achieve lower duality gap, one may need to lower this threshold as well. However, this is applicable only for p-norm < 2. For p-norm = 2, we compute exact solution for the small problem. 


CheckGapFrequency = 20; % The number of epochs after which duality gap is checked (which is computationally expensive step), positive integer

MaxEpoch = 10000; % Max number of epochs of SDCA algorithm, positive integer

seed = 0.0; % seed value for the randomization of SDCA, non-negative number

qinv2 = 1; % q-norm value (dual of the primal p-norm), positive integer

NegLabel = 0; % Negative label for squared loss in classification problem (usually set as 0 or -1)

weight_pos = 1; % For weighted Hinge loss, positive number

weight_neg = 1; % For weighted Hinge loss, positive number

% Output variables: 
% A : the dual variables, dimensions: number_of_classes x number_of_training_examples
% Theta : the output kernel matrix, dimensions: number_of_classes x number_of_classes
% info : a struct variable contains several information regarding the run. Its fields are self explanatory. 
% primalObjVec : an array containing the primal objective value at every CheckGapFrequency^{th} epoch. Its dimension is fixed as floor(MaxEpoch/CheckGapFrequency) + 1. Initialized as zeros.
% dualObjVec : an array containing the dual objective value at every CheckGapFrequency^{th} epoch. Its dimension is fixed as floor(MaxEpoch/CheckGapFrequency) + 1. Initialized as zeros.
% cpuTimeVec : an array containing the cputime spent on execution till the CheckGapFrequency^{th} epoch. Its dimension is fixed as floor(MaxEpoch/CheckGapFrequency) + 1. Initialized as zeros.
% wallTimeVec : an array containing the cputime spent on execution till the CheckGapFrequency^{th} epoch. Its dimension is fixed as floor(MaxEpoch/CheckGapFrequency) + 1. Initialized as zeros.

% Squared loss, p-norm = 2 (=> q-norm = 2)
[A,Theta,info,primalObjVec,dualObjVec,cpuTimeVec,wallTimeVec] = eokl_mol_sdca_squared_2norm_v6(Ytrn,Ktrn,eta,myEpsilon,CheckGapFrequency,MaxEpoch,seed,NegLabel);

% Squared loss, general p-norm. For p-norm = 2, please use the above faster code. Dual q-norm = 2*qinv2, q-norm = p-norm/(p-norm - 1). Only even positive integers are permitted for q-norm (refer to our paper for details)
[A1, Theta1,info1,primalObjVec1,dualObjVec1,cpuTimeVec1,wallTimeVec1] = eokl_mol_sdca_squared_pnorm_p_v1(Ytrn,Ktrn,eta,qinv2,myEpsilon,CheckGapFrequency,MaxEpoch,seed,NegLabel);

% Weighted Hinge loss, p-norm = 2 (=> q-norm = 2)
[A2, Theta2,info2,primalObjVec2,dualObjVec2,cpuTimeVec2,wallTimeVec2] = eokl_mol_sdca_hinge_2norm_v7(Ytrn,Ktrn,eta,myEpsilon,CheckGapFrequency,MaxEpoch,seed,weight_pos,weight_neg);

% Hinge loss, general p-norm.
[A3, Theta3,info3,primalObjVec3,dualObjVec3,cpuTimeVec3,wallTimeVec3] = eokl_mol_sdca_hinge_pnorm_p_v1(Ytrn,Ktrn,eta,qinv2,myEpsilon,CheckGapFrequency,MaxEpoch,seed);

