/**
 * Enumeration of implemented neuron activation types (Header+Implementation)
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of RNNPBlib.
 * 
 * RNNPBlib is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * RNNPBlib is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with RNNPBlib. If not, see http://www.gnu.org/licenses/.
 */

#pragma once

enum ActivationType
{
	Linear,				//Includes concept- and bias-neurons (for "constant=true")
	Tanh,
	QuasiLinear,			//Attention: only if flat-spot-elimination is enabled!
	Heaviside,			//Attention: only if flat-spot-elimination is enabled!
	Logistic,			
	RadialGaussian,
	RadialLinear			//Non-deforming radial function. Useful for function symmetry detection too!
};
