/*
  ------------------------------------------------------------------------
   Frontent Programm to reproduce results for Bayer Stock
  ------------------------------------------------------------------------
  Prozeduren werden aus bidask.PRC 
  eingebunden                                                        
*/



/* ************************************** */
/* 1. Initialisierungen fuer Prozedur cml */
/* ************************************** */

/* Globals: Do not change */

   library  cml;                  
   #include cml.ext;              
   cmlset;                        
  _cml_Algorithm  = 1;            /* 1=BFGS  2=DFP  3=NEWTON  4=BHHH */
  _cml_GradMethod = 1;            /* 0 = central; 1 = forward */
  _cml_CovPar=3;                  /* VC-Matrix: 3 = White */
  _Cml_GradChektol = 1e-5;
  Output File =   as0elang.out reset;  /* Output-File */
 
  T           =   3; /* Parallele Trading hours 3 Stunden */


 /* ******************************************/
 /* 1. Modellspezific definitions Floor */
 /* ******************************************/

   
   data        =  "a5s0e"; /* Input-Data */
 
   print "Die Daten werden gelesen vom Datensatz: ";;$data; print;
   open in = ^data for read;
   cases   = rowsf(in);
   __row =cases;                
   datain  = readr(in,cases);
   in      = close(in);
   let ssells = ssells;
   let sbuys  = sbuys;
   let fsells = fsells;
   let fbuys  = fbuys;
   varnames = getname(data);
   
   fSadress = indcv(fsells,varnames);
   fBadress = indcv(fbuys,varnames);
   sSadress = indcv(ssells,varnames);
   sBadress = indcv(sbuys,varnames);

   FS       = datain[.,FSadress];        /* Number of Sells */
   FB       = datain[.,FBadress];        /* Number of Buys  */
   SS       = datain[.,SSadress];        /* Number of Sells */
   SB       = datain[.,SBadress];        /* Number of Buys  */
  
  days       = rows(SS);



 /* Estimation with restricted alpha and delta */


  let EKOP_R = 2;
  
  #include bidask2.prc;  
                               
  let x0      = -0.063 10.435 -0.262 9.369 10.435 9.369; /* Startwerte */
  {bet,f0,g,vc,retcode} = cml(datain,0,&li_baj,x0);
  save b_a5s0r2  = bet;
  save f0_a5s0r2 = f0;
  save g_a5s0r2  = g;
  save vc_a5s0r2 = vc;
  save retcode_a5s0r2 = retcode;
  se_a5s0r2 = sqrt(diag(vc));
  save se_a5s0r2;
  tval_a5s0r2 =bet./sqrt(diag(vc));
  save tval_a5s0r2;
  /* Estimation Probability of informed trade */
  temp1 =ecostd3(bet,vc);
  a5s0r2 = temp1[.,1]~sqrt(temp1[.,2])~temp1[.,1]./sqrt(temp1[.,2])~(ones(rows(temp1),1).*f0*days);
  save a5s0r2; 

 /* Estimation with unrestricted parameters */

  let EKOP_R = 0; 
  let x0 = -0.063 10.435 -0.262 9.369 -0.063 9.369 -0.262  9.369;
  {bet,f0,g,vc,retcode} = cml(datain,0,&li_baj,x0);
  temp2 =ecostd3(bet,vc);
  save b_a5s0r0 = bet;
  save f0_a5s0r0 = f0;
  save g_a5s0r0  = g;
  save vc_a5s0r0 = vc;
  save retcode_a5s0r0 = retcode;
  se_a5s0r0 = sqrt(diag(vc));
  save se_a5s0r0;
  tval_a5s0r0 =bet./sqrt(diag(vc));
  save tval_a5s0r0;
  /* Estimation Probability of informed trade */
  a5s0r0 = temp2[.,1]~sqrt(temp2[.,2])~temp1[.,1]./sqrt(temp2[.,2])~(ones(rows(temp2),1).*f0*days);
  save a5s0r0;


 /* Estimation with fully restricted parameters */

  let EKOP_R = 1; 
  let x0 = -0.063 10.435 -0.262 9.369;
  {bet,f0,g,vc,retcode} = cml(datain,0,&li_baj,x0);
  temp3=ecostd3(bet,vc);
  save b_a5s0r1  = bet;
  save f0_a5s0r1 = f0;
  save g_a5s0r1  = g;
  save vc_a5s0r1 = vc;
  save retcode_a5s0r1 = retcode;
  se_a5s0r1 = sqrt(diag(vc));
  save se_a5s0r1;
  tval_a5s0r1 =bet./sqrt(diag(vc));
  save tval_a5s0r1;
  /* Estimation Probability of informed trade */
  a5s0r1 = temp3[.,1]~sqrt(temp3[.,2])~temp3[.,1]./sqrt(temp3[.,2])~(ones(rows(temp3),1).*f0*days);
  save a5s0r1;


/* Anettes Likelihood-Ratio Test Section */

loadm f0_a5s0r0;
loadm f0_a5s0r1;
loadm f0_a5s0r2;      
La5r0 = cases*f0_a5s0r0;
La5r1 = cases*f0_a5s0r1;
La5r2 = cases*f0_a5s0r2;

Da5r0r1 = 2*(La5r0-La5r1);
Da5r0r2 = 2*(La5r0-La5r2);
Da5r2r1 = 2*(La5r2-La5r1);

Pa5r0r1 = cdfchic(2*(La5r0-La5r1),4);
Pa5r0r2 = cdfchic(2*(La5r0-La5r2),2);
Pa5r2r1 = cdfchic(2*(La5r2-La5r1),2);

Chisq5 =  Da5r0r1|Da5r0r2|Da5r2r1;
pValue5 = Pa5r0r1|Pa5r0r2|Pa5r2r1;
let df5 = 4 2 2;
Chi_a5s0= Chisq5~df5~pValue5 ; 
save Chi_a5s0; 




/* Aggregation level a1 */

 data        =  "a1s0e"; /* Input-Datensatz */
 
   print "Die Daten werden gelesen vom Datensatz: ";;$data; print;
   open in = ^data for read;
   cases   = rowsf(in);
   __row =cases;               
   datain  = readr(in,cases);
   in      = close(in);
   let ssells = ssells;
   let sbuys  = sbuys;
   let fsells = fsells;
   let fbuys  = fbuys;
   varnames = getname(data);
   /* Abhaengige Variable  */
   fSadress = indcv(fsells,varnames);
   fBadress = indcv(fbuys,varnames);
   sSadress = indcv(ssells,varnames);
   sBadress = indcv(sbuys,varnames);

   FS       = datain[.,FSadress];        /* Number of Sells */
   FB       = datain[.,FBadress];        /* Number of Buys  */
   SS       = datain[.,SSadress];        /* Number of Sells */
   SB       = datain[.,SBadress];        /* Number of Buys  */
  
  days       = rows(SS);

 
 /* Estimation with restricted alpha and delta */


  let EKOP_R = 2;
  #include bidask2.prc;                               
  let x0      = -0.063 10.435 -0.262 9.369 10.435 9.369; /* Startwerte */
  {bet,f0,g,vc,retcode} = cml(datain,0,&li_baj,x0);
  save b_a1s0r2  = bet;
  save f0_a1s0r2 = f0;
  save g_a1s0r2  = g;
  save vc_a1s0r2 = vc;
  save retcode_a1s0r2 = retcode;
  se_a1s0r2 = sqrt(diag(vc));
  save se_a1s0r2;
  tval_a1s0r2 =bet./sqrt(diag(vc));
  save tval_a1s0r2;
  /* Estimation Probability of informed trade */
  temp1 =ecostd3(bet,vc);
  a1s0r2 = temp1[.,1]~sqrt(temp1[.,2])~temp1[.,1]./sqrt(temp1[.,2])~(ones(rows(temp1),1).*f0*days);
  save a1s0r2; 

 /* Estimation with unrestricted parameters */

  let EKOP_R = 0; 
  let x0 = -0.063 10.435 -0.262 9.369 -0.063 9.369 -0.262  9.369;
  {bet,f0,g,vc,retcode} = cml(datain,0,&li_baj,x0);
  temp2 =ecostd3(bet,vc);
  save b_a1s0r0 = bet;
  save f0_a1s0r0 = f0;
  save g_a1s0r0  = g;
  save vc_a1s0r0 = vc;
  save retcode_a1s0r0 = retcode;
  se_a1s0r0 = sqrt(diag(vc));
  save se_a1s0r0;
  tval_a1s0r0 =bet./sqrt(diag(vc));
  save tval_a1s0r0;
  /* Estimation Probability of informed trade */
  a1s0r0 = temp2[.,1]~sqrt(temp2[.,2])~temp1[.,1]./sqrt(temp2[.,2])~(ones(rows(temp2),1).*f0*days);
  save a1s0r0;



/* Estimation with fully restricted parameters */

  let EKOP_R = 1; 
  let x0 = -0.063 10.435 -0.262 9.369;
  {bet,f0,g,vc,retcode} = cml(datain,0,&li_baj,x0);
  temp3=ecostd3(bet,vc);
  save b_a1s0r1  = bet;
  save f0_a1s0r1 = f0;
  save g_a1s0r1  = g;
  save vc_a1s0r1 = vc;
  save retcode_a1s0r1 = retcode;
  se_a1s0r1 = sqrt(diag(vc));
  save se_a1s0r1;
  tval_a1s0r1 =bet./sqrt(diag(vc));
  save tval_a1s0r1;
  /* Estimation Probability of informed trade */
  a1s0r1 = temp3[.,1]~sqrt(temp3[.,2])~temp3[.,1]./sqrt(temp3[.,2])~(ones(rows(temp3),1).*f0*days);
  save a1s0r1;



/* Anettes Likelihood-Ratio Test Section */

loadm f0_a1s0r0;
loadm f0_a1s0r1;
loadm f0_a1s0r2;      
La1r0 = cases*f0_a1s0r0;
La1r1 = cases*f0_a1s0r1;
La1r2 = cases*f0_a1s0r2;

Da1r0r1 = 2*(La1r0-La1r1);
Da1r0r2 = 2*(La1r0-La1r2);
Da1r2r1 = 2*(La1r2-La1r1);

Pa1r0r1 = cdfchic(2*(La1r0-La1r1),4);
Pa1r0r2 = cdfchic(2*(La1r0-La1r2),2);
Pa1r2r1 = cdfchic(2*(La1r2-La1r1),2);

Chisq1 =  Da1r0r1|Da1r0r2|Da1r2r1;
pValue1 = Pa1r0r1|Pa1r0r2|Pa1r2r1;
let df1 = 4 2 2;
Chi_a1s0= Chisq1~df1~pValue1 ; 
save Chi_a1s0; 



/*Aggregation level a0 */

data        =  "a0s0e"; /* Input-Data */
 
   print "Die Daten werden gelesen vom Datensatz: ";;$data; print;
   open in = ^data for read;
   cases   = rowsf(in);
   __row =cases;                
   datain  = readr(in,cases);
   in      = close(in);
   let ssells = ssells;
   let sbuys  = sbuys;
   let fsells = fsells;
   let fbuys  = fbuys;
   varnames = getname(data);
   
   fSadress = indcv(fsells,varnames);
   fBadress = indcv(fbuys,varnames);
   sSadress = indcv(ssells,varnames);
   sBadress = indcv(sbuys,varnames);

   FS       = datain[.,FSadress];        /* Number of Sells */
   FB       = datain[.,FBadress];        /* Number of Buys  */
   SS       = datain[.,SSadress];        /* Number of Sells */
   SB       = datain[.,SBadress];        /* Number of Buys  */
  
  days       = rows(SS);


 /* Estimation with restricted alpha and delta */

  let EKOP_R = 2;
  #include bidask2.prc;                               
  let x0      = -0.063 10.435 -0.262 9.369 10.435 9.369; /* Startwerte */
  {bet,f0,g,vc,retcode} = cml(datain,0,&li_baj,x0);
  save b_a0s0r2  = bet;
  save f0_a0s0r2 = f0;
  save g_a0s0r2  = g;
  save vc_a0s0r2 = vc;
  save retcode_a0s0r2 = retcode;
  se_a0s0r2 = sqrt(diag(vc));
  save se_a0s0r2;
  tval_a0s0r2 =bet./sqrt(diag(vc));
  save tval_a0s0r2;
  /* Estimation Probability of informed trade */
  temp1 =ecostd3(bet,vc);
  a0s0r2 = temp1[.,1]~sqrt(temp1[.,2])~temp1[.,1]./sqrt(temp1[.,2])~(ones(rows(temp1),1).*f0*days);
  save a0s0r2;

 /* Estimation with unrestricted parameters */

  let EKOP_R = 0; 
  let x0 = -0.063 10.435 -0.262 9.369 -0.063 9.369 -0.262  9.369;
  {bet,f0,g,vc,retcode} = cml(datain,0,&li_baj,x0);
  temp2 =ecostd3(bet,vc);
  save b_a0s0r0 = bet;
  save f0_a0s0r0 = f0;
  save g_a0s0r0  = g;
  save vc_a0s0r0 = vc;
  save retcode_a0s0r0 = retcode;
  se_a0s0r0 = sqrt(diag(vc));
  save se_a0s0r0;
  tval_a0s0r0 =bet./sqrt(diag(vc));
  save tval_a0s0r0;
  /* Estimation Probability of informed trade */
  a0s0r0 = temp2[.,1]~sqrt(temp2[.,2])~temp1[.,1]./sqrt(temp2[.,2])~(ones(rows(temp2),1).*f0*days);
  save a0s0r0;


 /* Estimation with fully restricted parameters */

  let EKOP_R = 1; 
  let x0 = -0.063 10.435 -0.262 9.369;
  {bet,f0,g,vc,retcode} = cml(datain,0,&li_baj,x0);
  temp3=ecostd3(bet,vc);
  save b_a0s0r1  = bet;
  save f0_a0s0r1 = f0;
  save g_a0s0r1  = g;
  save vc_a0s0r1 = vc;
  save retcode_a0s0r1 = retcode;
  se_a0s0r1 = sqrt(diag(vc));
  save se_a0s0r1;
  tval_a0s0r1 =bet./sqrt(diag(vc));
  save tval_a0s0r1;
  /* Estimation Probability of informed trade */
  a0s0r1 = temp3[.,1]~sqrt(temp3[.,2])~temp3[.,1]./sqrt(temp3[.,2])~(ones(rows(temp3),1).*f0*days);
  save a0s0r1;



/* Anettes Likelihood-Ratio Test Section */

loadm f0_a0s0r0;
loadm f0_a0s0r1;
loadm f0_a0s0r2;      
La0r0 = cases*f0_a0s0r0;
La0r1 = cases*f0_a0s0r1;
La0r2 = cases*f0_a0s0r2;

Da0r0r1 = 2*(La0r0-La0r1);
Da0r0r2 = 2*(La0r0-La0r2);
Da0r2r1 = 2*(La0r2-La0r1);

Pa0r0r1 = cdfchic(2*(La0r0-La0r1),4);
Pa0r0r2 = cdfchic(2*(La0r0-La0r2),2);
Pa0r2r1 = cdfchic(2*(La0r2-La0r1),2);

Chisq0 =  Da0r0r1|Da0r0r2|Da0r2r1;
pValue0 = Pa0r0r1|Pa0r0r2|Pa0r2r1;
let df0 = 4 2 2;
Chi_a0s0= Chisq0~df0~pValue0; 
save Chi_a0s0; 


/* Collect results in one table */

ags0rg = a0s0r0~a0s0r1~a0s0r2~a1s0r0~a1s0r1~a1s0r2~a5s0r0~a5s0r1~a5s0r2;


 let Head = par_a0r0 se_a0r0 tvl_a0r0 Log_a0r0 par_a0r1 se_a0r1 tvl_a0r1 Log_a0r1 
            par_a0r2 se_a0r2 tvl_a0r2 Log_a0r2 par_a1r0 se_a1r0 tvl_a1r0 Log_a1r0 
			par_a1r1 se_a1r1 tvl_a1r1 Log_a1r1 par_a1r2 se_a1r2 tvl_a1r2 Log_a1r2
			par_a5r0 se_a5r0 tvl_a5r0 Log_a5r0 par_a5r1 se_a5r1 tvl_a5r1 Log_a5r1
			par_a5r2 se_a5r2 tvl_a5r2 Log_a5r2; 
 outnam = "ags0rg";
 create out = ^outnam with ^head,0,8;
 xx = writer(out,ags0rg);
 out = close(out);

/* Collect likelihood ratio table */

LRTG = Chi_a0s0~Chi_a1s0~Chi_a5s0;

let Head = Chi_a0s0 df_a0s0 pV_a0s0 Chi_a1s0 df_a1s0 pV_a1s0 Chi_a5s0 df_a5s0 pV_a5s0;
outnam = "LRTG";
create out = ^outnam with ^head,0,8;
xx = writer(out,LRTG);
out = close(out);






