/* 
   GAUSS sources for 
   Grammig Schiereck and Theissen
   Knowing me, Knowing you Journal of Financial Markets, 
Knowing Me, Knowing You: 
Trader Anonymity and Informed Trading in Parallel Markets,
Journal of Financial Markets, Vol. 4, 2001, 385 - 412 .
Free Code, but cite source
Joachim Grammig, Tuebingen, NOvember 2008

*/


library  cml;               
#include cml.ext;              
cmlset;                      

 /* datain is to be defined in major program */

 
/* Help Programs */

proc e_alph(alpha);
 local e_alpha;              
 e_alpha   = exp(alpha)/(1+exp(alpha));
 retp(e_alpha);
endp;

proc e_delt(delta);
 local e_delta;
 e_delta   = exp(delta)/(1+exp(delta));
 retp(e_delta);
endp;
   
proc e_epsilo(epsilon);
 local e_epsilon;
    e_epsilon =  epsilon/60;
 retp(e_epsilon);
 endp;

proc e_m(my);
 local e_my;
    e_my =  my/60;
 retp(e_my);
 endp;

proc pin(beta);
/*compute probability of informed trade */
 local alpha,epsilon,delta,my,e_alpha,e_delta,e_epsilon,e_my,pinf;
    alpha   = Beta[1];                  
    epsilon = Beta[2]; 
    delta   = Beta[3];
    my      = beta[4];
    e_alpha   = exp(alpha)/(1+exp(alpha));
    e_delta   = exp(delta)/(1+exp(delta));
    e_epsilon =  epsilon/60;
    e_my      =   my/60;
    pinf=(e_alpha * e_my)/(e_alpha*e_my+2*e_epsilon);
 retp(pinf);
endp;
 
 proc ecostd2(beta,vcmat);
 /* Compute standard errors for economic variables */
    local ecostd2, e_alpha, e_delta, pinf, alpha, epsilon, delta, my, 
                  e_epsilon, e_my, de_aldalp, de_deddel, de_epdeps,
                  de_mydmy, dpidalph, dpidesil, dpiddelt, dpidmy,
                  dpi, vartheta, var_alph, var_epsi, var_delt, var_my,
                  var_pi,eco,econ;

    /*global: security */

    alpha   = Beta[1];                  
    epsilon = Beta[2]; 
    delta   = Beta[3];
    my      = beta[4];
    e_alpha   = exp(alpha)/(1+exp(alpha));
    e_delta   = exp(delta)/(1+exp(delta));
    e_epsilon =  epsilon/60;
    e_my      =   my/60;

    pinf=(e_alpha * e_my)/(e_alpha*e_my+2*e_epsilon);

  "Economic Parameters";
   econ= e_alpha|e_epsilon|e_delta|e_my|pinf;

   de_aldalp = gradp(&e_alph,alpha);
   de_epdeps = gradp(&e_epsilo,epsilon);
   de_deddel = gradp(&e_delt,delta);
   de_mydmy  = gradp(&e_m,my);
   dpi         =gradp(&pin,beta);
     
   vartheta = diag(vcmat);
  
   var_alph = de_aldalp*vartheta[1]*de_aldalp;
   var_epsi = de_epdeps*vartheta[2]*de_epdeps;
   var_delt = de_deddel*vartheta[3]*de_deddel;

   var_my   = de_mydmy*vartheta[4]*de_mydmy;
   var_pi   = dpi*vcmat*dpi';
   eco      = econ~(var_alph|var_epsi|var_delt|var_my|var_pi);
   retp(eco);
   endp;

PROC LI_BAJ(Beta,dta);

/* Likelihood function for joint estimation of two paralell trading processes
   it is possible to restrict the parameters alpha and delta to be the
   same in both processes
   The global EKOP_R == 1 sets the restrictions active: alpha and beta are
   restricted to be equal
   EKOP_R == 2 sets alpha and delta equal

Comments:
=========
dta is just a dummy, the true dataset is a global variable  
Globals:
========
Days:	Number of trading days
FS:	Vector containing sells in S-system
SS:	Vector containing sells in F-system
FB:	Vector containing buys in F-system	
SB:   Vector containing buys in S-system
*/

 LOCAL falpha, salpha, fepsilon, flepsilo, sepsilon, slepsilo, fdelta, sdelta, fmy, flmy, smy, slmy, buyter1,
       sellter1, buyter2, sellter2, i, sells, buys,sellbuf1, sellbuf2, buybuf1, buybuf2, 
       fbuybuf1, fbuybuf2, sbuybuf1, sbuybuf2, fselbuf1, fselbuf2, sselbuf1, sselbuf2, fsum1, fsum2,
       fselter1, fselter2, fbuyter1, fbuyter2, sselter1, sselter2, sbuyter1, sbuyter2,
       fsum3, ssum1, ssum2, ssum3, fepster1, fepster2, sepster1, sepster2, likeli,
       lepsilo,lmy,lalpha,ldelta, fldelta, sldelta, flalpha, slalpha ;

if EKOP_R == 1; /* All Coefficients are forced equal */
  Falpha   = Beta[1];                  
  Fepsilon = Beta[2]; 
  Flepsilo = Fepsilon;
  Fdelta   = Beta[3];
  Fmy      = beta[4];
  Flmy     = Fmy;

  Salpha   = Falpha;
  Sepsilon = Fepsilon;
  Slepsilo = Flepsilo;
  SDelta   = FDelta;
  Smy      = FMy;
  Slmy     = SMy;
  
endif;

if EKOP_R == 0; /* Fully unrestricted */
  Falpha   = Beta[1];                  
  Fepsilon = Beta[2]; 
  Flepsilo = Fepsilon;
  Fdelta   = Beta[3];
  Fmy      = beta[4];
  Flmy     = Fmy;

  Salpha   = Beta[5];                  
  Sepsilon = Beta[6]; 
  Slepsilo = Sepsilon;
  Sdelta   = Beta[7];
  Smy      = beta[8];
  Slmy     = Smy;
 
endif;

if EKOP_R == 2; /* Probs restricted */
  Falpha   = Beta[1];                  
  Fepsilon = Beta[2]; 
  Flepsilo = Fepsilon;
  Fdelta   = Beta[3];
  Fmy      = beta[4];
  Flmy     = Fmy;

  Salpha   = Falpha;                  
  Sepsilon = Beta[5]; 
  Slepsilo = Sepsilon;
  Sdelta   = Fdelta;
  Smy      = beta[6];
  Slmy     = Smy;
 
endif;

  
/*  T       = beta[5];*/

  /* T = ???  maybe a parameter later!*/

  
  buyter1  = zeros(days,1);
  sellter1 = zeros(days,1);
  buyter2  = zeros(days,1);
  sellter2 = zeros(days,1);


  sbuyter1= zeros(days,1);
  sbuyter2= zeros(days,1);
  fbuyter1= zeros(days,1);
  fbuyter2= zeros(days,1);
  sselter1= zeros(days,1);
  sselter2= zeros(days,1);
  fselter1= zeros(days,1); 
  fselter2= zeros(days,1);

  i= 1;

 DO WHILE (i<=days); 

/* floor */

  sells = 1;
  sellbuf1 = 1;
  buybuf1 = 1;
  sellbuf2 = 1;
  buybuf2 = 1;

  DO WHILE sells <= FS[i];
   sellbuf1 = sellbuf1 * flepsilo*T/sells;
   sellbuf2 = sellbuf2 * (((flmy + flepsilo) * T)/sells);      
   sells = sells+1;
  ENDO;

  fselbuf1=sellbuf1;
  fselbuf2=sellbuf2;

/* electronic */
/* Re-initialize */

  sells = 1;
  sellbuf1 = 1;
  sellbuf2 = 1;
  
 DO WHILE sells <= SS[i];
   sellbuf1 = sellbuf1 * slepsilo*T/sells;
   sellbuf2 = sellbuf2 * (((slmy + slepsilo) * T)/sells);      
   sells = sells+1;
  ENDO;
 
 sselbuf1=sellbuf1;
 sselbuf2=sellbuf2;

/*
  sellter1[i] = sellbuf1;
  sellter2[i] = sellbuf2;
*/

  fselter1[i]=fselbuf1;
  fselter2[i]=fselbuf2;

  sselter1[i]=sselbuf1;
  sselter2[i]=sselbuf2;


  buys = 1;
   DO WHILE buys  <= FB[i];
    buybuf1 = buybuf1 * (Flepsilo*T)/buys;
    buybuf2 = buybuf2 * ((Flmy+Flepsilo)*T)/buys;
    buys = buys+1;
   ENDO;

  fbuybuf1   = buybuf1;
  fbuybuf2   = buybuf2;
  fbuyter1[i] = fbuybuf1;
  fbuyter2[i] = fbuybuf2;

  buybuf1 = 1;
  buybuf2 = 1;

  buys = 1;
   DO WHILE buys  <= SB[i];
    buybuf1 = buybuf1 * (Slepsilo*T)/buys;
    buybuf2 = buybuf2 * ((Slmy+Slepsilo)*T)/buys;
    buys = buys+1;
   ENDO;

  sbuybuf1 =   buybuf1;
  sbuybuf2 =   buybuf2;

  sbuyter1[i] = sbuybuf1;
  sbuyter2[i] = sbuybuf2;

  i = i+1;
ENDO;

 /*epster1=exp(-1*lepsilo*T);
   epster2=exp(-1*(lepsilo+lmy)*T);
 */

  fepster1=exp(-1*flepsilo*T);
  sepster1=exp(-1*slepsilo*T);
 
  fepster2=exp(-1*(flepsilo+flmy)*T);
  sepster2=exp(-1*(slepsilo+slmy)*T);
 
/*
 buyter1~buyter2~sellter1~sellter2;
 epster1~epster2;
*/

/*
 lalpha = exp(alpha)/(1+exp(alpha));
 ldelta = exp(delta)/(1+exp(delta));
*/

 flalpha = exp(falpha)/(1+exp(falpha));
 fldelta = exp(fdelta)/(1+exp(fdelta));

 slalpha = exp(salpha)/(1+exp(salpha));
 sldelta = exp(sdelta)/(1+exp(sdelta));


/*
 sum1=(1-lalpha)*epster1.*buyter1*epster1.*sellter1;
 sum2=(lalpha*ldelta)*epster1.*buyter1*epster2.*sellter2;
 sum3=lalpha*(1-ldelta)*epster2.*buyter2.*epster1.*sellter1;
*/

 fsum1=(1-flalpha)*fepster1.*fbuyter1*fepster1.*fselter1;
 fsum2=(flalpha*fldelta)*fepster1.*fbuyter1*fepster2.*fselter2;
 fsum3=flalpha*(1-fldelta)*fepster2.*fbuyter2.*fepster1.*fselter1;

 ssum1=(1-slalpha)*sepster1.*Sbuyter1*Sepster1.*Sselter1;
 ssum2=(Slalpha*Sldelta)*Sepster1.*Sbuyter1*Sepster2.*Sselter2;
 ssum3=Slalpha*(1-Sldelta)*Sepster2.*Sbuyter2.*Sepster1.*Sselter1;

  likeli = ln(Fsum1+Fsum2+Fsum3)+ln(Ssum1+Ssum2+Ssum3); 

/*"LogL";;sumc(likeli);*/


RETP(likeli);

ENDP;

proc ecostd3(beta,vcmat);
 /* Compute standard errors for economic variables
    joint model
 */
    local  fe_alhpa, e_delta, pinf, falpha, salpha, sepsilon, fepsilon, sdelta,fdelta,
                  smy,fmy, fe_alpha, fe_delta, se_alpha, se_delta,
                  fe_epsilon, se_epsilon, se_my,fe_my, fde_aldalp, sde_aldalp, fde_deddel,sde_deddel,
                 fde_epdeps,sde_epdeps, fde_mydmy,sde_mydmy,fdpidalph, sdpidalph, fdpidesil, sdpidesil,
                 fdpiddelt, sdpiddelt, spidmy, fdpidmy,spinf, fpinf,fdpi, sdpi, vartheta, var_salph, 
                 var_falph, var_sepsi, var_fepsi, var_fdelt, var_sdelt, 
            var_smy, var_fmy,var_fpi, var_spi, seco, feco, econ, sbeta, fbeta, fecon, secon, eco;

 /* global: security ekop_r */

if EKOP_R == 1; /* All Coefficients are forced equal */
  Falpha   = Beta[1];                  
  Fepsilon = Beta[2]; 
/*  Flepsilo = Fepsilon;*/
  Fdelta   = Beta[3];
  Fmy      = beta[4];
/*  Flmy     = Fmy;*/

  Salpha   = Falpha;
  Sepsilon = Fepsilon;
/*  Slepsilo = Flepsilo;*/
  SDelta   = FDelta;
  Smy      = FMy;
/*  Slmy     = SMy;*/
  
endif;

if EKOP_R == 0; /* Fully unrestricted */
  Falpha   = Beta[1];                  
  Fepsilon = Beta[2]; 
/*  Flepsilo = Fepsilon;*/
  Fdelta   = Beta[3];
  Fmy      = beta[4];
/*  Flmy     = Fmy;*/

  Salpha   = Beta[5];                  
  Sepsilon = Beta[6]; 
  /*Slepsilo = Sepsilon;*/
  Sdelta   = Beta[7];
  Smy      = beta[8];
/*  Slmy     = Smy;*/
 
endif;

if EKOP_R == 2; /* Probs restricted */
  Falpha   = Beta[1];                  
  Fepsilon = Beta[2]; 
/*  Flepsilo = Fepsilon;*/
  Fdelta   = Beta[3];
  Fmy      = beta[4];
/*  Flmy     = Fmy;*/

  Salpha   = Falpha;                  
  Sepsilon = Beta[5]; 
/*  Slepsilo = Sepsilon;*/
  Sdelta   = Fdelta;
  Smy      = beta[6];
/*  Slmy     = Smy;*/
 
endif;

    Sbeta =  salpha|sepsilon|sdelta|smy;
    Fbeta =  falpha|fepsilon|fdelta|fmy;

    Fe_alpha   =   exp(Falpha)/(1+exp(Falpha));
    Fe_delta   =   exp(Fdelta)/(1+exp(Fdelta));
    fe_epsilon =   e_epsilo(fepsilon);
    fe_my      =   e_m(fmy);

    Se_alpha   =   exp(salpha)/(1+exp(salpha));
    Se_delta   =   exp(sdelta)/(1+exp(sdelta));
    Se_epsilon =   e_epsilo(sepsilon);
    Se_my      =   e_m(smy);

    Fpinf=(Fe_alpha * Fe_my)/(Fe_alpha*Fe_my+2*Fe_epsilon);
    spinf=(se_alpha * se_my)/(se_alpha*se_my+2*se_epsilon);

  "Economic Parameters";
   Fecon= Fe_alpha|Fe_epsilon|Fe_delta|Fe_my|Fpinf;
   secon= se_alpha|se_epsilon|se_delta|se_my|spinf;

   Econ = FEcon|SEcon;

   Fde_aldalp = gradp(&e_alph,Falpha);
   Fde_epdeps = gradp(&e_epsilo,Fepsilon);
   Fde_deddel = gradp(&e_delt,Fdelta);
   Fde_mydmy  = gradp(&e_m,Fmy);
   Fdpi       = gradp(&pin,Fbeta);
   sde_aldalp = gradp(&e_alph,salpha);
   sde_epdeps = gradp(&e_epsilo,sepsilon);
   sde_deddel = gradp(&e_delt,sdelta);
   sde_mydmy  = gradp(&e_m,smy);
   sdpi       = gradp(&pin,sbeta);
     
   vartheta = diag(vcmat);


/* Holds true for all models */

   var_Falph = Fde_aldalp*vartheta[1]*Fde_aldalp;
   var_Fepsi = Fde_epdeps*vartheta[2]*Fde_epdeps;
   var_Fdelt = Fde_deddel*vartheta[3]*Fde_deddel;
   var_Fmy   = Fde_mydmy*vartheta[4]*Fde_mydmy;


 if EKOP_R == 1; /* All Coefficients are forced equal */ 

   var_salph = Sde_aldalp*vartheta[1]*Sde_aldalp;
   var_sepsi = Sde_epdeps*vartheta[2]*Sde_epdeps;
   var_sdelt = Sde_deddel*vartheta[3]*Sde_deddel;
   var_smy   = Sde_mydmy*vartheta[4]*Sde_mydmy;

   var_Spi   = sdpi*vcmat*sdpi';
   var_fpi   = fdpi*vcmat*fdpi';

 endif;

if EKOP_R == 0; /* No restrictions on the coefficients: VC Matrix is block-Diagonal */ 

   var_salph = Sde_aldalp*vartheta[5]*Sde_aldalp;
   var_sepsi = Sde_epdeps*vartheta[6]*Sde_epdeps;
   var_sdelt = Sde_deddel*vartheta[7]*Sde_deddel;
   var_smy   = Sde_mydmy*vartheta[8]*Sde_mydmy;

/* Block diagonal VC when independent */

   var_fpi   = fdpi*vcmat[1:4,1:4]*fdpi';
   var_spi   = sdpi*vcmat[5:8,5:8]*sdpi';

  endif;

if EKOP_R == 2; /* Restrictions on alpha and delta:*/ 

   var_salph = Sde_aldalp*vartheta[1]*Sde_aldalp;
   var_sepsi = Sde_epdeps*vartheta[5]*Sde_epdeps;
   var_sdelt = Sde_deddel*vartheta[2]*Sde_deddel;
   var_smy   = Sde_mydmy*vartheta[6]*Sde_mydmy;
/* special stacking floor comes first then the rates for screen */

   var_fpi   = (fdpi~zeros(1,2))*vcmat*(fdpi'|zeros(2,1));
   var_spi   = (sdpi[1]~0~sdpi[3]~0~sdpi[2]~sdpi[4])*vcmat*(sdpi[1]~0~sdpi[3]~0~sdpi[2]~sdpi[4])';

  endif;
 

/* Holds again true for all models */

   Seco      = Secon~(var_salph|var_sepsi|var_sdelt|var_smy|var_spi);
   Feco      = fecon~(var_falph|var_fepsi|var_fdelt|var_fmy|var_fpi);
   Eco = Feco|Seco;

   retp(eco);
   endp;

proc ineqp(beta);

local spinf, Fpinf, Flmy, Fmy, Falpha, Fepsilon, Flepsilo, Fdelta, 
      Salpha, Sepsilon,Sdelta, Slepsilo, Smy, Slmy, Fe_alpha, Fe_delta,
      Fe_epsilon, Fe_my, Se_alpha, Se_delta, Se_epsilon, Se_my;

  Falpha   = Beta[1];                  
  Fepsilon = Beta[2]; 
  Flepsilo = Fepsilon;
  Fdelta   = Beta[3];
  Fmy      = beta[4];
  Flmy     = Fmy;

  Salpha   = Falpha;                  
  Sepsilon = Beta[5]; 
  Slepsilo = Sepsilon;
  Sdelta   = Fdelta;
  Smy      = beta[6];
  Slmy     = Smy;

    Fe_alpha   =   exp(Falpha)/(1+exp(Falpha));
    Fe_delta   =   exp(Fdelta)/(1+exp(Fdelta));
    fe_epsilon =   e_epsilo(fepsilon);
    fe_my      =   e_m(flmy);

    Se_alpha   =   exp(salpha)/(1+exp(salpha));
    Se_delta   =   exp(sdelta)/(1+exp(sdelta));
    Se_epsilon =   e_epsilo(sepsilon);
    Se_my      =   e_m(slmy);

    Fpinf=(Fe_alpha * Fe_my)/(Fe_alpha*Fe_my+2*Fe_epsilon);
    spinf=(se_alpha * se_my)/(se_alpha*se_my+2*se_epsilon);

   /*retp(((-abs(Fepsilon/Sepsilon-Fmy/Smy)))+1e-5);*/
   retp( -( ( ( (Fepsilon/Sepsilon-Fmy/Smy)  ) )^2)+1e-5); /* New version not abs */

endp;
