function [ alphas, betas_mat, lambda ] = get_alpha_beta_lambda( param, analysis, excess_returns,factors, c_fac )
% This function takes the N*K vector param and separates it into the
% alphas, betas and lambdas for analysis 2 and 7

N=size(excess_returns,2);
K=size(factors,2);

if analysis==2
    
    % first N params are the alphas, then come the betas, then the lambdas
    alphas=param(1:N);
    
    % betas come in a N*K column vector with the first K values to test
    % asset one, the next K to the second test asset and so on
    betas=param(N+1:N*(K+1));
    
    % The N*K vector is reshaped as an KxN matrix: the first column has
    % then the betas for the first asset, and so forth
    % the first row holds the beta values belonging to the first factor,
    % the second row for the second factor and so on: this is the lower
    % right corner of the a_T matrix
    betas_mat=reshape(betas,[K,N])';
    
    % now the lambdas
    lambda=param(N*(K+1)+1:size(param,1));

elseif analysis==7
    
    % first N params are the alphas, then come the betas, then the lambdas
    alphas=param(1:N);
    
    % betas come in a N*K column vector with the first K values to test
    % asset one, the next K to the second test asset and so on
    betas=param(N+1:N*(c_fac+1));
    
    % The N*K vector is reshaped as an KxN matrix: the first column has
    % then the betas for the first asset, and so forth
    % the first row holds the beta values belonging to the first factor,
    % the second row for the second factor and so on: this is the lower
    % right corner of the a_T matrix
    betas_mat=reshape(betas,[c_fac,N])';
    
    % now the lambdas
    lambda=param(N*(c_fac+1)+1:N*(c_fac+1)+c_fac);
       
end

end

