function [ u_T ] = get_u_T( param, analysis, excess_returns, factors, factor_type, c_fac, mim_proj_var, mim_base_assets )
% gives the residuals over which g_T takes means.

N=size(excess_returns,2);
K=size(factors,2);
T=size(excess_returns,1);

if analysis==2          % two-pass regression
    
    % first N params are the alphas, then come the betas, then the lambdas
    alphas=param(1:N);
    
    % betas come in a N*K column vector with the first K values to test
    % asset one, the next K to the second test asset and so on
    betas=param(N+1:N*(K+1));
    
    % The N*K vector is reshaped as an KxN matrix: the first column has
    % then the betas for the first asset, and so forth
    % the first row holds the beta values belonging to the first factor,
    % the second row for the second factor and so on: this is the lower
    % right corner of the a_T matrix
    betas_mat=reshape(betas,[K,N])';
    
    % now the lambdas
    lambda=param(N*(K+1)+1:size(param,1));
    
    % time series residuals (for time series and cross-sectional
    % regressions)
    residuals=excess_returns-repmat(alphas',[T,1])-factors*betas_mat';
    
    u_T_1=residuals;            % OLS residuals must be zero
    u_T_2=ones(T,N*K);
    
    i=0;
    while i <= K-1
        u_T_2(:,i*N+1:N*(i+1))=residuals.*repmat(factors(:,i+1),[1 size(residuals,2)]);
                                % orthogonality of residuals with factors
        i=i+1;                             
    end
    
    if factor_type==1
        u_T_3=factors-repmat(lambda',[size(factors,1) 1]);   % moment condition for lambda if the 
                                % factors are excess returns
                               
    elseif factor_type==2       % factors are NOT excess returns:
                                % two-pass-regression
        u_T_3=excess_returns-repmat((betas_mat*lambda)',[T 1]);
                                % these "cross-sectional" residuals have to
                                % be orthogonal to the betas (--> a_T)
    end
    
elseif analysis==7      % three-pass regression with mimicking portfolios
    
    % first N params are the alphas, then come the betas, then the lambdas
    alphas=param(1:N);
    
    % betas come in a N*K column vector with the first K values to test
    % asset one, the next K to the second test asset and so on
    betas=param(N+1:N*(c_fac+1));
    
    % The N*K vector is reshaped as an KxN matrix: the first column has
    % then the betas for the first asset, and so forth
    % the first row holds the beta values belonging to the first factor,
    % the second row for the second factor and so on: this is the lower
    % right corner of the a_T matrix
    betas_mat=reshape(betas,[c_fac,N])';
    
    % now the lambdas
    lambda=param(N*(c_fac+1)+1:N*(c_fac+1)+c_fac);
    
    % now the time series lambdas
    lambda_ts=param(N*(c_fac+1)+c_fac+1:N*(c_fac+1)+2*c_fac);
    
    mim_const=param(N*(c_fac+1)+2*c_fac+1:N*(c_fac+1)+2*c_fac+size(mim_proj_var,2));
    % last mim_par
    mim_par=param(N*(c_fac+1)+2*c_fac+size(mim_proj_var,2)+1:N*(c_fac+1)+2*c_fac+size(mim_proj_var,2)+size(mim_base_assets,2));
    
    % time series residuals (for time series and cross-sectional regression
    residuals=excess_returns-repmat(alphas',[T,1])-[factors,mim_base_assets*mim_par]*betas_mat';
    
    u_T_1=residuals;            % OLS residuals of the time series 
                                % regression must be zero
    
    factors_new=[factors,mim_base_assets*mim_par];     
                                % new factors matrix
    
    u_T_2=ones(T,N*c_fac);
    
    i=0;
    while i <= c_fac-1
        u_T_2(:,i*N+1:N*(i+1))=residuals.*repmat(factors_new(:,i+1),[1,size(residuals,2)]);
                                % orthogonality of ts residuals with factors
        i=i+1;                             
    end    
        % these "cross sectional residuals" have to be orthogonal to the
        % betas (--> a_T)
    
    u_T_3a=excess_returns-repmat((betas_mat*lambda)',[T,1]);    
                                % AP moments (last in u_T_3)
    u_T_3b=factors_new-ones(size(factors_new,1),1)*lambda_ts';
                                % factor means time series estimates
    u_T_3c=mim_proj_var-mim_const-mim_base_assets*mim_par;
                                % residuals mimicking portfolio
    u_T_3d=repmat(u_T_3c,[1,size(mim_base_assets,2)]).*mim_base_assets;
                                % orthogonality mpf
     
    u_T_3=[u_T_3b,u_T_3c,u_T_3d,u_T_3a];                            
end

u_T=[u_T_1,u_T_2,u_T_3];        % collect the u_Ts
end

