
/************************************************************************
 This Gauss program controls forecasting with ACH, ACM, OP model 
************************************************************************/


library pgraph;
graphset; 

format 16,8;
/* read in the data */
#include readdatb4.prg;   @ reads in data  @


/*****************************start of settings ********************************/

#define kk_lin; /* path definitions */

#ifdef kk_lin;
fide = "/";
lp =fide$+"home/kehrleke/share/gk2005/homepage"$+fide$+"results_myacm"$+fide;
svp=fide$+"home/kehrleke/share/gk2005/homepage"$+fide$+"results_fore"$+fide;
svp_seed="/home/kehrleke/gauss/seed_check/" ;
#endif; 

_option_density = 0; /* 1 for yes writing the density 0 for not writing the density */
                     /* be carefult depending on the simulation number this can get large */

declare icontrol = 2; /* either 1 for prob. forecast evaluation  */
                       /*  or 2 needed for mse  */
/* set a seed */
declare _randomgenerator = "kiss";  /* "kiss"  or  "rnd" */
first_seed =  9137841;

hor = 60;      @ 60   number of forecasted horizons     @ 
nmonte =400;  @ 400       @       @ nmonte is the number of simulations per observation @
z_monte =1;   @ 100       @
models = 1 | 3;
ti =capt;  /* capt */       @ t1-hor 896@    


/* options are saved since they are needed for the forecast evaluation */
options = hor | nmonte | ti | z_monte;
save path = ^svp options_monte = options;

/*****************************End of settings ********************************/
x = date; v = time;
"---------------------------------------------------------------------";
"date: ";;x[3];;".";;x[2];;".";;x[1];;"time: ";;v[1];;":";;v[2];
"__________________________________________________";
"___OPTIONs________________________________________";
"__________________________________________________";
"_______________randomgenerator = ";; $_randomgenerator;
"__________________________seed = ";; first_seed;
"_______________________horizon = ";; hor;
"_____________nmonte (forecast) = ";; nmonte;
"_________z_monte  (evaluation) = ";; z_monte;
"_observation used for forecast = ";; ti;
"save path for forecast results";$svp;
/*"lower obs. used for evaluation = ";; boundaries[1];
"____higher obs. used for eval. = ";; boundaries[2];*/
"icontrol"; icontrol;
if icontrol == 1;
icon = "i1";"forecasts based on actual historical values";
else;
icon = "i2";
    "forecasts restricted so that i(t) = i(m(t)) for m(t) the date of the last week";
    "of the previous month";
endif;
"__________________________________________________";
"__________________________________________________";

/* initialize some values needed in the forecast procedures */
delprob = 0;
cvec = 0;
hori=0;
noGraphics = 0;
A = 0; B= 0; ct = 0; D1 = 0; D2 = 0;
nc = {}; na ={}; nb = {}; case = {}; nd ={};

/*  some settings */
tbreak = 301;

kbreak = 1;    @ kbreak = 0 means no break, kbreak = 1 means break @
kshort = 0;    @ use kshort = 0 and kbreak = 1 for full data set,
             kshort = 1 and kbreak = 0 for short debugging @

dellit =    0.1;              @ dellit is smoothness parameter for transition between m(z) = 0 and
                                    m(z) = z @
delsmall = 0.0001;      @ delsmall is the value of el(0) in equation (13) @

lastmonth = lagtar;

    @ Output file created by lagtar.prg.  First row = 3/1/84, last row = 4/26/01.  Weekly data.  
    col 1 = Friday following the Thurs-Wed week corresponding to row t
    col 2 = fed funds target during week t
    col 3 = Friday following the Thurs-Wed week that was the last week during the
                    previous month prior to row t
    col 4 = fed funds target during week indicated in col. 3 @
lastmonth = lastmonth[.,4];


/*******************************************************************************************

            ESTIMATE VAR FOR AUXILIARY VARIABLES

********************************************************************************************/

xs = spread6[1:oldcapt,.];  
nlast =  oldcapt;                   @ last observation used to estimate VAR @
plag = 1;   @ order of auxiliary VAR; note code is not written for general case of plag > 1
            in many spots @
nfirst = plag+1;           @ first observation used to estimate VAR @
b0 = 0; ny = 0; phi = 0;         @ needed to load proc; not used in this code @
#include varproc2.prg;
xvar = multlags(target[1:nlast,1] ~ xs[1:nlast,.],plag,nfirst);
xvar = target[nfirst:nlast,1] ~ xvar; 
     @adds contemporaneous target as first explanatory variable @
{bhat,vhat,ehat} = varit(xs[nfirst:nlast,.],xvar);    @ estimates regression
            if ns = cols(xs is number of explanatory variables (not counting target),
            then bhat is (ns x 2+plag*(ns+1)) matrix, whose ith row is coefficients
            to predict ith variable, first column is coefficient on current target,
            second column is coefficient on constant term, cols 3 through 3+plag-1
            are coefficients on lags 1 through plag of target, cols 3+plag through 
            3+2*plag-1 are coefficients on lags 1 through plag of first element of xs @
           
"var coefficients";
vroot = chol(vhat);
var_bhat=(meanc((ehat-meanc(ehat))^2))*inv(xvar'*xvar);
"standard errors"; se=diag(sqrt(var_bhat));
/* format /rd 3,3; 
 bhat|se';
"for equation 20 : "stop;*/
 /* lhs: spread ordering rhs: target ~constant ~ targetlag ~spread_lag */
/*******************************************************************************************
    
            SET UP ACH MODEL WITH PARAMETERS 

*******************************************************************************************/

zach = ones(capt,1) ~ lagfomc ~ fomc ~ abs(spread6);
    @ note this is matrix that contains all the variables used in either subsample @
/* these are the parameter estimates of hamilton and jorda */
/* these are the parameter estimates that are reported in the paper */
del1 = 1.2574394    |   -2.0438131 | 0 | 0;
del2 =        29.390652   | 0 |   -23.045727   |    -8.2087573 ;
thet1 = 0.089877909  ;  
bet1 =     0.84665258;
thet2 = 0.067460919 ;
bet2 = 0;

meandur1 = meanc(duration[1:tbreak-1,1]);

if kshort == 0;
    t1 = oldcapt;
    meandur2 = meanc(duration[tbreak:t1,1]);   
else;
    t1 = 30;
    meandur2 = 0;   @ to keep code from tripping when loading proc @
endif;

/*******************************************************************************************
    
            SET UP ACM MODEL WITH PARAMETERS 

******************************************************************************************  */ 


index = models[1]; 

do until index gt models[2]; 
dseed = first_seed;
mode = index;

if     index ==1;mod_name = "mod2";
elseif index ==2;mod_name = "mod9";
elseif index ==3;mod_name = "opm";
else;
"hey do sth.!! ";
endif;

mod_name;

#include myacm_forepro4.src;

/* some settings for the parameters */

if mod_name $== "opm";
        A = zeros(num_k-1,num_k-1);
        B = A;
        D1 = zeros(num_k-1,1);
        D2 = D1;
        ct = D1;
        @	create probit explanatory variables  @
        event[1,1] =0;
	
	if num_k == 5;
	#include probseek_par5.prg;
	thprob = probseek_par';
        delprob = thprob[1:2,1];
        cvec = thprob[3:6,1];
        else; stop; endif;
elseif  mod_name $== "modunc";
        A = zeros(num_k-1,num_k-1);
        B = A;
        D1 = zeros(num_k-1,1);
        D2 = D1;
        ct = h_init;
else;
             {ct, A, B, D1, D2} =load_prc3(mod_name);
endif;
/*  this part is only done when there is an Acm forecast */ 

	{pie_event,h_event}= acm_hist(A,B,ct,D1,D2,lagx_fore); 
	datex_event = eventdata_fore[.,3];
			/* pie_event; rows(pie_event); 
			datex_event; rows(datex_event); */
			/* create a pie vector for time t */
	pie_lhs = zeros(capt,num_k-1);
	i = 1;
	ac = 1;
	do until i > capt; 
			/* if there is no change in the target */
		if i < datex_event[ac,.];
		pie_lhs[i,.] = pie_event[ac,.]; 
		/* else there is a change in the target -> take new value for pie */
		elseif i ge datex_event[rows(datex_event),.];
		pie_lhs[i,.] = pie_event[rows(pie_event),.]; 
		else;
		ac = ac+1;
		pie_lhs[i,.] = pie_event[ac,.]; 
		endif;
	i = i+1;
	endo;

    

target = target | zeros(hor,1);
z_mat = {}; 
num_mat ={};


/* this is for writing out the density orders_rs = {896,500,120};*/
if _option_density == 1;
anz = nmonte*5;
hoi = hor*2; 
orders_rs = ti|anz |hoi;
i_pie_arr = arrayinit(orders_rs,0);
endif;


procstart = 1;
foreall = zeros(capt+hor,hor);

/*tests = seqa(1,1,ti+hor);*/
it = 2; /* this loop goes from it until ti ( including ti!!!!!!)in the initial case of hj and paper from 2 until 896*/ 
do until it > ti;
/*"it";;it;*/
if it == 2;
dseed = first_seed;
else;
loadm path = ^svp_seed dseed = secondseed; 
endif;

    if icontrol == 1;
        ihist = target[1:it,1];
    else;
        ihist = target[1:it,1];
        monthstart = monthcou[it,1];
        monthend = monthcou[it,2];
        ihist[it-monthstart:it,1] = target[it-monthstart,1]*ones(monthstart+1,1);
	endif; 

    i_pie_rs_nmonte =zeros(1,hor*2);
  
    imonte = 1;
    do until imonte > nmonte; /*"it";;it;"imonte"; imonte;*/
 /* i_pie_rs_hor has the same dimensions as i_pie_rs_monte */   
/*"it-horizon";; it;
"first round second dseed";; dseed;*/
		if mod_name $== "opm"; 
			{fores,sims,i_pie_rs_hor} = multiperiod(ihist,hor,procstart);
		else;
			{fores,sims,pies,i_pie_rs_hor} = multiperiod_acm(ihist, hor, procstart, pie_lhs); 
		endif; 

/*"second round second dseed";; dseed;*/
       /* @ "-----------";fridate[it,1];@
        "ifores" fores;
        "isisms" sims;
	    "ipies" pies;
        "";"";""; */
			iz = 1;
			do until iz > hor;
			foreall[(it + iz -1), iz] = foreall[(it + iz -1), iz] + fores[1,iz];
			iz = iz + 1;
			endo;
			/*sumc(sumc(foreall));*/
			
     /*density forecast;*/
     i_pie_rs_nmonte = i_pie_rs_nmonte | i_pie_rs_hor;

     imonte = imonte + 1;
    endo;
/* time point wise = planewise i_pie_arr is filled one plane has the dimension (5*nmonte times hor)
 it goes from the second row, cause of technichal /prgramming reason since we start from 
the second row with the forecast 
NOTE: we start to fill i_pie_arr from the second plane since it = 2 , i.e. the first plane
consists only of zeros as initilized""" */

if icontrol == 1;

if _option_density == 1;
  i_pie_arr[it,.,.] = i_pie_rs_nmonte[2:rows(i_pie_rs_nmonte),.];     
endif;
	i_pie = i_pie_rs_nmonte[2:rows(i_pie_rs_nmonte),.];

	if it == 2;
	dseed = first_seed;
	else;
	loadm path = ^svp_seed dseed = thirdseed;
	endif;
/*"it-horizon";; it;
"first round third dseed";; dseed;*/	
	targ = target[it:it+hor-1,.];
	{zz,number} = produce_zmat(i_pie,targ,mod_name,options,it);
/*"second round third dseed";; dseed;	*/
	z_mat = z_mat | zz; 
	num_mat = num_mat | number; 
endif;

it = it  + 1;
endo;



if icontrol == 1;
	if _option_density == 1;
	name_dens= "i_pie_arr_" $+ mod_name $+ ".fmt";
	save path = ^svp ^name_dens = i_pie_arr;
	endif;
name = "num_mat_"  $+ ".fmt";
save path = ^svp ^name = num_mat;
name = "z_mat_" $+ mod_name $+ ".fmt";
save path = ^svp ^name = z_mat;

endif;


foreall = foreall / nmonte;
tarefores = foreall;

"variance for target changes";;
qz = target[2:capt,1] - target[1:capt-1,1];
meanc(  (qz - meanc(qz))^2  );

"mean squared errors for target";
junny = target[1:capt,1] - foreall[1:capt,.];
junny = junny[hor+1:capt,.];
mse = meanc(junny^2);
mse';
"standard errors";
mse_se = sqrt(mse');

call save_prc_fore(mod_name,icon,tarefores,mse,mse_se);


index = index +1;
endo;
