
/*
  ------------------------------------------------------------------------
  ------------------------------------------------------------------------
    Ekkehart Boehmer, Joachim Grammig and Erik Theissen (2007):

    Estimating the probability of informed tradingdoes trade misclassification matter? 

    Ekkehart Boehmer, Mays Business School, Texas A&M University, College Station, TX 77843-4218, USA
    Joachim Grammig, Department of Economics, University of Tbingen, Mohlstreet 36, 72074 Tbingen, Germany
    Erik Theissen, University of Bonn, BWL I, Adenauerallee 24-42, 53113 Bonn, Germany 

 ------------------------------------------------------------------------
 ------------------------------------------------------------------------
*/


  seed={};ekop_r={};FS={};FB={};SS={};SB={};DAYS={};T={};S={};B={};
  dat = {};

  proc argtest;
  retp(1);
  endp;
  proc integer;
  retp(2);
  endp;
  proc scalar;
  retp(3);
  endp;

  
  library cml, pgraph;
  cmlset;
  graphset;

  #include cml.ext;
  #include bgt2007.src;
  
  format /rd 4,2;

 
/* Read in data */

print "Data read from GAUSS data set: ";

load exampledata = exampledata;
dat = exampledata;


outresult = {};

 j=1;

 /*do while (j<=numstock);*/
 do while (j<=1);
      
    i=1;
    do while (i<=2);

    "i ";;i;;"j ";;j;
        
        /*  TAQ Lee-Ready */
        
        IF i==1;
        
            S = exampledata[.,1];
            B  = exampledata[.,2];
            
        /*  SOD ALL TRUE */
            
        ELSEIF i==2;
        
            S = exampledata[.,3];
            B  = exampledata[.,4];
            
        
        endif;
               
       
            days       = rows(S);
            
            T=6.5;
            
            /* Initialize CML */
            _cml_Algorithm  = 3;        /* 1=BFGS  2=DFP  3=NEWTON  4=BHHH */
            _cml_GradMethod = 1;        /* 0 = central; 1 = forward */
            _cml_linesearch = 3;
            _cml_CovPar=2;              /* VC-Matrix: Inverse Hessian */
            _cml_maxiters=200;
            __row =days;                /* Number of cases per iteration */
            _cml_DirTol=1e-6;
            
            
            /* This is how the parameter vector looks like: alpha=B[1];epsilon=B[2];delta=B[3];mu=b[4]; */
            
            /* Define Starting Values */
            x0 = Zeros(4,1);
            x0[1] = 0;
            x0[2] = ((meanc(B)+meanc(S))/6.5)*0.75/2;
            x0[3] = 0;
            x0[4] = ((meanc(B)+meanc(S))/6.5)*0.25/2;
            

            /* Call CML */
            output off;        
            {bet,f0,g,vc,retcode} = cml(dat,0,&li_ba_stable,x0);
          
            IF retcode ne 0;
            
                _cml_Algorithm  = 4;
                _cml_linesearch = 3;
                _cml_maxiters   = 1000;
                {bet,f0,g,vc,retcode} = cml(dat,0,&li_ba_stable,bet);
                                
                IF retcode ne 0;
            
                _cml_Algorithm  = 4;
		        _cml_linesearch = 1;
                _cml_maxiters = 1000;
                
                {bet,f0,g,vc,retcode} = cml(dat,0,&li_ba_stable,x0);
                
                ENDIF;
                
                IF retcode ne 0;
            
                _cml_Algorithm  = 3;
                _cml_maxiters = 1000;
                
                {bet,f0,g,vc,retcode} = cml(dat,0,&li_ba_stable,bet);
                
                ENDIF;
                
                IF retcode ne 0;
            
                _cml_Algorithm  = 3;
                _cml_maxiters = 10;
                
                {bet,f0,g,vc,retcode} = cml(dat,0,&li_ba_stable,x0);
                
                ENDIF;
                
                IF retcode ne 0;
            
                _cml_Algorithm  = 4;
                _cml_maxiters = 1000;
                
                {bet,f0,g,vc,retcode} = cml(dat,0,&li_ba_stable,bet);
                
                ENDIF;
              
                
            ENDIF;          
             
            IF ismiss(vc) == 1;
            
                out=ecostd_nose(bet); 
                
            ELSE;
            
                out=ecostd2(bet,vc);
                            
            ENDIF;
            outresult=outresult|(i~j~retcode~(out[.,1])'~(out[.,2])')~sumc(b)~sumc(s);
            /* model ~ stock ~ retcode ~ alpha ~ epsilon ~ delta ~ mu ~ PIN ~ SE(alpha) ~ SE(epsilon) ~ SE(delta) ~ SE(mu) 
            ~ SE(PIN) Buys ~ Sells */	       
            save outresult_mat = outresult;

            i=i+1;
    ENDO;
    j=j+1;
ENDO;




