clear
clc
close all
warning('off','MATLAB:table:ModifiedAndSavedVarnames');


% select region (Ischgl or Gangelt)
regn = 'Ischgl';
% select number of days by which deaths should be shifted
death_shift = 19;
% If Germany, decide whether or not to use Nowcasting data
nowcast = 1;
reset_death = 1;


if (nowcast == 0) && (reset_death == 1)
    error('Makes no sense')
end

% load data
data = readtable('Fallzahlen_RKI.csv');% https://www.rki.de/DE/Content/InfAZ/N/Neuartiges_Coronavirus/Daten/Fallzahlen_Kum_Tab.html
data = table2timetable(table(datetime(data.Date_reported,'InputFormat','dd.MM.yyyy'),...
    data.New_cases,data.Cases,data.New_deaths,data.Deaths,'VariableNames',{'Date','New_Cases','Sum_cases','New_deaths','Sum_deaths'}));
data.Properties.DimensionNames{1} = 'Date_reported';
if nowcast == 1
    data2 = readtable('Nowcasting_Zahlen.csv'); % Data taken from here https://www.rki.de/DE/Content/InfAZ/N/Neuartiges_Coronavirus/Projekte_RKI/Nowcasting.html
    data2.Properties.VariableNames{1} = 'Infection_Date';
    data2.Properties.VariableNames{2} = 'New_Cases_nowcast';
    data2 = table2timetable(table(datetime(data2.Infection_Date,'InputFormat','dd.MM.yyyy'),...
        data2.New_Cases_nowcast,'VariableNames',{'Date','New_Cases_nowcast'}));
    data2.Cum_cases_nowcast = cumsum(data2.New_Cases_nowcast);
    dataG = synchronize(data,data2);
    dataG.Cumulative_cases = dataG.Cum_cases_nowcast;
    dataG = dataG(timerange(data2.Date(1),dataG.Date_reported(end)),:);
else 
    dataG.Cumulative_cases = dataG.Sum_cases;
end

if reset_death == 0
    T2 = table2timetable(table(dataG.Date_reported,dataG.Sum_deaths,...
        'VariableNames',{'Date','Deaths'}));
    TT = lag(T2,-death_shift);
    dataG = synchronize(dataG,TT);
    dataG.Cumulative_deaths = dataG.Deaths;
else
    T2 = table2timetable(table(dataG.Date_reported,dataG.New_deaths,...
        'VariableNames',{'Date','Deaths'})); 
    TT = lag(T2,-death_shift); 
    TT.Cum_deaths = cumsum(TT.Deaths);
    dataG = synchronize(dataG,TT);
    dataG.Cumulative_deaths = dataG.Cum_deaths;
end
% compute mortatility rate (cond on tested)
dataG.cfr = dataG.Cumulative_deaths./dataG.Cumulative_cases;


posI         = 105;
noI          = 627;
posG         = 22;
noG          = 129;
pI           = posI/noI;                % detection probability Ischgl
pG           = posG/noG;                % detection probability Gangelt




dataG = dataG(1:end,:);
dataG(isnan(dataG.cfr),:) = [];
for i = 1:size(dataG,1)   
lambdaI = noI/dataG.Cumulative_cases(i);
lambdaG = noG/dataG.Cumulative_cases(i);
Z       = [dataG.cfr(i)*pG; dataG.cfr(i)*pI];
AvarX   = [ dataG.cfr(i)*(1-dataG.cfr(i))   0                   0;
            0                               pG*(1-pG)/lambdaG   0;
            0                               0                   pI*(1-pI)/lambdaI];
AX      = [ pG dataG.cfr(i) 0;
            pI 0            dataG.cfr(i)];
VarZ    = (AX*AvarX*AX')./dataG.Cumulative_cases(i);       

% Germany/Gangelt == Germany/Ischgl
R = [1 -1];
r = 0;
W_GGvsGI(i,1) = (R*Z-r)'*inv(R*VarZ*R')*(R*Z-r);
p_GGvsGI(i,1) = 1-chi2cdf(W_GGvsGI(i,1),size(r,1));

if dataG.Date_reported(i) == '01-May-2020'
    disp(['This is the p-value on 01-05-2020: ' num2str(p_GGvsGI(i,1))])
end
end

