clear
clc
close all
warning('off','MATLAB:table:ModifiedAndSavedVarnames');

% select region (Ischgl or Gangelt)
regn = 'Ischgl';
% select number of days by which deaths should be shifted
death_shift_start = 11;
death_shift_end   = 27;
death_shift_vec   = (death_shift_start:death_shift_end)';
ifr_ser           = zeros(length(death_shift_vec),5);
% If Germany, decide whether or not to use Nowcasting data
nowcast = 1;
reset_death = 1;
% Select date of interest
seldate     = '2020-05-01';

if (nowcast == 0) && (reset_death == 1)
    error('Makes no sense')
end

for k = 1:size(death_shift_vec,1)
    death_shift = death_shift_vec(k);
    % load data
data = readtable('Fallzahlen_RKI.csv'); % https://www.rki.de/DE/Content/InfAZ/N/Neuartiges_Coronavirus/Daten/Fallzahlen_Kum_Tab.html
data = table2timetable(table(datetime(data.Date_reported,'InputFormat','dd.MM.yyyy'),...
    data.New_cases,data.Cases,data.New_deaths,data.Deaths,'VariableNames',{'Date','New_Cases','Sum_cases','New_deaths','Sum_deaths'}));
data.Properties.DimensionNames{1} = 'Date_reported';

    if nowcast == 1
        data2 = readtable('Nowcasting_Zahlen.csv');
        data2.Properties.VariableNames{1} = 'Infection_Date';
        data2.Properties.VariableNames{2} = 'New_Cases_nowcast';
        data2 = table2timetable(table(datetime(data2.Infection_Date,'InputFormat','dd.MM.yyyy'),...
        data2.New_Cases_nowcast,'VariableNames',{'Date','New_Cases_nowcast'}));
        data2.Cum_cases_nowcast = cumsum(data2.New_Cases_nowcast);
        data = synchronize(data,data2);
        data.Cumulative_cases = data.Cum_cases_nowcast;
        data = data(timerange(data2.Date(1),data.Date_reported(end)),:);
    else 
        data.Cumulative_cases = data.Sum_cases;
    end
    if reset_death == 0
        T2 = table2timetable(table(data.Date_reported,data.Sum_deaths,...
            'VariableNames',{'Date','Deaths'}));
        TT = lag(T2,-death_shift);
        data = synchronize(data,TT);
        data.Cumulative_deaths = data.Deaths;
    else
        T2 = table2timetable(table(data.Date_reported,data.New_deaths,...
            'VariableNames',{'Date','Deaths'})); 
        TT = lag(T2,-death_shift); 
        TT.Cum_deaths = cumsum(TT.Deaths);
        data = synchronize(data,TT);
        data.Cumulative_deaths = data.Cum_deaths;
    end
    % compute mortatility rate (cond on tested)
    mort = data.Cumulative_deaths./data.Cumulative_cases;
    data.Var9 = mort;
    % switch to timetable
    % data = table2timetable(data);

    idx = isnan(data.Var9);
    data(idx,:) = [];
    % define beginning of plot
    date_max = '2020-09-14';
    TR = timerange('2020-03-01',date_max);
    data = data(TR,:);

    if strcmp(regn,'Ischgl') 
        pos         = 105;
        no          = 627;
    elseif strcmp(regn,'Gangelt')
        pos         = 22;
        no          = 129;    
    end
    p           = pos/no;
    p_var       = p-p.^2;
    var_corr2   = p_var*(no/(no-1));
    sd2         = sqrt(var_corr2);
    se_p        = sd2/(sqrt(no));

    cfr         = data.Var9(seldate); % read out most recent cfr
    n           = data.Cumulative_cases(seldate); % read out most recent number of + cases
    cfr_var     = cfr-cfr.^2;
    var_corr    = cfr_var*(n/(n-1));
    sd          = sqrt(var_corr);
    se_cfr      = sd/(sqrt(n));

    ifr         = cfr*p;
    se_tot      = sqrt(cfr.^2*se_p.^2+p.^2*se_cfr.^2);
    CI          = [ifr-norminv(0.975)*se_tot ifr+norminv(0.975)*se_tot];
    
    ifr_ser(k,:)=[death_shift_vec(k),ifr,CI,se_tot];
end

ifr_ser = array2table(ifr_ser,'VariableNames',{'death_shift','ifr','CI_lower',...
    'CI_upper','se'});

figure
plot(ifr_ser.death_shift, ifr_ser.CI_lower*100,'Color',[165 30 55]/255,'Linewidth',1);
hold on
plot(ifr_ser.death_shift, ifr_ser.CI_upper*100,'Color',[165 30 55]/255,'Linewidth',1);
shade(ifr_ser.death_shift, ifr_ser.CI_lower*100,ifr_ser.death_shift, ifr_ser.CI_upper*100,...
    'FillType',[1 2; 2 1],'Color',[165 30 55]/255);
plot(ifr_ser.death_shift,ifr_ser.ifr*100,'Color',[165 30 55]/255,'Linewidth',2.5)
xticks(death_shift_start:2:death_shift_end)
hold off
hAx=gca; 
hAx.YAxis.Limits = [0 1.5];
yticks(0:0.25:1.5)
hAx.XAxis.Limits = [death_shift_start death_shift_end];
set(gca,'FontSize',13,'TickLabelInterpreter','latex')
xlabel('\#days by which fatalities are shifted','interpreter','latex')
formatOut = 'ddmmmyyyy';
saveas(gcf,['IFR_Germany_' regn '_fatalityshift_' datestr(seldate,formatOut)],'epsc')

% ifr_ser_short = ifr_ser;
% [m_in,Idx_min]=min(ifr_ser_short.ifr);
% ifr_ser_short(Idx_min,:)
% [m_max,Idx_max]=max(ifr_ser_short.ifr);
% ifr_ser_short(Idx_max,:)