/**********************************************************************/
/* 
   Program:  	my_gar.prg	
   Subject:     Routinen fr DChoice0.prg  
   Date:        14.9.99
   Time:
   Comments:    Loglikelihod function for GAR-MNP
   Author(s):   M. Scheidler  
*/
/***********************************************************************/


/*************** Bildung der Gewichte- Matrix W **********************
**************** Das Ergebnis ist eine Blockdiagonale ***************
**************** Gewichte- Matrix *************************************/

/*************** Weight Matrix W **********************
**************** result is  Blockdiagonal ***************
**************** Weight Matrix *************************************/

proc w_matrix(matr,betta,angebote,atcor1,atcor2,corr1_on,corr2_on,nopara,gew_funk);
local gr_tab, i, k, p, j, t, mult, gr_tab1, s, ss, gr_tab3;
local  gr_tab4, m1, m2, m3, d, ii, sp, kk, blok_d, sum_b,matr1,koef;
local nopmin, nopmax;
/*
rows(matr);; cols(matr);
wait;
maxc(angebote);
wait;
*/
gr_tab=zeros(rows(matr),maxc(angebote));
nopmax=nopara+2;

if corr1_on eq 1;
  matr1  = atcor1;
endif;
if corr2_on eq 1;
  matr1  = atcor2;
endif;
if corr1_on eq 1 and corr2_on eq 1;
  matr1  = atcor1~atcor2;
endif;

nopmin = nopara+2;
if _model eq 51 or _model eq 45;
  nopmin = nopara+1;
endif;
nopmax = nopmin+cols(matr1);
/*
"nopmin:";;nopmin;;" nopmax. ";;nopmax;
"rows(beta(): ";;rows(betta[nopmin+1:nopmax]);
"matr1: ";; rows(matr1);; " x ";; cols(matr1);
*/

   i=1; p=1; t=0;
  do until i> rows(angebote);
    k=1;
    do until k > angebote[p];
      j =1;
      do until j>angebote[p];
        if (k==j) ;
          gr_tab[k+t,j]=0;
        else;
           if gew_funk ==1;
             gr_tab[k+t,j]= 1;
           elseif gew_funk==2;
             gr_tab[k+t,j]= exp(-abs(matr1[k+t,.]/100-matr1[t+j,.]/100)*betta[nopmin+1:nopmax]);
           elseif gew_funk==3;
             gr_tab[k+t,j]= exp(-abs(matr1[k+t,.]/1000-matr1[t+j,.]/1000)*2*betta[nopmin+1:nopmax]);
           elseif gew_funk==4;
             gr_tab[k+t,j]=sumc(((1/ln(2+abs(matr1[k+t,.]-matr1[t+j,.])))^betta[nopmin+1:nopmax]')');
           elseif gew_funk==5;
             gr_tab[k+t,j]=sumc((( (1/cdfn(abs(matr1[k+t,.]/100-matr1[t+j,.]/100)))+
                         exp(-abs(matr1[k+t,.]/150-matr1[t+j,.]/150) )/2 )^betta[nopmin+1:nopmax]')');
           elseif gew_funk ==6;
             gr_tab[k+t,j]= sumc(((1/(1+abs(matr1[k+t,.]-matr1[t+j,.])))^betta[nopmin+1:nopmax]')');
           elseif gew_funk==7;
             gr_tab[k+t,j]= exp(-((abs(matr1[k+t,.]/100-matr1[t+j,.]/100))^2)*betta[nopmin+1:nopmax]);
           endif;
 
        endif;
        j=j+1;
      endo;
      k=k+1;
    endo;
    i=i+1;
    t=t+angebote[p];
    p=p+1;
  endo;

/* Renormierung ??? */
gr_tab3=gr_tab;
gr_tab1=gr_tab*ones(cols(gr_tab),rows(gr_tab));
gr_tab1=gr_tab1[1:rows(gr_tab),1:cols(gr_tab)];
gr_tab4= gr_tab3 ./ gr_tab1;

/********** Bildung der Blockdiagonalen Matrix *******/
/****************************************************/
/********** Construct Blockdiagonal Matrix *******/
/****************************************************/

format /ldn 8,6;
if rows(angebote)==1;
blok_d=gr_tab4;
else;
d=rows(gr_tab4)-cols(gr_tab4);
blok_d=zeros(rows(gr_tab4),d);
blok_d=gr_tab4~blok_d;
endif;
ii=angebote[1]+1;
sp=1;
sum_b= angebote[1];
 kk=2;
do until ii > rows(blok_d);

           do until sp  > angebote[kk];
           blok_d[ii,sum_b+sp]= blok_d[ii,sp];
           blok_d[ii,sp]=0;
           sp=sp+1;
           endo;
     sp=1;
    ii=ii+1;

   if ii > sum_b+ angebote[kk] ;
      sum_b=sum_b+angebote[kk];    kk=kk+1;

endif;

 if kk > rows(angebote); break; endif;
endo;
format /ld 8,4;
/*print " die Blockdiagonale Matrix: " blok_d; wait;*/

retp(blok_d);
endp;

/********* Prozedur zur Berechnung der Logit- Wahrscheinlichkeiten ****
********** fr die sptere Simulation **************************************/
/********* Procedure for logit probabiliteis****
********** for later simulation **************************************/


proc logit_wh(reg_t,unr_t,ii,angebote,zuf_matr);
local util, rndom_f, i, k, p, sum_util, sum_ang, count, sum_zw,s, summen;
local whrsch,t,M,zuf_v ;
zuf_v=zuf_matr[.,ii];
if _model==40 or _model==45;
  M=unr_t*zuf_v;
elseif _model==11;
  M=unr_t;
elseif _model==22 or _model==27;
  M=unr_t*zuf_v;
else;
  "ERROR: Wrong model specified in my_gar.prg";
  stop;
endif;

util= reg_t +M;

util= exp(util);
sum_util=zeros(rows(angebote),1);
count=1;
i=1; p=1; sum_ang=0; sum_zw=0;
do until i > rows(util);
    k=0;
             do until k > angebote[p]-1;
              sum_util[count] =  util[i+k,1];
              sum_zw= sum_zw +sum_util[count];
              k= k+1;
              sum_util[count]=sum_zw;
              if k == angebote[p];
              sum_zw=0;
             endif;
             endo;

   sum_ang=sum_ang+ angebote[p];
   p=p+1;   count=count +1;
   i=sum_ang+1;
   if p > rows(angebote);
   break;
   endif;
 endo;
i=1; k=1; p=1; s=1;sum_zw= 0;
summen= ones(rows(util),1);

p=1;
 do until p > rows(angebote);
     k=1;
  do until k > angebote[p] ;
          summen[s] = sum_util[p];
         s=s+1;
          k=k+1;
       endo;
     p= p+1;
  if s > rows(util) or p > rows(angebote);
       break;
       endif;
endo;

whrsch = util ./ summen;
retp(whrsch);

endp;


/*  Originalfassung (Original) 

proc maxutiod(odno,util);
local r,od,count,indx,eact,maxuti,nofiti,chosen;
r =rows(util);
od=maxc((odno)');
chosen=zeros(r,1);
count=1; do until count > od;  
  indx     = packr(miss(seqa(1,1,r).* (odno .== count),0));
  nofiti    = rows(indx);
  maxuti    = maxc(util[indx]).*ones(nofiti,1);
  chosen[indx]   = ((util[indx] .== maxuti) + 0.000001*ones(nofiti,1))/sumc((util[indx] .== maxuti) + 0.000001*ones(nofiti,1));  
  count 	= count+1;
endo;
retp(chosen);
endp;

*/

proc maxutiod(odno,util);
/* odno    = Vektor von Nummern des Marktes, 
   util    = Vektor der Nutzen  	   
*/ 

/* odno    = Vektor of numbers of markets, 
   util    = Vektor of utilities  	   
*/ 


local r,od,count,indx,eact,maxuti,nofiti,chosen;
r =rows(util);
od=maxc((odno)');
chosen=zeros(r,1);
count=1; do until count > od;  
  indx     = packr(miss(seqa(1,1,r).* (odno .== count),0));
  nofiti    = rows(indx);
  maxuti    = exp(10*util[indx]);
  chosen[indx]   = maxuti/sumc(maxuti);  
  count 	= count+1;
/*  odno[indx]~util[indx]~maxuti~chosen[indx]; wait; */
endo;
retp(chosen);
endp;




/**************************************************/

proc rect_wh(reg_t,unr_t,ii,odno,zuf_matr);
local util, rndom_f, i, k, p, sum_util, sum_ang, count, sum_zw,s, summen;
local whrsch,t,M,zuf_v ;
zuf_v=zuf_matr[.,ii];
if _model==40;
  M=unr_t*zuf_v;
elseif _model==11;
  M=unr_t;
elseif _model==22 or _model==27;
  M=unr_t*zuf_v;
else;
  "ERROR: Wrong model specified in my_gar.prg";
  stop;
endif;

util= reg_t +M;

whrsch = maxutiod(odno,util);
retp(whrsch);
endp;



/*********** Prozedur zum Simulieren der Probit- Wahrscheinlichkeiten
************ mit Verwendung des Frequency- Simulators **************/


/*********** Procedure to simulate Probit-Probabilities
************ using the frequency-simulator**************/

proc simulat(reg,unreg,Rep,zuf_matr);
local summe, buffer, prob,i,kk,rn_f,zuf_vec;

 i=1;
buffer=zeros(rows(reg),1);
 do until i > Rep;

if (_kernel eq 1);
 summe= rect_wh(reg,unreg,i,marktno,zuf_matr);
else;
 summe= logit_wh(reg,unreg,i,angebote,zuf_matr);
endif;

 buffer = buffer + summe;
 i= i+1;
 endo;

 prob= buffer ./ Rep;

/*  format /rd 10,5;
    marktno~prob; wait;  */ 
 retp(prob);
endp;
/************************************************************/

/********* Prozedur zur Berechnung eines Spaltenvektors,
********** der die Anzahl der  Angebote in den einzelnen
********** Mrkten enthlt *******************************/

/********* procedure to compute column vector,
********** containing the number of itineraries in the 
********** markets *******************************/

proc angebot(dta);
local i,r,count,angebot;
i=1; r=1;
format /rdn 8,0;
count =1;
angebot=ones(maxc(dta[.,ord1ad]),1);
do until i > (rows(dta) -1);
 if dta[i,ord1ad] == dta[i+1,ord1ad];
   r = r+1;
   angebot[count] = r;
   i = i+1;
 elseif dta[i,ord1ad] /= dta[i+1,ord1ad];
   count = count+1;
   r=1;
   i=i+1;
 endif;
endo;
retp (angebot);
endp;