/**********************************************************************/
/* 

   Program: 	Simulation of additional flight with GAR-MNP
   Subject:  	                		
   Date: 	23.10.2000
   Author(s):   Michael Scheidler  
   Comments:    
			
*/
/***********************************************************************/

new;
clearg _mnpsc,_mnpint,_qdfmth,_qdford,_rtnrep,_rtnpnt;
library gaussx;
#include DChPrgs.prg;
library cml;

/**********************************************************************/


/***        	Data                               ***/

/* data			= "C:\\ABCMNP\\gausdata\\markt1ad";*/
 data			      = "markt1ad";

 minzeil               	=    1;    
 maxzeil               	=  21; 
 open fh = ^data for read; 
 dta     = readr(fh,maxzeil);

/***         Definitions                   ***/

 " ... definitions";

 _model			=   45;  /* GAR */
 _qdfrep            	=   20;   
 _qdfrlz               	=   100;  
 _IterKer			=  1000;  

mnp_func=2;
                      
 fourtyp			=    1;   /* (1: A sin(wt+phi), 2: A sin(wt)+ b cos(wt) )  */
 
 let depcen1           	= Pax;         			/* endogenous variables 			*/     
 let indcen1           	= nonstop
				   elap_nst
                                   di_onl				   
 				   lh_onl  ; 			/* exogenous variables 			*/
 let fourcen1            = depmin;
 let four_anz            = 3; 
 let four_per             = 1440;
 let corr1_on          	= 1;              	
 let corr2_on          	= 0;                 	
 let corrcen1          	= depmin;             	/* continuous correlation	*/
 let corrcen2          	= lh_onl;      	       /* dichotomous correlation	*/
 let ordcen1           	= marktno;           	/* odering variable - market 		*/
 let ordcen2           	= nummer;           	/* ordering  variable - alternatives 	*/

/***        1.5.     Parameters                            ***/

" ... parameters";

 bpara_on              = 1; 
 bcorr_on               = 0; 
 bspec_on	      = 0; 
 bparam                = {             
                6.42		,
               -0.02		, 		
				0.86    	,	 
 				1.02		,
				1.09 	 	,
            	1.21		,
            	0.20     	,
	    		3.23		,
	    		2.66 		,	
            	1.87      
			 			};
 bcorr         	= {0.62,6.26}; 
 bspecial        	= 1;  

 rndstart	= 99;
 _ghkall	= 1;

/* Adresses computation */

 labels  =  getname(data);
 depad   =  indcv(depcen1,labels);
 indad   =  indcv(indcen1,labels);
 ord1ad  =  indcv(ordcen1,labels);
 ord2ad  =  indcv(ordcen2,labels);
 four1ad =  indcv(fourcen1,labels);
 corr1ad =  indcv(corrcen1,labels);
 corr2ad =  indcv(corrcen2,labels);


x=bparam|bcorr;

_kernel=0;
if ( _model ge 40 );
  rndseed rndstart;
  zuf_matr=rndn(rows(dta),_IterKer);
  angebote=angebot(dta);
  marktno   = dta[.,ord1ad];
endif;

#include DChUti_A.prg; 


/******************************************************************************/
/************************** Simulation 21 alternatives **********************/
/******************************************************************************/

" ... simulation part 1";

library gaussx;
#include DChUti_D.prg; 

paxsim21=paxmnp[1:20];

/******************************************************************************/
/************************** Simulation 20 alternatives **********************/
/******************************************************************************/

" ... simulation part 2";

maxzeil               	=  20; 

tmp = sortc(dta,ord2ad);
dta  = tmp[1:20,.];

if ( _model ge 40 );
  rndseed rndstart;
  zuf_matr=rndn(rows(dta),_IterKer);
  angebote=angebot(dta);
  marktno   = dta[.,ord1ad];
endif;


#include DChUti_D.prg; 

paxsim20=paxmnp;

/************************* graphical output ******************************/

" ... graphics";

paxdiff	=paxsim21-paxsim20;
paxdelta	=paxdiff./paxsim20*100; 

library cml,pgraph;
#include cml.ext;
#include pgraph.ext;
CMLset;
graphset;
XTICS(0,21,1,1);
YTICS(-40,20,5,1); 

_pdate = "";
_paxes = 1;
_plwidth = { 1, 1, 1, 1 };
_pframe = 0;

_paxht=0.22;
_payht=0.22;
_ptitlht=0.25;


YLABEL("\204Change of choice probability (%)"); 
XLABEL("Numbering of alternatives ");
TITLE("\201GAR"); 

Xval		=	nummer;
Yval		=	paxdelta;

bar(Xval,Yval);

"... done.";

end;


/************************** 	End    ************************************/

