/**********************************************************************/
/* 

   Program: 	Simulation of additional flight with NL
   Subject:  	                		
   Date: 	23.10.2000
   Author(s):   Michael Scheidler  
   Comments:    
			
*/
/***********************************************************************/

new;
#include DNLPrgs.prg;
library cml;

/**********************************************************************/


/***        	Data                               ***/

 /*data			= "C:\\ABCMNP\\gausdata\\markt1ad";*/
 data			      = "markt1ad";

 minzeil               	=    1;    
 maxzeil               	=  21; 
 open fh = ^data for read; 
 dta     = readr(fh,maxzeil);

/***         Definitions                   ***/

 " ... definitions";
 let depcen1           	= Pax;         			/* endogenous variables 			*/     
 let indcen1           	= nonstop
				   elap_nst
                                   di_onl				   
 				   lh_onl  ; 			/* exogenous variables 			*/
 let nestcen1           = nest6A;
 let ordcen1           	= marktno;           	
 let ordcen2           	= nummer;           	

/***        1.5.     Parameters                            ***/

" ... parameters";
 bpara_on              = 1; 

/* parameters first level */
  param1               = {     
   6.52954 
  -0.02483 
   0.95508 
   1.05958 
		                  };  

/* parameters second level */
  param2               = {     
   0.25616 
  -0.79368 
  -1.36859 
  -1.24481 
  -0.52141 
  -1.86576                 };  

/* Adresses computation */

 labels  =  getname(data);
 depad   =  indcv(depcen1,labels);
 indad   =  indcv(indcen1,labels);
 ord1ad  =  indcv(ordcen1,labels);
 ord2ad  =  indcv(ordcen2,labels);
 nestad  =  indcv(nestcen1,labels);

/******************************************************************************/
/************************** Simulation 21 alternatives **********************/
/******************************************************************************/

" ... simulation part 1";
nofl = rows(dta); 

k=rows(dta);
cl=cols(dta);
odno    = dta[.,ord1ad];
no        = dta[.,ord2ad];
nestno = dta[.,nestad];

tempno	=(100000*odno)+100*nestno+no;
dta2	=tempno~dta;
dta2	=sortc(dta2,1);
dta	=dta2[.,2:cols(dta2)];

odno     = dta[.,ord1ad];
no         = dta[.,ord2ad];
nestno  = dta[.,nestad];
tempno	=(100000*odno)+100*nestno+no;
tempmod = tempno-tempno%100;
tempmod2=tempmod[1]|tempmod[1:rows(tempmod)-1];
value   =(tempmod.==tempmod2);
count	=1;
laufno	=0;
laufod	=1;
nestno1=zeros(k,1);
no1=zeros(k,1);
do until count>k;
  if (value[count]==1);
    laufno = laufno+1;
  else;
    laufno=1;
    laufod=laufod+1;
  endif;
  nestno1[count] =laufod;
  no1[count]=laufno;
  count = count +1;
endo;

dta = dta~nestno1~no1;
nestn1ad=cl+1;
nestn2ad=cl+2;

attr		=dta[.,indad];
pax		=dta[.,depad];
utility1	=mkutil(attr,param1')'; 
utility1      =utility1[.,1];
share1	=prepcmnl(nestno1,no1,utility1);

count=1;
anznest	= maxc(nestno1);
anzntyp   = maxc(nestno);
rnest	= rows(nestno1);
emu2	=zeros(anznest,1);
pax2	=zeros(anznest,1);
odno2	=zeros(anznest,1);
nesttyp2	=zeros(anznest,1);
nestno2	=zeros(anznest,1);
nofiti2	=zeros(anznest,1);
no2		=zeros(anznest,1);
laufno      =1;

do until count > anznest;
   indx    = packr(miss(seqa(1,1,rnest).* (nestno1 .== count),0)); 
   emu2[count]    = ln(sumc(utility1[indx])+0.0000001); 
   pax2[count]   = sumc(pax[indx]);
   odno2[count]   = maxc(odno[indx]);
   nestno2[count] = maxc(nestno1[indx]);
   nesttyp2[count] = maxc(nestno[indx]);
   nofiti2[count]   = rows(indx);
   if ((count gt 1) and (odno2[count] ne odno2[count-1]));
     laufno=1;
   endif;
   no2[count]=laufno; 

   laufno=laufno+1;
   count = count +1;
endo;

count=2;
if count le anzntyp;
xnest=zeros(anznest,anzntyp-1);
endif;
do until count > anzntyp;
 indx    = packr(miss(seqa(1,1,anznest).* (nesttyp2 .== count),0));
 xnest[indx,count-1] = ones(rows(indx),1);
 count = count +1;
endo;

data2 = odno2~no2~pax2~emu2;
if (anzntyp gt 1);
data2 = odno2~no2~pax2~emu2~xnest;
endif;

attr2		=emu2~xnest;
utility2	=mkutil(attr2,param2')'; 
utility2      =utility2[.,1];
share2h	=prepcmnl(odno2,no2,utility2);

share2=zeros(rnest,1);

count=1;
do until count > anznest;
    indx    = packr(miss(seqa(1,1,rnest).* (nestno1 .== count),0));
    count2 = nestno2[count];
    share2[indx] = share2h[count2]*ones(rows(indx),1);
count=count+1;
endo;

share=share1.*share2;
sharesim=share;
paxsim 	= shar2pax(odno,pax,sharesim);
paxsim21=paxsim[1:9]|paxsim[11:21];

/******************************************************************************/
/************************** Simulation 20 alternatives **********************/
/******************************************************************************/

" ... simulation part 2";

maxzeil               	=  20; 

tmp = sortc(dta,ord2ad);
dta  = tmp[1:20,.];
nofl = rows(dta);

/* #include DChUti_A.prg; */

k=rows(dta);
cl=cols(dta);
odno    = dta[.,ord1ad];
no        = dta[.,ord2ad];
nestno = dta[.,nestad];

tempno	=(100000*odno)+100*nestno+no;
dta2	=tempno~dta;
dta2	=sortc(dta2,1);
dta	=dta2[.,2:cols(dta2)];

odno     = dta[.,ord1ad];
no         = dta[.,ord2ad];
nestno  = dta[.,nestad];
tempno	=(100000*odno)+100*nestno+no;
tempmod = tempno-tempno%100;
tempmod2=tempmod[1]|tempmod[1:rows(tempmod)-1];
value   =(tempmod.==tempmod2);
count	=1;
laufno	=0;
laufod	=1;
nestno1=zeros(k,1);
no1=zeros(k,1);
do until count>k;
  if (value[count]==1);
    laufno = laufno+1;
  else;
    laufno=1;
    laufod=laufod+1;
  endif;
  nestno1[count] =laufod;
  no1[count]=laufno;
  count = count +1;
endo;

dta = dta~nestno1~no1;
nestn1ad=cl+1;
nestn2ad=cl+2;

attr		=dta[.,indad];
pax		=dta[.,depad];
utility1	=mkutil(attr,param1')'; 
utility1      =utility1[.,1];
share1	=prepcmnl(nestno1,no1,utility1);

count=1;
anznest	= maxc(nestno1);
anzntyp   = maxc(nestno);
rnest	= rows(nestno1);
emu2	=zeros(anznest,1);
pax2	=zeros(anznest,1);
odno2	=zeros(anznest,1);
nesttyp2	=zeros(anznest,1);
nestno2	=zeros(anznest,1);
nofiti2	=zeros(anznest,1);
no2		=zeros(anznest,1);
laufno      =1;

do until count > anznest;
   indx    = packr(miss(seqa(1,1,rnest).* (nestno1 .== count),0)); 
   emu2[count]    = ln(sumc(utility1[indx])+0.0000001); 
   pax2[count]   = sumc(pax[indx]);
   odno2[count]   = maxc(odno[indx]);
   nestno2[count] = maxc(nestno1[indx]);
   nesttyp2[count] = maxc(nestno[indx]);
   nofiti2[count]   = rows(indx);
   if ((count gt 1) and (odno2[count] ne odno2[count-1]));
     laufno=1;
   endif;
   no2[count]=laufno; 

   laufno=laufno+1;
   count = count +1;
endo;

count=2;
if count le anzntyp;
xnest=zeros(anznest,anzntyp-1);
endif;
do until count > anzntyp;
 indx    = packr(miss(seqa(1,1,anznest).* (nesttyp2 .== count),0));
 xnest[indx,count-1] = ones(rows(indx),1);
 count = count +1;
endo;

data2 = odno2~no2~pax2~emu2;
if (anzntyp gt 1);
data2 = odno2~no2~pax2~emu2~xnest;
endif;

attr2		=emu2~xnest;
utility2	=mkutil(attr2,param2')'; 
utility2      =utility2[.,1];
share2h	=prepcmnl(odno2,no2,utility2);

share2=zeros(rnest,1);

count=1;
do until count > anznest;
    indx    = packr(miss(seqa(1,1,rnest).* (nestno1 .== count),0));
    count2 = nestno2[count];
    share2[indx] = share2h[count2]*ones(rows(indx),1);
count=count+1;
endo;

share=share1.*share2;
sharesim=share;
paxsim 	= shar2pax(odno,pax,sharesim);
paxsim20=paxsim;

/************************* graphical output ******************************/

" ... graphics";

paxdiff	=paxsim21-paxsim20;
paxdelta	=paxdiff./paxsim20*100; 

library cml,pgraph;
#include cml.ext;
#include pgraph.ext;
CMLset;
graphset;
XTICS(0,21,1,1);
YTICS(-40,20,5,1); 

_pdate = "";
_paxes = 1;
_plwidth = { 1, 1, 1, 1 };
_pframe = 0;

_paxht=0.22;
_payht=0.22;
_ptitlht=0.25;


YLABEL("\204Change of choice probability (%)"); 
XLABEL("Numbering of alternatives ");
TITLE("\201NL"); 

Xval		=	no;
Yval		=	paxdelta;

bar(Xval,Yval);

"... done.";

end;


/************************** 	End    ************************************/

