function [ beta_lambda_diff, sqrt_beta_lambda_var, beta_lambda_pval ] = get_beta_lambda_diff( beta_lambda, beta_lambda_vec_vc, factor_choice, asset_1, asset_2, excess_returns )
% Auxiliary procedure for two-pass regression in a_T g_T = 0 setup:
% Procedure computes for selected factors (factor_choice - we select the
% respective row of beta_lambda) the differences of beta_lambda for two
% test assets (asset_1, asset_2) which are identified by the second and
% third input parameter

% We return the associated standard error of the difference along with the
% p_value of a test that the difference is zero. This is a simple Wald test

N=size(excess_returns,2);

% We read out the "factor_coice" rows of beta_lambda
beta_lambda_row=beta_lambda(factor_choice,:);

% We construct the "identifying vector" which has dimension Nx1 and two
% non-zero elements, a one at the "asset_1" position and a minus one at the
% "asset_2" position
identifying_vector=zeros(N,1);
identifying_vector(asset_1,1)=1;
identifying_vector(asset_2,1)=-1;

beta_lambda_diff=beta_lambda_row*identifying_vector;

% We need to identify the "sub-vc-matrix" for the two test assets we want
% to compare

from=(factor_choice-1)*N+1;
to=factor_choice*N;

block_vc=beta_lambda_vec_vc(from:to,from:to);
beta_lambda_var=identifying_vector'*block_vc*identifying_vector;
sqrt_beta_lambda_var=sqrt(beta_lambda_var);

% Wald test and corresponding p-value
waldstat=beta_lambda_diff/beta_lambda_var*beta_lambda_diff;
beta_lambda_pval=1-chi2cdf(waldstat,1);

end

