function [ startvals ] = get_parameters( mim_base_assets, mim_proj_var, analysis, excess_returns, factors )
% Computes parameters for the two-pass regression with mimicking portfolios
% by running the respective regressions separately

% OLS regression of the mimicking portfolio

% include a constant
x_used=[ones(size(mim_base_assets,1),1),mim_base_assets];


b=(x_used'*x_used)\(x_used'*mim_proj_var);

mim_par=b(2:size(b,1));                 % slopes
mim_const=b(1,1);                       % constant

mim_pag=mim_base_assets*mim_par;        % mimicking portfolio

if analysis==7
    x=[ones(size(mim_pag,1),1),factors,mim_pag];
    param=(x'*x)\(x'*excess_returns);   % time series regressions
    
    alphas=param(1,:)';
    betas_mat=param(2:size(param,1),:);
    betas_mat=betas_mat';
    betas=param(2:size(param,1),:);
    betas=betas(:);
    lambdas_w=mean(factors)';            % factor means (not factors to be 
                                        % mimicked)
    lambdas_pag=mean(mim_pag)';          % mimicking portfolio mean
    lambdas=(betas_mat'*betas_mat)\(betas_mat'*mean(excess_returns)');
    
    startvals=[alphas;betas;lambdas;lambdas_w;lambdas_pag;mim_const;mim_par];
    
else
    display('Anaylsis must be set to analysis=7. Program stops.');
    stop;
    
end

end

