/************************************************************************
 This Gauss program estimates ACH model 
 James D. Hamilton and Oscar Jorda (1999)
 "A Model for the Federal Funds Rate Target"
************************************************************************/

library pgraph,optmum;
graphset; optset;   
format 16,8;

#include readdatb4.prg;  @ reads in data @  

/*******************************************************************************************
	set subsample and model to be analyzed
*******************************************************************************************/
sample = 2;

	/*************************
		first subsample (comment out if not used)
	 *************************/

/******* The results for the first subsample are presented in Table 3 in the thesis*********/
if sample ==1;
t0 = 1;
t1 = 300;
z = ones(oldcapt,1) ~ lagfomc[1:oldcapt];
kbet =	1;                @ use kbet = 0 to constrain beta to some value @
kthet = 	1;                @ use kthet = 0 to constrain theta to equal zero @  


	/*************************
		second subsample with data through 2001 (comment out if not used)
         *************************/

/******* The results for the second subsample are presented in Table 4 in the thesis*********/
elseif sample == 2;
z = ones(oldcapt,1) ~ fomc[1:oldcapt] ~ abs(spread6[1:oldcapt]);
t0 = 301;
t1 = oldcapt;
kbet =	0;                @ use kbet = 0 to constrain beta to some value @
kthet = 	1;                @ use kthet = 0 to constrain theta to equal zero @ 

	/*************************
		complete sample (comment out if not used)
        *************************/
elseif sample == 3;
z = ones(oldcapt,1);
t0 = 1;
t1 = oldcapt;
kbet = 1;
kthet = 1;  
else;
"not defined";
endif;


/**********************************************************************************************
	set control parameters
*********************************************************************************************/
kz = 		cols(z);          @ kz is the number of explanatory variables, including constant term @
meandur = meanc(duration[t0:t1,1]);
meanspread= meanc(abs(spread6[t0:t1,1]));
dellit = 	0.1;              @ dellit is smoothness parameter for transition between m(z) = 0 and
                                    m(z) = z @
delsmall = 0.0001;      @ delsmall is the value of el(0) in equation (13) @
kc = 		1;                @ use kc = 2 to print values when likelihood called
                                    kc = 1 for no print @
kqopt = 	1;	          @ use kqopt = 1 for numerical search to avoid crash
                                    use kqopt = 2 for calculation of final standard errors @

kinit = 	0;                @ use kinit = 1 to estimate initial condition
                                    use kinit = 0 to constrain it to the average @                                            
q = 		zeros(oldcapt,1);    @ will be filled in with values of q when proc is called @
h = 		0;                @ will be filled in with values of hazards when proc is called @


#include maxseek.src;

/************************************************************************************
	set initial values for parameters 
************************************************************************************/
th0 = 	zeros(kz,1);
th0[1,1] =3;
if kz > 1;
	th0[2,1] = -2;
endif;

if kthet > 0;
    th0 = th0 | sqrt(0.1);
endif;
if kbet > 0;
    th0 = th0 | 1;
endif;
if kinit > 0;
     th0 = th0 | sqrt(meandur);
endif;

kth = rows(th0);     @ kth is the number of parameters @

proc startval;     @ This defines starting value for iteration to be th0 @
  retp(th0); endp;

"Initial values";
ach2001(th0);


/**********************************************************************************************
 estimate parameters by maximum likelihood 
**********************************************************************************************/
"";"------------------------";"";
kc = 1;

     #include optmum.ext;
      _opalgr = 2;    @ This chooses BFGS optimization  @
      _opmiter = 300;  @ This controls the maximum number of iterations @

       {thx,f,g,h} =optmum(&ach2001,startval);


kqopt = 2;
if kthet > 0;
     thx[kz+1,1] = thx[kz+1,1]^2;
endif;
if kbet > 0;
    thx[kz+kthet+1,1] = thx[kz+kthet+1,1]^2/(1+thx[kz+kthet+1,1]^2);
endif;
if kinit > 0;
     thx[kz+kthet+kbet+1,1] = thx[kz+kthet+kbet+1,1]^2;
endif;

"";"";"Final results";"MLE as parameterized for numerical optimization ";
"Coefficients:";thx';
"";"Value of log likelihood:";;-f;
"";"Gradient vector:";g';

"==================================";
kc = 2;
call ach2001(thx);

/* ------------------------------------------------------------------------------------------------------------------------
   === CALCULATE STANDARD ERRORS === */

kc = 1;
g = gradp(&ach2001,thx);
"";"Numerically calculated gradient:";g;
"";"";
hs = (hessp(&ach2001,thx));
   va = eigrs(hs);
   if minc(eigrs(hs)) <= 0;
        "Negative of Hessian is not positive definite";
        "Either you have not found local maximum, or else estimates are up "
        "against boundary condition.  In latter case, impose the restricted "
        "params rather than estimate them to calculate standard errors";
    else;
       hs = invpd(hs);
       std = diag(hs)^.5;
       "For vector of coefficients parameterized as follows,";(thx)';
       "the standard errors are";std';maxseek_par = thx; 
/*i included a t-test for the null hypothesis that the parameter equals 0*/


if sample ==1;
output file = maxseek_par1.prg reset; 
output on;
"maxseek_par1 = {"; thx "};";       
output off;
elseif sample ==2;
output file = maxseek_par2.prg reset; 
output on;
"maxseek_par2 = {"; thx "};";       
output off;
else;
"not  defined ";
endif;
 output file = maxseek.out;  
 output on;
 "sample: ";; sample;
 " if sample = 1: first period if sample = 2. second period ";
        maxseek_par = thx ~ std ~(thx ./ std); 
        " estimates and standard errors  and t -test";
        maxseek_par;
        " max likelihood value";
        -f;
output off;       
    endif;
"variance covariance matrix is";
format /m3;
hs;
format /m1;
hs;

