/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.helper;

import java.util.ArrayList;
import java.util.Date;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.Integer32;
import org.openmuc.jsml.structures.Integer64;
import org.openmuc.jsml.structures.Integer8;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SML_Boolean;
import org.openmuc.jsml.structures.Unsigned16;
import org.openmuc.jsml.structures.Unsigned32;
import org.openmuc.jsml.structures.Unsigned64;
import org.openmuc.jsml.structures.Unsigned8;

import de.ekut.informatik.kn.josef.mycosem.InterfaceClass;
import de.ekut.informatik.kn.josef.myjsml.SML_CosemValue;

/**
 * Helper class. Holds static helper methods. Holds static methods to transform
 * jSML values (SML_CosemValue) to raw values (Java types) and vice versa.
 * 
 * @author Daniel Fuchs
 */
public class Helper {

    /**
     * Finds an object in an array list of objects. Objects are equal if their
     * classID and logicalName are equal.
     * 
     * @param classID
     * @param objName
     * @param objList
     * @return
     */
    public static InterfaceClass findObjectInList(Integer16 classID,
            OctetString objName, ArrayList<InterfaceClass> objList) {
        InterfaceClass o;
        for (int i = 0; i < objList.size(); i++) {
            o = objList.get(i);
            // if classID and logicalName are equal, the object is found
            if (o.getClassID().getVal() == classID.getVal()
                    && o.getLogicalName().equals(objName)) {
                return o;
            }
        }
        // no object was found
        return null;
    }

    /**
     * Gets the time now in ms.
     * 
     * @return time
     */
    public static long getTime() {
        return new Date().getTime();
    }

    /**
     * Transforms a SML_CosemValue to a raw value. Caution with unsigned values!
     * 
     * @param value
     *            SML_CosemValue
     * @return Object {boolean, String, byte, short, int, long}
     */
    public static Object getRawValue(SML_CosemValue value) {
        ASNObject val = value.getChoice();

        if (val instanceof SML_Boolean) {
            SML_Boolean tmp = (SML_Boolean) val;
            boolean v = tmp.getVal();
            return v;
        }
        if (val instanceof OctetString) {
            OctetString tmp = (OctetString) val;
            String v = tmp.toString();
            return v;
        }

        if (val instanceof Integer8) {
            Integer8 tmp = (Integer8) val;
            byte v = tmp.getVal();
            return v;
        }
        if (val instanceof Integer16) {
            Integer16 tmp = (Integer16) val;
            short v = tmp.getVal();
            return v;
        }
        if (val instanceof Integer32) {
            Integer32 tmp = (Integer32) val;
            int v = tmp.getVal();
            return v;
        }
        if (val instanceof Integer64) {
            Integer64 tmp = (Integer64) val;
            long v = tmp.getVal();
            return v;
        }

        if (val instanceof Unsigned8) {
            Unsigned8 tmp = (Unsigned8) val;
            int v = tmp.getVal();
            return v;
        }
        if (val instanceof Unsigned16) {
            Unsigned16 tmp = (Unsigned16) val;
            int v = tmp.getVal();
            return v;
        }
        if (val instanceof Unsigned32) {
            Unsigned32 tmp = (Unsigned32) val;
            int v = tmp.getVal();
            return v;
        }
        if (val instanceof Unsigned64) {
            Unsigned64 tmp = (Unsigned64) val;
            long v = tmp.getVal();
            return v;
        }
        return null;
    }

    /**
     * Transforms a SML_CosemValue to a Number. Caution with unsigned values!
     * 
     * @param value
     *            SML_CosemValue
     * @return Number {byte, short, int, long}
     */
    public static Number getNumberValue(SML_CosemValue value) {
        ASNObject val = value.getChoice();

        if (val instanceof Integer8) {
            Integer8 tmp = (Integer8) val;
            byte v = tmp.getVal();
            return v;
        }
        if (val instanceof Integer16) {
            Integer16 tmp = (Integer16) val;
            short v = tmp.getVal();
            return v;
        }
        if (val instanceof Integer32) {
            Integer32 tmp = (Integer32) val;
            int v = tmp.getVal();
            return v;
        }
        if (val instanceof Integer64) {
            Integer64 tmp = (Integer64) val;
            long v = tmp.getVal();
            return v;
        }

        if (val instanceof Unsigned8) {
            Unsigned8 tmp = (Unsigned8) val;
            int v = tmp.getVal();
            return v;
        }
        if (val instanceof Unsigned16) {
            Unsigned16 tmp = (Unsigned16) val;
            int v = tmp.getVal();
            return v;
        }
        if (val instanceof Unsigned32) {
            Unsigned32 tmp = (Unsigned32) val;
            int v = tmp.getVal();
            return v;
        }
        if (val instanceof Unsigned64) {
            Unsigned64 tmp = (Unsigned64) val;
            long v = tmp.getVal();
            return v;
        }
        return null;
    }

}
