/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.myjsml;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;

import org.openmuc.jsml.structures.ImplicitChoice;
import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.Integer32;
import org.openmuc.jsml.structures.Integer64;
import org.openmuc.jsml.structures.Integer8;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SML_Boolean;
import org.openmuc.jsml.structures.Unsigned16;
import org.openmuc.jsml.structures.Unsigned32;
import org.openmuc.jsml.structures.Unsigned64;
import org.openmuc.jsml.structures.Unsigned8;

/**
 * This class extends jSML's original ImplicitChoice class with COSEM-service
 * support according to the SML standard version 1.04.
 *
 * @author Daniel Fuchs
 * @author Michael Hoefling
 */
public abstract class ExtendedImplicitChoice extends ImplicitChoice {

    public static final int LISTOFSingle = 7;
    public static final int LISTOFMultiple = 15;

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        PushbackInputStream ispushback = new PushbackInputStream(is);
        DataInputStream is2 = new DataInputStream(ispushback);
        // byte tlField = is2.readByte();
        byte tlFieldChoice = (byte) ispushback.read();
        if (isOptional && (tlFieldChoice == 0x01)) {
            isSelected = false;
            return true;
        }
        // if ((tlField & 0xff) != 0x71 ) {
        // return false;
        // }

        // read type-part of tlFieldChoice
        switch ((tlFieldChoice & 0xF0) >> 4) {

        case LISTOFMultiple: // 8+7=15 -> 8 is MSB1 for the case "additional TL
                             // byte follows"
            choice = new SML_CosemValueList();
            break;

        case LISTOFSingle: // no additional TL byte
            choice = new SML_CosemValueList();
            break;

        case OctetString:
            choice = new OctetString();
            break;

        case SML_Boolean:
            choice = new SML_Boolean();
            break;

        case Integer:
            // read length-part of tlFieldChoice
            switch (tlFieldChoice & 0x0F) {
            case 2:
                choice = new Integer8();
                break;
            case 3:
                choice = new Integer16();
                break;
            case 4:
            case 5:
                choice = new Integer32();
                break;
            case 6:
            case 7:
            case 8:
            case 9:
                choice = new Integer64();
                break;
            default:
                return false;
            }

            break;

        case Unsigned:
            // read length-part of tlFieldChoice
            switch (tlFieldChoice & 0x0F) {
            case 2:
                choice = new Unsigned8();
                break;
            case 3:
                choice = new Unsigned16();
                break;
            case 4:
            case 5:
                choice = new Unsigned32();
                break;
            case 6:
            case 7:
            case 8:
            case 9:
                choice = new Unsigned64();
                break;
            default:
                return false;
            }

            break;
        // another TL-Field follows
        // this is only possible if an octetstring was sent
        case TL_Field:
            choice = new OctetString();
            break;
        default:
            return false;
        }

        // push back the TL-field of the choice-object
        ispushback.unread(tlFieldChoice);
        if (!choice.decode(is2)) {
            return false;
        }

        isSelected = true;
        return true;
    }
}
