/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.myjsml;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.Sequence;
import org.openmuc.jsml.structures.Unsigned8;

/**
 * Representation of a SML_ActionCosemReq, as specified in SML v1.04.
 * 
 * @author Daniel Fuchs
 */
public class SML_ActionCosemReq extends Sequence {

    protected OctetString clientId;
    protected OctetString serverId; // OPTIONAL
    protected OctetString username; // OPTIONAL
    protected OctetString password; // OPTIONAL
    protected OctetString objName; // COSEM object name
    protected Integer16 classID; // COSEM class_id
    protected Integer16 classVersion; // COSEM class_version
    protected Unsigned8 serviceIndex;
    protected SML_CosemValue serviceParameter; // OPTIONAL

    public OctetString getClientId() {
        return clientId;
    }

    public OctetString getServerId() {
        return serverId;
    }

    public OctetString getUsername() {
        return username;
    }

    public OctetString getPassword() {
        return password;
    }

    public OctetString getObjName() {
        return objName;
    }

    public Integer16 getClassID() {
        return classID;
    }

    public Integer16 getClassVersion() {
        return classVersion;
    }

    public Unsigned8 getServiceIndex() {
        return serviceIndex;
    }

    public SML_CosemValue getServiceParameter() {
        return serviceParameter;
    }

    /**
     * Constructor
     * 
     * @param clientId
     * @param serverId
     *            OPTIONAL
     * @param username
     *            OPTIONAL
     * @param password
     *            OPTIONAL
     * @param objName
     * @param classID
     * @param classVersion
     * @param serviceIndex
     * @param serviceParameter
     *            OPTIONAL
     */
    public SML_ActionCosemReq(OctetString clientId, OctetString serverId,
            OctetString username, OctetString password, OctetString objName,
            Integer16 classID, Integer16 classVersion, Unsigned8 serviceIndex,
            SML_CosemValue serviceParameter) {

        if (clientId == null) {
            throw new IllegalArgumentException(
                    "SML_ActionCosemtReq: clientId is not optional and must not be null!");
        }
        if (objName == null) {
            throw new IllegalArgumentException(
                    "SML_ActionCosemtReq: objName is not optional and must not be null!");
        }
        if (classID == null) {
            throw new IllegalArgumentException(
                    "SML_ActionCosemtReq: classID is not optional and must not be null!");
        }
        if (classVersion == null) {
            throw new IllegalArgumentException(
                    "SML_ActionCosemtReq: classVersion is not optional and must not be null!");
        }
        if (serviceIndex == null) {
            throw new IllegalArgumentException(
                    "SML_ActionCosemtReq: serviceIndex is not optional and must not be null!");
        }

        this.clientId = clientId;
        this.serverId = serverId;
        this.username = username;
        this.password = password;
        this.objName = objName;
        this.classID = classID;
        this.classVersion = classVersion;
        this.serviceIndex = serviceIndex;
        this.serviceParameter = serviceParameter;

        if (this.serverId == null) {
            this.serverId = new OctetString();
        }
        if (this.username == null) {
            this.username = new OctetString();
        }
        if (this.password == null) {
            this.password = new OctetString();
        }
        if (this.serviceParameter == null) {
            this.serviceParameter = new SML_CosemValue();
        }

        setOptionalAndSeq();
        isSelected = true;
    }

    public SML_ActionCosemReq() {
    }

    public void setOptionalAndSeq() {
        serverId.setOptional();
        username.setOptional();
        password.setOptional();
        serviceParameter.setOptional();

        seqArray = new ASNObject[] { clientId, serverId, username, password,
                objName, classID, classVersion, serviceIndex,
                serviceParameter };
    }

    @Override
    protected void createElements() {

        clientId = new OctetString();
        serverId = new OctetString();
        username = new OctetString();
        password = new OctetString();
        objName = new OctetString();
        classID = new Integer16();
        classVersion = new Integer16();
        serviceIndex = new Unsigned8();
        serviceParameter = new SML_CosemValue();

        setOptionalAndSeq();
    }

    @Override
    public void print() {
        if (!isOptional || isSelected) {
            System.out.println("SML_ActionCosemReq: ");
            super.print();
        }
    }

}
