/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.myjsml;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.EndOfSmlMessage;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SML_Message;
import org.openmuc.jsml.structures.Unsigned16;
import org.openmuc.jsml.structures.Unsigned8;

/**
 * This class extends the SML_Message class with COSEM-service support according
 * to the SML standard version 1.04.
 * 
 * @author Daniel Fuchs
 * @author Michael Hoefling
 */
public class SML_COSEM_Message extends SML_Message {

    @Override
    protected void createElements() {
        transactionId = new OctetString();
        groupNo = new Unsigned8();
        abortOnError = new Unsigned8();
        messageBody = new SML_COSEM_MessageBody();
        crc16 = new Unsigned16();
        endOfSmlMsg = new EndOfSmlMessage();
        seqArray = new ASNObject[] { transactionId, groupNo, abortOnError,
                messageBody, crc16, endOfSmlMsg };
    }

}
