/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.myjsml;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Sequence;

/**
 * Representation of a SML_CosemVAttribute, as specified in SML v1.04.
 * 
 * @author Daniel Fuchs
 */
public class SML_CosemAttribute extends Sequence {

    protected SML_CosemAttributeDesc attributeDescription;
    protected SML_CosemAttributeContent attributeContent;

    public SML_CosemAttributeDesc getAttributeDescription() {
        return attributeDescription;
    }

    public SML_CosemAttributeContent getAttributeContent() {
        return attributeContent;
    }

    public SML_CosemAttribute(SML_CosemAttributeDesc attributeDescription,
            SML_CosemAttributeContent attributeContent) {

        if (attributeDescription == null) {
            throw new IllegalArgumentException(
                    "SML_CosemAttribute: attributeDescription is not optional and must not be null!");
        }
        if (attributeContent == null) {
            throw new IllegalArgumentException(
                    "SML_CosemAttribute: attributeContent is not optional and must not be null!");
        }

        this.attributeDescription = attributeDescription;
        this.attributeContent = attributeContent;

        setOptionalAndSeq();
        isSelected = true;
    }

    public SML_CosemAttribute() {
    }

    public void setOptionalAndSeq() {
        seqArray = new ASNObject[] { attributeDescription, attributeContent };
    }

    @Override
    protected void createElements() {
        attributeDescription = new SML_CosemAttributeDesc();
        attributeContent = new SML_CosemAttributeContent();
        setOptionalAndSeq();
    }

    @Override
    public void print() {
        if (!isOptional || isSelected) {
            System.out.println("SML_CosemAttribute: ");
            super.print();
        }
    }

}
