/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.myjsml;

import org.openmuc.jsml.structures.SequenceOf;
import org.openmuc.jsml.structures.Unsigned8;

/**
 * Representation of a SML_CosemSelAccessDesc, as specified in SML v1.04.
 * 
 * @author Daniel Fuchs
 */
public class SML_CosemSelAccessDesc extends SequenceOf {

    protected Unsigned8[] accessSelector;
    protected SML_CosemValue[] accessParameters;

    public Unsigned8[] getAccessSelector() {
        return accessSelector;
    }

    public SML_CosemValue[] getAccessParameters() {
        return accessParameters;
    }

    public SML_CosemSelAccessDesc(Unsigned8[] accessSelector,
            SML_CosemValue[] accessParameters) {
        this.accessSelector = accessSelector;
        this.accessParameters = accessParameters;
        seqArray = accessSelector; // simplification of optional field
        isSelected = true;
    }

    public SML_CosemSelAccessDesc() {
    }

    @Override
    protected void createElements(int length) {
        accessSelector = new Unsigned8[length];
        for (int i = 0; i < length; i++) {
            accessSelector[i] = new Unsigned8();
        }
        seqArray = accessSelector;

        accessParameters = new SML_CosemValue[length];
        for (int i = 0; i < length; i++) {
            accessParameters[i] = new SML_CosemValue();
        }
        // seqArray = accessParameters; // simplification
    }

}
