/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.myjsml;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.Sequence;

/**
 * Representation of a SML_GetCosemRes, as specified in SML v1.04.
 * 
 * @author Daniel Fuchs
 */
public class SML_GetCosemRes extends Sequence {

    protected OctetString clientId; // OPTIONAL
    protected OctetString serverId;
    protected OctetString objName;
    protected Integer16 classID;
    protected Integer16 classVersion;
    protected SML_CosemAttrList attributeList;

    public OctetString getClientId() {
        return clientId;
    }

    public OctetString getServerId() {
        return serverId;
    }

    public OctetString getObjName() {
        return objName;
    }

    public Integer16 getClassID() {
        return classID;
    }

    public Integer16 getClassVersion() {
        return classVersion;
    }

    public SML_CosemAttrList getAttributeList() {
        return attributeList;
    }

    /**
     * Constructor
     * 
     * @param clientId
     *            OPTIONAL
     * @param serverId
     * @param objName
     * @param classID
     * @param classVersion
     * @param attributeList
     */
    public SML_GetCosemRes(OctetString clientId, OctetString serverId,
            OctetString objName, Integer16 classID, Integer16 classVersion,
            SML_CosemAttrList attributeList) {

        if (serverId == null) {
            throw new IllegalArgumentException(
                    "SML_GetCosemtRes: serverId is not optional and must not be null!");
        }
        if (objName == null) {
            throw new IllegalArgumentException(
                    "SML_GetCosemtRes: objName is not optional and must not be null!");
        }
        if (classID == null) {
            throw new IllegalArgumentException(
                    "SML_GetCosemtRes: classID is not optional and must not be null!");
        }
        if (classVersion == null) {
            throw new IllegalArgumentException(
                    "SML_GetCosemtRes: classVersion is not optional and must not be null!");
        }
        if (attributeList == null) {
            throw new IllegalArgumentException(
                    "SML_GetCosemtRes: attributeList is not optional and must not be null!");
        }

        this.clientId = clientId;
        this.serverId = serverId;
        this.objName = objName;
        this.classID = classID;
        this.classVersion = classVersion;
        this.attributeList = attributeList;

        if (this.clientId == null) {
            this.clientId = new OctetString();
        }

        setOptionalAndSeq();
        isSelected = true;
    }

    public SML_GetCosemRes() {
    }

    public void setOptionalAndSeq() {
        clientId.setOptional();
        seqArray = new ASNObject[] { clientId, serverId, objName, classID,
                classVersion, attributeList };
    }

    @Override
    protected void createElements() {
        clientId = new OctetString();
        serverId = new OctetString();
        objName = new OctetString();
        classID = new Integer16();
        classVersion = new Integer16();
        attributeList = new SML_CosemAttrList();

        setOptionalAndSeq();
    }

    @Override
    public void print() {
        if (!isOptional || isSelected) {
            System.out.println("SML_GetCosemRes: ");
            super.print();
        }
    }

}
