/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.restserver.resources;

import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.sun.jersey.api.NotFoundException;

import de.ekut.informatik.kn.josef.restserver.model.RestModel;
import de.ekut.informatik.kn.josef.restserver.schema.LdevType;

/**
 * Class that represents a RESTful server resource.
 * 
 * @author Daniel Fuchs
 */
@Path("cosem/ldevs/{devID}")
public class LdevResource {

    /**
     * Gets a logical device.
     * 
     * @param depth
     * @param devID
     * @return
     */
    @GET
    @Produces(MediaType.APPLICATION_XML)
    public LdevType getLdevQuery(@QueryParam("q.depth") String depth,
            @PathParam("devID") String devID) {
        int dep = RestModel.parseDepth(depth);
        LdevType ld = RestModel.getLdevQuery(dep, devID);
        if (ld != null) {
            return ld;
        } else {
            throw new NotFoundException();
        }
    }

    /**
     * Allowed methods on this resource: GET, OPTIONS, HEAD.
     * 
     * @return
     */
    @OPTIONS
    public Response options() {
        return Response.ok()
                .header("Allow-Control-Allow-Methods", "GET,OPTIONS,HEAD")
                .header("Access-Control-Allow-Origin", "*").build();
    }

}
