/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.restserver.resources;

import java.net.URI;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import com.sun.jersey.api.NotFoundException;

import de.ekut.informatik.kn.josef.restserver.model.RestModel;
import de.ekut.informatik.kn.josef.restserver.schema.ObjectType;
import de.ekut.informatik.kn.josef.restserver.schema.ObjectsType;

/**
 * Class that represents a RESTful server resource.
 * 
 * @author Daniel Fuchs
 */
@Path("cosem/ldevs/{devID}/objects")
public class ObjectsResource {

    @Context
    UriInfo uriInfo;

    /**
     * Gets an object list.
     * 
     * @param depth
     * @param devID
     * @return
     */
    @GET
    @Produces(MediaType.APPLICATION_XML)
    public ObjectsType getObjectsQuery(@QueryParam("q.depth") String depth,
            @PathParam("devID") String devID) {
        int dep = RestModel.parseDepth(depth);
        ObjectsType objects = RestModel.getObjectsQuery(dep, devID);
        if (objects != null) {
            return objects;
        } else {
            throw new NotFoundException();
        }
    }

    /**
     * Puts (or updates) an object.
     * 
     * @param devID
     * @param object
     * @return
     */
    @PUT
    @Consumes(MediaType.APPLICATION_XML)
    public Response putObjectType(@PathParam("devID") String devID,
            ObjectType object) {
        RestModel.putObject(object, devID);
        URI location = uriInfo.getAbsolutePathBuilder()
                .path("" + object.getId()).build();
        return Response.created(location).build();
    }

    /**
     * Allowed methods on this resource: PUT, GET, OPTIONS, HEAD.
     * 
     * @return
     */
    @OPTIONS
    public Response options() {
        return Response.ok()
                .header("Allow-Control-Allow-Methods", "PUT,GET,OPTIONS,HEAD")
                .header("Access-Control-Allow-Origin", "*").build();
    }

}
