/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.smartmeter.simulation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

/**
 * Class that provides methods to read in load profiles from files.
 * 
 * @author Daniel Fuchs
 */
public class LoadProfileReader {

    /**
     * Reads a load profile from a file. Reads the first #rows of a file and
     * converts each row into a double value. Returns an empty ArrayList, if
     * something went wrong.
     * 
     * @param rows
     *            0 for all rows, positive value for a specified number
     * @param fileName
     * @return
     */
    public static ArrayList<Double> readLoadProfile(int rows, String fileName) {
        // URL url = LoadProfileReader.class.getResource(fileName);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            InputStreamReader instream = new InputStreamReader(
                    LoadProfileReader.class.getResourceAsStream(fileName));
            // BufferedReader in = new BufferedReader(new
            // FileReader(url.getFile()));
            BufferedReader in = new BufferedReader(instream);
            String line = null;

            int i = 0;
            if (rows > 0) { // read only the first n rows
                while ((line = in.readLine()) != null && i < rows) {
                    try {
                        arrayList.add(Double.parseDouble(line));
                        i++;
                    } catch (NumberFormatException e) {
                        // e.printStackTrace();
                    }
                }
            } else { // read all available rows
                while ((line = in.readLine()) != null) {
                    try {
                        arrayList.add(Double.parseDouble(line));
                        i++;
                    } catch (NumberFormatException e) {
                        // e.printStackTrace();
                    }
                }
            }
            in.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return arrayList;
    }

}
