/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.smartmetergateway.cosem;

import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SML_Message;

/**
 * Class that represents a request. Internal use only.
 * 
 * @author Daniel Fuchs
 */
public abstract class CosemRequest {

    public final static int TYPE_GET = 1;
    public final static int TYPE_SET = 2;
    public final static int TYPE_ACTION = 3;

    protected int type;
    protected String objName;
    protected short classID;
    protected short classVersion;

    /**
     * Default constructor.
     * 
     * @param objName
     * @param classID
     * @param classVersion
     */
    public CosemRequest(String objName, short classID, short classVersion) {
        super();
        this.objName = objName;
        this.classID = classID;
        this.classVersion = classVersion;
    }

    public int getType() {
        return type;
    }

    public String getObjName() {
        return objName;
    }

    public short getClassID() {
        return classID;
    }

    public short getClassVersion() {
        return classVersion;
    }

    /**
     * Checks of the request is valid/complete.
     * 
     * @return
     */
    public abstract boolean isComplete();

    /**
     * Creates a SML message based on the request.
     * 
     * @param transactionID
     * @param clientID
     * @param serverID
     * @param username
     * @param password
     * @return
     */
    public abstract SML_Message createRequestMessage(OctetString transactionID,
            OctetString clientID, OctetString serverID, OctetString username,
            OctetString password);

}
