/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.smartmetergateway.cosem;

import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SML_Message;

import de.ekut.informatik.kn.josef.helper.SMLMessageCreator;
import de.ekut.informatik.kn.josef.myjsml.SML_CosemAttrList;
import de.ekut.informatik.kn.josef.myjsml.SML_CosemAttribute;
import de.ekut.informatik.kn.josef.myjsml.SML_CosemAttributeContent;
import de.ekut.informatik.kn.josef.myjsml.SML_CosemAttributeDesc;
import de.ekut.informatik.kn.josef.myjsml.SML_CosemValue;

/**
 * Class that represents a set request. Internal use only.
 * 
 * @author Daniel Fuchs
 */
public class SetRequest extends CosemRequest {

    protected short[] attributeIndexes; // non optional
    protected SML_CosemValue[] attributeContents; // non optional

    /**
     * Constructor.
     * 
     * @param objName
     * @param classID
     * @param classVersion
     * @param attIndexes
     * @param attContents
     */
    public SetRequest(String objName, short classID, short classVersion,
            short[] attIndexes, SML_CosemValue[] attContents) {
        super(objName, classID, classVersion);
        this.type = TYPE_SET;
        this.attributeIndexes = attIndexes;
        this.attributeContents = attContents;
    }

    public short[] getAttributeIndexes() {
        return attributeIndexes;
    }

    public SML_CosemValue[] getAttributeContents() {
        return attributeContents;
    }

    @Override
    public boolean isComplete() {
        return ((this.attributeIndexes != null)
                && (this.attributeContents != null)
                && (this.attributeIndexes.length == this.attributeContents.length));
    }

    @Override
    public SML_Message createRequestMessage(OctetString transactionID,
            OctetString clientID, OctetString serverID, OctetString username,
            OctetString password) {
        if (!isComplete())
            return null;

        SML_CosemAttribute[] attributeArray = new SML_CosemAttribute[this.attributeIndexes.length];
        for (int i = 0; i < this.attributeIndexes.length; i++) {
            SML_CosemAttribute att = new SML_CosemAttribute(
                    new SML_CosemAttributeDesc(
                            new Integer16(attributeIndexes[i]), null),
                    new SML_CosemAttributeContent(
                            SML_CosemAttributeContent.DATA,
                            attributeContents[i]));
            attributeArray[i] = att;
        }

        SML_CosemAttrList attrList = new SML_CosemAttrList(attributeArray);
        return SMLMessageCreator.createSetCosemRequestMessage(transactionID,
                clientID, serverID, new OctetString(this.objName),
                new Integer16(this.classID), new Integer16(this.classVersion),
                attrList, username, password);
    }

}
